/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.perfmon.PerfmonCounterDialog;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.StatisticalModelGraphViewer;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Dirtiable;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.views.adapter.internal.StatisticalViewerPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class StatisticalViewerUI
extends StatisticalModelGraphViewer {
    protected StatisticalViewerPage _page;

    public StatisticalViewerUI(Composite parent, int style, boolean tabfolder, StatisticalViewerPage page, Dirtiable d, URI current_project) {
        this(parent, style, tabfolder, d, current_project);
        this._page = page;
    }

    public StatisticalViewerUI(Composite parent, int style, boolean tabfolder, StatisticalViewerPage page) {
        this(parent, style, tabfolder);
        this._page = page;
    }

    public StatisticalViewerUI(Composite parent, int style, boolean tabfolder) {
        super(parent, style, tabfolder);
    }

    public StatisticalViewerUI(Composite parent, int style, boolean tabfolder, Dirtiable d, URI current_project) {
        super(parent, style, tabfolder, d, current_project);
    }

    public void updateUI() {
    }

    public Control getControl() {
        return this.sashfolder;
    }

    public void selectionChanged() {
        if (this.sashfolder == null || this.sashfolder.isDisposed() || !this.sashfolder.isVisible() || !this.sashfolder.isFocusControl()) {
            // empty if block
        }
    }

    public void refresh() {
        if (this.sashfolder != null && !this.sashfolder.isDisposed() && this.sashfolder.isVisible() && !this.sashfolder.isFocusControl()) {
            this.initialize();
        }
    }

    public void initialize() {
        this.resetValues();
        EObject object = HyadesUtil.getMofObject();
        if (object == null || !(object instanceof EObject)) {
            return;
        }
        try {
            this.getSDDescriptors(object);
            this.setConstantUpdate("VIEWER", true, 1000L);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        try {
            this.configureSliders();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private void configureSliders() throws Exception {
        double ctime;
        TimeZoomSlider xslider = this.getGraphWindow().getXSlider(0);
        double minvis = xslider.getMinVisible();
        double maxvis = xslider.getMaxVisible();
        double min = xslider.getMinLimit();
        double max = xslider.getMaxLimit();
        minvis = ctime = (double)System.currentTimeMillis();
        maxvis = ctime + 60000.0;
        min = Math.min(min, ctime - 3600000.0);
        max = Math.max(max, ctime + 8.64E7);
        xslider.configure(min, max, minvis, maxvis, xslider.getResolution());
        ZoomSlider yslider = this.getGraphWindow().getYSlider(0);
        minvis = yslider.getMinVisible();
        maxvis = Math.max(yslider.getMaxVisible(), 100.0);
        min = yslider.getMinLimit();
        max = Math.max(yslider.getMaxLimit(), maxvis * 10.0);
        yslider.configure(min, max, minvis, maxvis, yslider.getResolution());
    }

    protected void resetValues() {
        if (this.reverse_map != null) {
            this.reverse_map.clear();
        }
        if (this.graph_map != null) {
            this.graph_map.clear();
        }
        if (this.sddescriptor_map != null) {
            this.sddescriptor_map.clear();
        }
        if (this.chooser_tree != null) {
            this.chooser_tree.removeAll();
        }
        if (this.bar_map != null) {
            this.bar_map.clear();
        }
        if (this.bar_slider_map != null) {
            this.bar_slider_map.clear();
        }
        if (this.counter_map != null) {
            this.counter_map.clear();
        }
        if (this.modifiable_map != null) {
            this.modifiable_map.clear();
        }
        if (this.source_map != null) {
            this.source_map.clear();
        }
        if (this.graph_window != null) {
            this.graph_window.removeAllGraphs();
        }
        this.next = 0;
        this.prev_used = 0L;
        if (this.disposables != null) {
            this.disposables.clear();
        }
        if (this.modules != null) {
            this.modules.clear();
        }
        this.model_change_listeners.clear();
        this.agent_change_listeners.clear();
        this.node_change_listeners.clear();
        if (this.trcagent_map != null) {
            this.trcagent_map.clear();
        }
        if (this.msglist_map != null) {
            this.msglist_map.clear();
        }
        if (this.agents != null) {
            this.agents.clear();
        }
    }

    protected void getSDDescriptors(EObject mofObject) {
        block11: {
            block12: {
                if (mofObject == null) break block11;
                if (!(mofObject instanceof TRCAgentProxy)) break block12;
                if (((TRCAgentProxy)mofObject).getAgent() == null) break block11;
                this.addAgent(((TRCAgentProxy)mofObject).getAgent());
                new ConfigurePerfmonAction(((TRCAgentProxy)mofObject).getAgent());
                break block11;
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                for (int idx = 0; idx < agents.length; ++idx) {
                    if (((TRCAgentProxy)agents[idx]).getAgent() == null) continue;
                    this.addAgent(((TRCAgentProxy)agents[idx]).getAgent());
                    new ConfigurePerfmonAction(((TRCAgentProxy)agents[idx]).getAgent());
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                for (int idx = 0; idx < processes.length; ++idx) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    for (int i = 0; i < agents.length; ++i) {
                        if (((TRCAgentProxy)agents[i]).getAgent() == null) continue;
                        this.addAgent(((TRCAgentProxy)agents[i]).getAgent());
                        new ConfigurePerfmonAction(((TRCAgentProxy)agents[i]).getAgent());
                    }
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                for (int k = 0; k < nodes.length; ++k) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    for (int idx = 0; idx < processes.length; ++idx) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        for (int i = 0; i < agents.length; ++i) {
                            if (((TRCAgentProxy)agents[i]).getAgent() == null) continue;
                            this.addAgent(((TRCAgentProxy)agents[i]).getAgent());
                            new ConfigurePerfmonAction(((TRCAgentProxy)agents[i]).getAgent());
                        }
                    }
                }
            }
        }
    }

    class ConfigurePerfmonAction
    implements Runnable {
        Agent agent;
        TRCAgent trcagent;

        public ConfigurePerfmonAction(TRCAgent trcagent) {
            Agent agent;
            TRCAgentProxy aproxy = trcagent.getAgentProxy();
            Object obj = LoadersUtils.locateAgentInstance((TRCAgentProxy)aproxy);
            if (obj instanceof Agent && (agent = (Agent)obj) != null && agent.getType().equals("PerfmonAgent")) {
                this.trcagent = trcagent;
                this.agent = agent;
                StatisticalViewerUI.this.addAgentAction(trcagent, "CONFIGURE", PerfmonPlugin.getString((String)"CONFIGURE_PERFMON"), PerfmonPlugin.img.getImage("logo.gif"), this);
                StatisticalViewerUI.this.addModelAction(trcagent, "CONFIGURE", PerfmonPlugin.getString((String)"CONFIGURE_PERFMON"), PerfmonPlugin.img.getImage("logo.gif"), this);
            }
        }

        public void run() {
            PerfmonCounterDialog dialog = new PerfmonCounterDialog(StatisticalViewerUI.this.getGraphWindow().getShell(), this.trcagent, this.agent);
            dialog.open();
            StatisticalViewerUI.this.updateAgent(this.trcagent);
        }
    }
}

