/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.manual;

import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.hyades.test.manual.TestManualImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.CoreUtil;
import org.eclipse.hyades.ui.internal.util.ResourceBundleManager;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TestManualPlugin
extends AbstractUIPlugin {
    private static TestManualPlugin instance;
    private ResourceBundleManager resourceBundleManager;

    public TestManualPlugin(IPluginDescriptor iPluginDescriptor) {
        super(iPluginDescriptor);
        instance = this;
    }

    public static TestManualPlugin getInstance() {
        return instance;
    }

    public void startup() throws CoreException {
        this.resourceBundleManager = new ResourceBundleManager();
        this.resourceBundleManager.add(this.getDescriptor().getResourceBundle());
        this.resourceBundleManager.add(HyadesUIPlugin.getInstance().getResourceBundle());
        this.resourceBundleManager.add(TestUIPlugin.getInstance().getResourceBundle());
        super.startup();
        try {
            TestManualImages.INSTANCE.initialize(new URL(this.getDescriptor().getInstallURL(), "icons/full/"), this.getImageRegistry());
        }
        catch (Exception exception) {
            TestManualPlugin.logError(exception);
        }
    }

    public void shutdown() throws CoreException {
        this.resourceBundleManager.dispose();
        instance = null;
        super.shutdown();
    }

    public ResourceBundle getResourceBundle() {
        return this.getDescriptor().getResourceBundle();
    }

    public static String getID() {
        return instance.getDescriptor().getUniqueIdentifier();
    }

    public static void logError(Throwable throwable) {
        TestManualPlugin.logError(CoreUtil.getStackTrace((Throwable)throwable));
    }

    public static void logError(String string) {
        System.err.println("***** TestJavaPlugin.logError");
        System.err.println(string);
    }

    public static void logInfo(String string) {
        System.out.println("***** TestJavaPlugin.logInfo");
        System.out.println(string);
    }

    public static String getString(String string) throws NullPointerException, MissingResourceException {
        return TestManualPlugin.instance.resourceBundleManager.getString(string);
    }

    public static String getString(String string, String string2) throws NullPointerException, MissingResourceException {
        return TestManualPlugin.instance.resourceBundleManager.getString(string, string2);
    }

    public static String getString(String string, String[] stringArray) throws NullPointerException, MissingResourceException {
        return TestManualPlugin.instance.resourceBundleManager.getString(string, stringArray);
    }
}

