/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.java;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.eclipse.hyades.logging.core.LoggingAgent;
import org.eclipse.hyades.logging.java.XmlFormatter;

public class LoggingAgentHandler
extends Handler {
    public static final String DEFAULT_LOGGER_NAME = "Default Logging IRemoteEntity";
    private HashMap loggingAgents = new HashMap();
    private Object currentThreadLock = new Object();

    public LoggingAgentHandler() {
        LogManager logManager = LogManager.getLogManager();
        String className = this.getClass().getName();
        String defaultProperty = logManager.getProperty(className.concat(".level"));
        if (defaultProperty == null) {
            this.setLevel(Level.INFO);
        } else {
            try {
                this.setLevel(Level.parse(defaultProperty.trim()));
            }
            catch (Throwable t) {
                this.setLevel(Level.INFO);
            }
        }
        defaultProperty = logManager.getProperty(className.concat(".filter"));
        if (defaultProperty == null) {
            this.setFilter(null);
        } else {
            try {
                Class<?> filterClass = ClassLoader.getSystemClassLoader().loadClass(defaultProperty.trim());
                this.setFilter((Filter)filterClass.newInstance());
            }
            catch (Throwable t) {
                this.setFilter(null);
            }
        }
        defaultProperty = logManager.getProperty(className.concat(".formatter"));
        if (defaultProperty == null) {
            this.setFormatter(new XmlFormatter());
        } else {
            try {
                Class<?> formatterClass = ClassLoader.getSystemClassLoader().loadClass(defaultProperty.trim());
                this.setFormatter((Formatter)formatterClass.newInstance());
            }
            catch (Throwable t) {
                this.setFormatter(new XmlFormatter());
            }
        }
        defaultProperty = logManager.getProperty(className.concat(".encoding"));
        if (defaultProperty == null) {
            try {
                this.setEncoding(null);
            }
            catch (UnsupportedEncodingException u) {}
        } else {
            try {
                this.setEncoding(defaultProperty.trim());
            }
            catch (Throwable t) {
                try {
                    this.setEncoding(null);
                }
                catch (UnsupportedEncodingException u) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(LogRecord logRecord) {
        if (this.isLoggable(logRecord)) {
            String formattedLogRecord = null;
            Formatter formatter = this.getFormatter();
            if (formatter != null) {
                try {
                    formattedLogRecord = formatter.format(logRecord);
                }
                catch (Exception e) {
                    this.writeError(null, e, 5);
                    return;
                }
            } else {
                formattedLogRecord = logRecord.toString();
            }
            LoggingAgent logger = null;
            String loggerName = logRecord.getLoggerName();
            if (loggerName != null && loggerName.trim().length() != 0) {
                Object object = this.currentThreadLock;
                synchronized (object) {
                    if (this.loggingAgents.containsKey(loggerName)) {
                        logger = (LoggingAgent)this.loggingAgents.get(loggerName);
                    } else {
                        logger = new LoggingAgent(loggerName);
                        this.loggingAgents.put(loggerName, logger);
                    }
                }
            }
            Object object = this.currentThreadLock;
            synchronized (object) {
                if (this.loggingAgents.containsKey(DEFAULT_LOGGER_NAME)) {
                    logger = (LoggingAgent)this.loggingAgents.get(DEFAULT_LOGGER_NAME);
                } else {
                    logger = new LoggingAgent(DEFAULT_LOGGER_NAME);
                    this.loggingAgents.put(DEFAULT_LOGGER_NAME, logger);
                }
            }
            logger.write(formattedLogRecord);
        }
    }

    public void flush() {
        Iterator agents = this.loggingAgents.values().iterator();
        while (agents.hasNext()) {
            ((LoggingAgent)agents.next()).flush();
        }
    }

    public void close() {
        Iterator agents = this.loggingAgents.values().iterator();
        while (agents.hasNext()) {
            LoggingAgent current = (LoggingAgent)agents.next();
            current.flush();
            current.deregister();
        }
    }

    private void writeError(String message, Exception exception, int code) {
        try {
            this.getErrorManager().error(message, exception, code);
        }
        catch (Throwable t) {
            System.err.println("Error: " + t.getMessage());
            t.printStackTrace();
        }
    }
}

