/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.hyades.resources.database.internal.DBCollectedExceptions;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Database;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
import org.eclipse.hyades.resources.database.internal.impl.DBCommand;
import org.eclipse.hyades.resources.database.internal.impl.RDBHelper;

public class DropTableCommand
extends DBCommand {
    protected RDBHelper rdbHelper = new RDBHelper();

    public DropTableCommand(JDBCHelper helper, DBMap map) {
        super(helper, map);
    }

    public Object execute() throws Exception {
        Database database = this.dbMap.getDatabase();
        List tables = this.getTablesToDrop();
        ArrayList<String> statements = new ArrayList<String>();
        int l = tables.size();
        for (int i = 0; i < l; ++i) {
            Table table = (Table)tables.get(i);
            statements.add("DROP TABLE " + this.addQuotes(table.getName()));
        }
        DBCollectedExceptions collectedExceptions = new DBCollectedExceptions();
        int l2 = statements.size();
        for (int i = 0; i < l2; ++i) {
            try {
                this.helper.executeUpdateStatement((String)statements.get(i));
                continue;
            }
            catch (Exception e) {
                collectedExceptions.getExceptions().add(e);
            }
        }
        if (!collectedExceptions.getExceptions().isEmpty()) {
            throw collectedExceptions;
        }
        return null;
    }

    protected List getTablesToDrop() {
        ArrayList<Table> tables = new ArrayList<Table>();
        Table table = this.dbMap.getResourceTable();
        if (table != null) {
            tables.add(table);
        }
        if ((table = this.dbMap.getProxyTable()) != null) {
            tables.add(table);
        }
        if ((table = this.dbMap.getIdTable()) != null) {
            tables.add(table);
        }
        tables.addAll(this.dbMap.getReferenceTables());
        tables.addAll(this.dbMap.getAttributeTables());
        List classTables = this.dbMap.getClassTables();
        tables.addAll(classTables);
        return tables;
    }
}

