/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.impl.QueryStatement;

public class GreedyReferenceQueryStatement
extends QueryStatement {
    protected int[] ids;
    protected String source;
    protected String target;
    protected String order;
    protected boolean orderFlag;

    public GreedyReferenceQueryStatement(int[] ids, EReference reference, DBMap map, DatabaseType dbType, boolean orderFlag) {
        super(dbType, map, (EModelElement)reference);
        this.ids = ids;
        DBMap.ReferenceData data = (DBMap.ReferenceData)this.dbMap.getDBRepresentation((EModelElement)reference);
        this.source = data.getSourceColumn().getName();
        this.target = data.getTargetColumn().getName();
        if (data.getOrderColumn() != null) {
            this.order = data.getOrderColumn().getName();
        }
        this.initial = 0;
        this.orderFlag = orderFlag;
    }

    protected void createSelectFrom() {
        this.statement.append("SELECT ");
        this.statement.append(this.addQuotes(this.source));
        this.statement.append(", ");
        this.statement.append(this.addQuotes(this.target));
        if (this.orderFlag && this.order != null && this.dbType.isOrderRequired()) {
            this.statement.append(", ");
            this.statement.append(this.addQuotes(this.order));
        }
        this.statement.append(" FROM ");
        this.statement.append(this.addQuotes(this.table.getName()));
    }

    protected void createWhereClause(int begin) {
        this.statement.append(" WHERE ");
        this.statement.append(this.addQuotes(this.source));
        this.statement.append(" IN (");
        for (int i = begin; i < this.ids.length; ++i) {
            String id = "" + this.ids[i];
            if (this.statement.length() + id.length() > this.dbType.getMaximumSQLLength()) {
                this.initial = i;
                break;
            }
            if (i != begin) {
                this.statement.append(", ");
            }
            this.statement.append(this.ids[i]);
        }
        this.statement.append(")");
    }

    protected void createOrderClause() {
        if (this.orderFlag && this.order != null) {
            this.statement.append(" ORDER BY ");
            this.statement.append(this.addQuotes(this.source));
            this.statement.append(", ");
            this.statement.append(this.addQuotes(this.order));
        }
    }
}

