/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.impl.InsertStatement;

public class InsertAttributeValues
extends InsertStatement {
    protected EAttribute attribute;
    protected int type;
    protected Object value;
    protected int position;
    protected DBMap.AttributeData data;

    public InsertAttributeValues(DBMap map, DatabaseType dbType, Map objectsToIds, EAttribute attribute, int type) {
        super(map, dbType, objectsToIds);
        this.attribute = attribute;
        this.type = type;
        this.data = (DBMap.AttributeData)this.dbMap.getDBRepresentation((EModelElement)attribute);
    }

    protected Table getTable() {
        return this.data.getTable();
    }

    protected List getColumns() {
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(this.data.getIdColumn());
        columns.add(this.data.getValueColumn());
        columns.add(this.data.getOrderColumn());
        return columns;
    }

    protected void createRows(EObject object, boolean first) throws Exception {
        List values = (List)object.eGet((EStructuralFeature)this.attribute);
        int l = values.size();
        for (int i = 0; i < l; ++i) {
            this.value = values.get(i);
            this.position = i;
            this.addRow(object, first);
            if (!first) continue;
            first = false;
        }
    }

    protected void addRow(EObject object, boolean first) throws Exception {
        StringBuffer row = this.createRow(object);
        this.addRowToStatement(row, first);
    }

    protected StringBuffer createRow(EObject object) throws Exception {
        StringBuffer row = new StringBuffer();
        row.append("(");
        Integer id = (Integer)this.objectsToIds.get(object);
        row.append(id.toString());
        row.append(", ");
        this.appendValue(row, this.value, this.type);
        row.append(", ");
        row.append(this.position);
        row.append(")");
        return row;
    }

    protected void addBatchedRow(PreparedStatement ps, EObject object) throws Exception {
        int colPos = 1;
        Integer id = (Integer)this.objectsToIds.get(object);
        this.appendBatchedValue(ps, colPos++, id, 4);
        this.appendBatchedValue(ps, colPos++, this.value, this.type);
        this.appendBatchedValue(ps, colPos++, new Integer(this.position), 4);
        ps.addBatch();
    }

    protected void addBatchedRows(PreparedStatement ps, EObject object) throws Exception {
        List values = (List)object.eGet((EStructuralFeature)this.attribute);
        int i = 0;
        int l = values.size();
        while (i < l) {
            this.value = values.get(i);
            this.position = i++;
            this.addBatchedRow(ps, object);
        }
    }
}

