/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.impl.InsertStatement;

public class InsertReferences
extends InsertStatement {
    protected EReference reference;
    protected EReference opposite;
    protected boolean sourceOrder;
    protected boolean isMany;
    protected Set proxies;
    protected InternalEObject refObject;
    protected int position;
    protected DBMap.ReferenceData data;

    public InsertReferences(DatabaseType type, EReference reference, DBMap map, Map objectsToIds, Set proxies) {
        super(map, type, objectsToIds);
        this.reference = reference;
        this.proxies = proxies;
        this.isMany = reference.isMany();
        this.data = (DBMap.ReferenceData)this.dbMap.getDBRepresentation((EModelElement)reference);
    }

    protected Table getTable() {
        return this.data.getTable();
    }

    protected List getColumns() {
        DBMap.ReferenceData oppositeData;
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(this.data.getSourceColumn());
        columns.add(this.data.getTargetColumn());
        if (this.data.getOrderColumn() != null) {
            columns.add(this.data.getOrderColumn());
        }
        this.opposite = this.reference.getEOpposite();
        if (this.opposite != null && this.opposite.isMany() && (oppositeData = (DBMap.ReferenceData)this.dbMap.getDBRepresentation((EModelElement)this.opposite)) != null && oppositeData.getOrderColumn() != null) {
            this.sourceOrder = true;
            columns.add(oppositeData.getOrderColumn());
        }
        return columns;
    }

    protected void createRows(EObject object, boolean first) throws Exception {
        if (!this.isMany) {
            this.refObject = (InternalEObject)object.eGet((EStructuralFeature)this.reference);
            this.position = -1;
            this.addRow(object, first);
        } else {
            InternalEList list = (InternalEList)object.eGet((EStructuralFeature)this.reference);
            Iterator it = list.basicIterator();
            this.position = 0;
            while (it.hasNext()) {
                this.refObject = (InternalEObject)it.next();
                this.addRow(object, first);
                if (first) {
                    first = false;
                }
                ++this.position;
            }
        }
    }

    protected void addRow(EObject object, boolean first) throws Exception {
        StringBuffer row = this.createRow(object);
        if (row != null) {
            this.addRowToStatement(row, first);
        }
    }

    protected StringBuffer createRow(EObject object) throws Exception {
        Integer targetId = (Integer)this.objectsToIds.get(this.refObject);
        if (targetId == null) {
            return null;
        }
        StringBuffer row = new StringBuffer();
        row.append("(");
        Integer sourceId = (Integer)this.objectsToIds.get(object);
        row.append(sourceId.toString());
        row.append(", ");
        row.append(targetId.toString());
        if (this.position >= 0) {
            row.append(", ");
            row.append(this.position);
        }
        if (this.sourceOrder) {
            row.append(", ");
            if (!this.proxies.contains(this.refObject)) {
                List opposites = (List)this.refObject.eGet((EStructuralFeature)this.opposite);
                row.append(opposites.indexOf(object));
            } else {
                row.append("-1");
            }
        }
        row.append(")");
        return row;
    }

    protected void addBatchedRow(PreparedStatement ps, EObject object) throws Exception {
        Integer targetId = (Integer)this.objectsToIds.get(this.refObject);
        if (targetId == null) {
            return;
        }
        int colPos = 1;
        Integer sourceId = (Integer)this.objectsToIds.get(object);
        this.appendBatchedValue(ps, colPos++, sourceId, 4);
        this.appendBatchedValue(ps, colPos++, targetId, 4);
        if (this.position >= 0) {
            this.appendBatchedValue(ps, colPos++, new Integer(this.position), 4);
        }
        if (this.sourceOrder) {
            if (!this.proxies.contains(this.refObject)) {
                List opposites = (List)this.refObject.eGet((EStructuralFeature)this.opposite);
                this.appendBatchedValue(ps, colPos++, new Integer(opposites.indexOf(object)), 4);
            } else {
                this.appendBatchedValue(ps, colPos++, new Integer(-1), 4);
            }
        }
        ps.addBatch();
    }

    protected void addBatchedRows(PreparedStatement ps, EObject object) throws Exception {
        if (!this.isMany) {
            this.refObject = (InternalEObject)object.eGet((EStructuralFeature)this.reference);
            this.position = -1;
            this.addBatchedRow(ps, object);
        } else {
            InternalEList list = (InternalEList)object.eGet((EStructuralFeature)this.reference);
            Iterator it = list.basicIterator();
            this.position = 0;
            while (it.hasNext()) {
                this.refObject = (InternalEObject)it.next();
                this.addBatchedRow(ps, object);
                ++this.position;
            }
        }
    }
}

