/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.common.internal.editor;

import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.common.TestCommonPlugin;
import org.eclipse.hyades.test.common.internal.editor.BehaviorSection;
import org.eclipse.hyades.test.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class BehaviorForm
extends EditorForm
implements ISelectionChangedListener,
IITestSuiteProvider {
    protected static final int HELP_FORM_CONTROL = 1;
    protected static final int HELP_SECTION_CONTROL = 2;
    protected static final int HELP_NAMED_ELEMENT_CONTROL = 3;
    private BehaviorSection behaviorSection;
    private NamedElementSection commonSection;
    private DetailSection detailSection;
    private boolean firstActivation = true;

    public BehaviorForm(BaseEditorExtension baseEditorExtension, WidgetFactory widgetFactory) {
        super(baseEditorExtension, widgetFactory);
    }

    public void dispose() {
        this.behaviorSection.getTreeViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.behaviorSection.dispose();
        this.commonSection.dispose();
        if (this.detailSection != null) {
            this.detailSection.dispose();
        }
        super.dispose();
    }

    public ITestSuite getTestSuite() {
        return ((IITestSuiteProvider)this.getBaseEditorExtension()).getTestSuite();
    }

    protected void createEditorFormContents(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 15;
        composite.setLayout((Layout)gridLayout);
        Composite composite2 = this.createColumn(composite);
        Composite composite3 = this.createColumn(composite);
        this.behaviorSection = this.createBehaviorSection();
        this.registerSection((FormSection)this.behaviorSection);
        this.behaviorSection.setHeaderText(TestCommonPlugin.getString("W_BEHAVIOR"));
        Control control = this.behaviorSection.createControl(composite2, (FormWidgetFactory)this.getWidgetFactory());
        control.setLayoutData((Object)new GridData(1810));
        this.commonSection = new NamedElementSection((EditorForm)this);
        this.commonSection.setHeaderText(TestCommonPlugin.getString("TTL_CMN_PROPS"));
        this.registerSection((FormSection)this.commonSection);
        control = this.commonSection.createControl(composite3, (FormWidgetFactory)this.getWidgetFactory());
        GridData gridData = new GridData(770);
        control.setLayoutData((Object)gridData);
        DetailSection detailSection = new DetailSection((EditorForm)this);
        this.addDetails(detailSection);
        if (!detailSection.isEmpty()) {
            this.detailSection = detailSection;
            this.detailSection.setHeaderText(TestCommonPlugin.getString("TTL_DTL_PROPS"));
            this.registerSection((FormSection)this.detailSection);
            control = this.detailSection.createControl(composite3, (FormWidgetFactory)this.getWidgetFactory());
            gridData = new GridData(770);
            control.setLayoutData((Object)gridData);
        }
        this.registerHelp(1, composite);
        this.registerHelp(2, composite2);
        this.registerHelp(3, composite3);
    }

    protected abstract BehaviorSection createBehaviorSection();

    protected void addDetails(DetailSection detailSection) {
    }

    protected void registerHelp(int n, Object object) {
    }

    public void load() {
        this.behaviorSection.getTreeViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.behaviorSection.setInput(this.getTestSuite().getImplementor().getBlock());
        this.behaviorSection.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectReveal(ISelection iSelection) {
        this.behaviorSection.selectReveal(iSelection);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        if (selectionChangedEvent.getSource() == this.behaviorSection.getTreeViewer()) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getSelection();
            this.commonSection.setInput((Object)iStructuredSelection);
            if (this.detailSection != null) {
                this.detailSection.setInput((Object)iStructuredSelection);
            }
        }
    }

    public ISelection getSelection() {
        return this.behaviorSection.getTreeViewer().getSelection();
    }

    public boolean activated() {
        if (this.firstActivation) {
            this.firstActivation = false;
            this.behaviorSection.setFocus();
        }
        return super.activated();
    }

    public void updateTitle() {
    }
}

