/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.Logger;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;

public abstract class EMFPlugin
implements ResourceLocator,
Logger {
    protected ResourceLocator[] delegateResourceLocators;
    protected URL baseURL;
    protected ResourceBundle resourceBundle;
    protected Map strings = new HashMap();
    protected Map images = new HashMap();

    public EMFPlugin(ResourceLocator[] delegateResourceLocators) {
        this.delegateResourceLocators = delegateResourceLocators;
    }

    public abstract ResourceLocator getPluginResourceLocator();

    public Logger getPluginLogger() {
        return (Logger)((Object)this.getPluginResourceLocator());
    }

    public URL getBaseURL() {
        if (this.baseURL == null) {
            if (this.getPluginResourceLocator() == null) {
                try {
                    this.baseURL = new URL(URI.createURI(this.getClass().getResource("plugin.properties").toString()).trimSegments(1).toString() + "/");
                }
                catch (IOException exception) {
                    throw new WrappedException(exception);
                }
            } else {
                this.baseURL = this.getPluginResourceLocator().getBaseURL();
            }
        }
        return this.baseURL;
    }

    public Object getImage(String key) {
        Object result = (URL)this.images.get(key);
        if (result == null) {
            if (this.getPluginResourceLocator() == null) {
                try {
                    result = this.doGetImage(key);
                }
                catch (MalformedURLException exception) {
                    throw new WrappedException(exception);
                }
                catch (IOException exception) {
                    result = this.delegatedGetImage(key);
                }
            } else {
                try {
                    result = this.getPluginResourceLocator().getImage(key);
                }
                catch (MissingResourceException exception) {
                    result = this.delegatedGetImage(key);
                }
            }
            this.images.put(key, result);
        }
        return result;
    }

    protected Object doGetImage(String key) throws IOException {
        URL url = new URL(this.getBaseURL() + "icons/" + key + ".gif");
        InputStream inputStream = url.openStream();
        inputStream.close();
        return url;
    }

    protected Object delegatedGetImage(String key) throws MissingResourceException {
        int i = 0;
        while (i < this.delegateResourceLocators.length) {
            try {
                return this.delegateResourceLocators[i].getImage(key);
            }
            catch (MissingResourceException missingResourceException) {
                ++i;
            }
        }
        throw new MissingResourceException(CommonPlugin.INSTANCE.getString("_UI_ImageResourceNotFound_exception", new Object[]{key}), this.getClass().getName(), key);
    }

    public String getString(String key) {
        String result = (String)this.strings.get(key);
        if (result == null) {
            try {
                if (this.getPluginResourceLocator() == null) {
                    if (this.resourceBundle == null) {
                        this.resourceBundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".plugin");
                    }
                    result = this.resourceBundle.getString(key);
                } else {
                    result = this.getPluginResourceLocator().getString(key);
                }
            }
            catch (MissingResourceException exception) {
                result = this.delegatedGetString(key);
            }
            this.strings.put(key, result);
        }
        return result;
    }

    protected String delegatedGetString(String key) {
        int i = 0;
        while (i < this.delegateResourceLocators.length) {
            try {
                return this.delegateResourceLocators[i].getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                ++i;
            }
        }
        throw new MissingResourceException(MessageFormat.format("The string resource ''{0}'' could not be located", key), this.getClass().getName(), key);
    }

    public String getString(String key, Object[] substitutions) {
        return MessageFormat.format(this.getString(key), substitutions);
    }

    public void log(Object logEntry) {
        Logger logger = this.getPluginLogger();
        if (logger == null) {
            if (logEntry instanceof Throwable) {
                ((Throwable)logEntry).printStackTrace(System.err);
            } else {
                System.err.println(logEntry);
            }
        } else {
            logger.log(logEntry);
        }
    }

    public static abstract class EclipsePlugin
    extends Plugin
    implements ResourceLocator,
    Logger {
        public EclipsePlugin(IPluginDescriptor descriptor) {
            super(descriptor);
        }

        public URL getBaseURL() {
            return this.getDescriptor().getInstallURL();
        }

        public Object getImage(String key) {
            try {
                return this.doGetImage(key);
            }
            catch (MalformedURLException exception) {
                throw new WrappedException(exception);
            }
            catch (IOException exception) {
                throw new MissingResourceException(CommonPlugin.INSTANCE.getString("_UI_StringResourceNotFound_exception", new Object[]{key}), this.getClass().getName(), key);
            }
        }

        protected Object doGetImage(String key) throws IOException {
            URL url = new URL(this.getBaseURL() + "icons/" + key + ".gif");
            InputStream inputStream = url.openStream();
            inputStream.close();
            return url;
        }

        public String getString(String key) {
            return this.getDescriptor().getResourceBundle().getString(key);
        }

        public String getString(String key, Object[] substitutions) {
            return MessageFormat.format(this.getString(key), substitutions);
        }

        public void log(Object logEntry) {
            if (logEntry instanceof IStatus) {
                IStatus status = (IStatus)logEntry;
                this.getLog().log(status);
            } else {
                if (logEntry == null) {
                    logEntry = new RuntimeException(this.getString("_UI_NullLogEntry_exception")).fillInStackTrace();
                }
                if (logEntry instanceof Throwable) {
                    Throwable throwable = (Throwable)logEntry;
                    String message = throwable.getLocalizedMessage();
                    if (message == null) {
                        message = "";
                    }
                    this.getLog().log((IStatus)new Status(2, this.getDescriptor().getUniqueIdentifier(), 0, message, throwable));
                } else {
                    this.getLog().log((IStatus)new Status(2, this.getDescriptor().getUniqueIdentifier(), 0, logEntry.toString(), null));
                }
            }
        }
    }
}

