/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon;

import java.util.HashMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDSampleWindow;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.perfmon.PerfmonCommandUtil;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.widgets.internal.GData;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class PerfmonCounterDialog
extends Dialog
implements MouseListener,
SelectionListener {
    TRCAgent trcagent;
    Agent agent;
    Shell thisshell;
    Shell parentshell;
    Composite buttonpanel;
    Button okbutton;
    Button refresh;
    Tree tree;
    Menu tree_menu;
    MenuItem get_children;
    MenuItem start_tracing;
    HashMap descriptor_to_item = new HashMap();
    HashMap item_to_descriptor = new HashMap();
    PerfmonCommandUtil command;
    ModelListener adapter = new ModelListener();
    SDDescriptor selected_descriptor;

    public PerfmonCounterDialog(Shell parent, TRCAgent trcagent, Agent agent) {
        super(parent, 0);
        this.parentshell = parent;
        this.trcagent = trcagent;
        this.agent = agent;
        try {
            this.command = new PerfmonCommandUtil(agent);
        }
        catch (Exception e) {
            PerfmonPlugin.DBG.logVisibleError((Throwable)e, PerfmonPlugin.getString("ERROR_COMMAND_UTIL"), true);
        }
        trcagent.eAdapters().add((Object)this.adapter);
        if (trcagent.getView() != null) {
            trcagent.getView().eAdapters().add((Object)this.adapter);
            EList windows = trcagent.getView().eContents();
            for (int k = 0; k < windows.size(); ++k) {
                SDSampleWindow window = (SDSampleWindow)windows.get(k);
                window.eAdapters().add((Object)this.adapter);
            }
        }
    }

    public Object open() {
        Shell parent = this.getParent();
        Shell shell = new Shell(parent, 67696);
        shell.setText(PerfmonPlugin.getString("CONFIGURE_PERFMON"));
        shell.setBounds(0, 0, 400, 400);
        shell.setLayout((Layout)new FillLayout());
        this.thisshell = shell;
        PerfmonPlugin.DBG.info("initialising graphics");
        this.init(shell);
        Rectangle r = this.parentshell.getBounds();
        Rectangle z = shell.getBounds();
        if (z.width < 400) {
            z.width = 400;
        }
        if (z.height < 400) {
            z.height = 400;
        }
        shell.setBounds(r.x + r.width / 2 - z.width / 2, r.y + r.height / 2 - z.height / 2, z.width, z.height);
        PerfmonPlugin.DBG.info("opening dialog");
        shell.open();
        Display display = parent.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return null;
    }

    public void init(Shell parent) {
        GridLayout glayout = new GridLayout();
        glayout.numColumns = 1;
        Composite mainpanel = new Composite((Composite)parent, 0);
        mainpanel.setLayout((Layout)glayout);
        this.tree = new Tree(mainpanel, 2048);
        this.tree.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)true, (int)-1, (int)-1, (int)1, (int)1, (int)4, (int)4));
        this.tree_menu = new Menu((Control)this.tree);
        this.get_children = new MenuItem(this.tree_menu, 0);
        this.start_tracing = new MenuItem(this.tree_menu, 0);
        this.get_children.setText(PerfmonPlugin.getString("UPDATE_TREE"));
        this.get_children.setImage(PerfmonPlugin.img.getImage("update_tree.gif"));
        this.start_tracing.setText(PerfmonPlugin.getString("START_TRACING"));
        this.start_tracing.setImage(PerfmonPlugin.img.getImage("trace_start.gif"));
        try {
            this.rebuildTree();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        glayout = new GridLayout();
        glayout.numColumns = 2;
        this.buttonpanel = new Composite(mainpanel, 0);
        this.buttonpanel.setLayout((Layout)glayout);
        this.buttonpanel.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)2, (int)4));
        this.okbutton = new Button(this.buttonpanel, 0);
        this.okbutton.setText(" " + PerfmonPlugin.getString("OK") + " ");
        this.okbutton.setLayoutData((Object)GData.getGridData((boolean)false, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)2, (int)2));
        this.refresh = new Button(this.buttonpanel, 0);
        this.refresh.setText(PerfmonPlugin.getString("REFRESH"));
        this.refresh.setLayoutData((Object)GData.getGridData((boolean)false, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)2, (int)2));
        this.okbutton.addSelectionListener((SelectionListener)this);
        this.refresh.addSelectionListener((SelectionListener)this);
        this.get_children.addSelectionListener((SelectionListener)this);
        this.start_tracing.addSelectionListener((SelectionListener)this);
        this.tree.addMouseListener((MouseListener)this);
    }

    private void refreshTree() {
        EList models = this.trcagent.getDescriptor();
        for (int i = 0; i < models.size(); ++i) {
            SDDescriptor descriptor = (SDDescriptor)models.get(i);
            this.addToTree(descriptor);
        }
    }

    private void rebuildTree() {
        this.tree.removeAll();
        EList models = this.trcagent.getDescriptor();
        for (int i = 0; i < models.size(); ++i) {
            SDDescriptor descriptor = (SDDescriptor)models.get(i);
            this.addToTree(descriptor);
        }
    }

    private int findIndex(String name, TreeItem[] items) {
        if (name != null) {
            for (int i = 0; i < items.length; ++i) {
                if (items[i] == null || name.compareTo(items[i].getText()) >= 0) continue;
                return i;
            }
        }
        return items.length;
    }

    private void addToTree(SDDescriptor descriptor) {
        SDMemberDescriptor mem;
        TreeItem item = null;
        if (descriptor.getName() == null) {
            return;
        }
        item = (TreeItem)this.descriptor_to_item.get(descriptor);
        if (item == null) {
            if (descriptor.getParent() == null) {
                int index = this.findIndex(descriptor.getName(), this.tree.getItems());
                item = new TreeItem(this.tree, 0, index);
            } else {
                TreeItem parent = (TreeItem)this.descriptor_to_item.get(descriptor.getParent());
                int index = this.findIndex(descriptor.getName(), parent.getItems());
                item = new TreeItem(parent, 0, index);
            }
            this.descriptor_to_item.put(descriptor, item);
            this.item_to_descriptor.put(item, descriptor);
        }
        if (descriptor.getDescription() == null) {
            item.setText(descriptor.getName());
        } else {
            item.setText(descriptor.getName() + " - " + descriptor.getDescription());
        }
        item.setImage(EditorPlugin.img.getImage("smodel_descriptor2.gif"));
        if (descriptor instanceof SDMemberDescriptor && (mem = (SDMemberDescriptor)descriptor).getSnapshotObservation().size() > 0) {
            item.setImage(PerfmonPlugin.img.getImage("trace_start.gif"));
        }
        for (int i = 0; i < descriptor.getChildren().size(); ++i) {
            SDDescriptor child = (SDDescriptor)descriptor.getChildren().get(i);
            this.addToTree(child);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        Object o = e.getSource();
        if (o == this.refresh) {
            this.refreshTree();
        } else if (o == this.okbutton) {
            this.thisshell.close();
        } else if (o == this.get_children) {
            try {
                this.command.getUpdatedTree(this.selected_descriptor);
            }
            catch (Exception x) {
                PerfmonPlugin.DBG.logVisibleError((Throwable)x, PerfmonPlugin.getString("ERROR_UPDATE_TREE"), false);
            }
        } else if (o == this.start_tracing) {
            try {
                this.command.startTracing(this.selected_descriptor);
            }
            catch (Exception x) {
                PerfmonPlugin.DBG.logVisibleError((Throwable)x, PerfmonPlugin.getString("ERROR_ISSUE_COMMAND"), false);
            }
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        Point pt = new Point(e.x, e.y);
        TreeItem item = this.tree.getItem(pt);
        if (item != null) {
            this.selected_descriptor = (SDDescriptor)this.item_to_descriptor.get(item);
            if (this.selected_descriptor != null && e.button > 1) {
                this.tree_menu.setVisible(true);
            }
        }
    }

    class ModelListener
    extends AdapterImpl
    implements Runnable {
        ModelListener() {
        }

        public void notifyChanged(Notification notification) {
            if (notification.getEventType() == 3) {
                Object newValue = notification.getNewValue();
                boolean notify = false;
                if (newValue instanceof SDDescriptor) {
                    notify = true;
                } else if (newValue instanceof SDSnapshotObservation) {
                    notify = true;
                }
                if (notify) {
                    Display display = Display.getCurrent();
                    if (display == null) {
                        display = Display.getDefault();
                    }
                    if (display == null) {
                        PerfmonCounterDialog.this.thisshell.getDisplay().syncExec((Runnable)this);
                    } else {
                        display.syncExec((Runnable)this);
                    }
                }
            }
        }

        public void run() {
            try {
                PerfmonCounterDialog.this.refreshTree();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
        }
    }
}

