/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.eclipse.hyades.model.statistical.SDContiguousObservation;
import org.eclipse.hyades.model.statistical.SDDiscreteObservation;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.GraphSource;

public class SDSnapshotObservationGraphSource
implements GraphSource {
    List times;
    List values;

    public SDSnapshotObservationGraphSource(SDContiguousObservation sdc) {
        this.times = sdc.getCreationTime();
        this.values = sdc.getValue();
    }

    public SDSnapshotObservationGraphSource(SDDiscreteObservation sdc) {
        this.times = sdc.getCreationTime();
        this.values = sdc.getValue();
    }

    private void test() {
        ArrayList<Double> times = new ArrayList<Double>();
        ArrayList<Double> values = new ArrayList<Double>();
        long t = 0L;
        Random r = new Random(10L);
        for (int i = 0; i < 100000; ++i) {
            times.add(new Double(t));
            values.add(new Double(r.nextInt()));
            t += (long)r.nextInt(1500);
        }
        List tmp1 = this.times;
        List tmp2 = this.values;
        this.times = times;
        this.values = values;
        int index = 0;
        int bcindex = 0;
        long tcrap = System.currentTimeMillis();
        r = new Random(10L);
        for (int k = 0; k < 100; ++k) {
            long search = t - (long)r.nextInt(100000000);
            index = this.linearGetIndex(search);
            try {
                EditorPlugin.DBG.info("Crap Get Index= , " + index + " , " + search + " , " + times.get(index) + " , " + times.get(index + 1));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        tcrap = System.currentTimeMillis() - tcrap;
        long tchop = System.currentTimeMillis();
        r = new Random(10L);
        for (int k = 0; k < 100; ++k) {
            long search = t - (long)r.nextInt(100000000);
            bcindex = this.bchopGetIndex(search);
            try {
                EditorPlugin.DBG.info("BChop Get Index= , " + bcindex + " , " + search + " , " + times.get(bcindex) + " , " + times.get(bcindex + 1));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        tchop = System.currentTimeMillis() - tchop;
        EditorPlugin.DBG.info("Test times are: BCHOP " + tchop + " CRAP " + tcrap);
        this.times = tmp1;
        this.values = tmp2;
    }

    public int bchopGetIndex(double t) {
        int lower = 0;
        int higher = this.times.size() - 1;
        double t1 = ((Number)this.times.get(lower)).doubleValue();
        double t2 = ((Number)this.times.get(higher)).doubleValue();
        if (t >= t2) {
            return this.times.size() - 1;
        }
        if (t <= t1) {
            return 0;
        }
        return this.bchopGetIndex(lower, higher, t);
    }

    private int bchopGetIndex(int lower, int higher, double t) {
        while (true) {
            if (higher - lower < 10) {
                for (int i = lower; i <= higher; ++i) {
                    Number T = (Number)this.times.get(i);
                    if (!(T.doubleValue() > t)) continue;
                    if (--i < 0) {
                        return 0;
                    }
                    if (i >= this.times.size()) {
                        return this.times.size() - 1;
                    }
                    return i;
                }
                return higher;
            }
            double t1 = ((Number)this.times.get(lower)).doubleValue();
            double t2 = ((Number)this.times.get(higher)).doubleValue();
            double chop = (t - t1) / (t2 - t1);
            chop *= (double)(higher - lower - 2);
            double chop_t = ((Number)this.times.get((int)(chop = chop + (double)lower + 1.0))).doubleValue();
            if (chop_t == t) {
                return (int)chop;
            }
            if (chop_t > t) {
                higher = (int)chop;
                continue;
            }
            lower = (int)chop;
        }
    }

    public int linearGetIndex(double t) {
        if (this.times.size() != this.values.size()) {
            EditorPlugin.DBG.warning("Snapshot Observation times list size different to values list size - something is out of sync here - " + this.times.size() + " " + this.values.size());
        }
        for (int i = 0; i < this.times.size(); ++i) {
            Number T = (Number)this.times.get(i);
            if (!(T.doubleValue() > t)) continue;
            if (--i == -1) {
                return 0;
            }
            return i;
        }
        return this.times.size() - 1;
    }

    public double getSumBetween(double t, double t1) {
        if (this.times == null) {
            return 0.0;
        }
        if (this.times.size() == 0) {
            return 0.0;
        }
        int index1 = this.bchopGetIndex(t);
        int index2 = this.bchopGetIndex(t1);
        if (this.times.size() != this.values.size()) {
            EditorPlugin.DBG.warning("Snapshot Observation times list size different to values list size - something is out of sync here - " + this.times.size() + " " + this.values.size());
        }
        double sum = 0.0;
        for (int i = index1; i < index2; ++i) {
            Number num = (Number)this.values.get(i);
            sum += this.validate(num.doubleValue());
        }
        return sum;
    }

    public double getAverageBetween(double t, double t1) {
        if (this.times == null) {
            return 0.0;
        }
        if (this.times.size() == 0) {
            return 0.0;
        }
        int index1 = this.bchopGetIndex(t);
        int index2 = this.bchopGetIndex(t1);
        if (this.times.size() != this.values.size()) {
            EditorPlugin.DBG.warning("Snapshot Observation times list size different to values list size - something is out of sync here - " + this.times.size() + " " + this.values.size());
        }
        double sum = 0.0;
        for (int i = index1; i < index2; ++i) {
            Number num = (Number)this.values.get(i);
            sum += this.validate(num.doubleValue());
        }
        double div = index2 - index1;
        if (div > 1.0) {
            return sum / div;
        }
        return sum;
    }

    private double validate(double val) {
        if (Double.isNaN(val) || Double.isInfinite(val)) {
            val = 0.0;
        }
        return val;
    }

    public double getValueAt(double t) {
        if (this.times == null) {
            return 0.0;
        }
        if (this.times.size() == 0) {
            return 0.0;
        }
        int index = this.bchopGetIndex(t);
        if (this.times.size() != this.values.size()) {
            EditorPlugin.DBG.warning("Snapshot Observation times list size different to values list size - something is out of sync here - " + this.times.size() + " " + this.values.size());
        }
        Number D = (Number)this.values.get(index);
        return this.validate(D.doubleValue());
    }

    public double getValueMin() {
        if (this.values == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.values.size() == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        double Vmin = Double.MAX_VALUE;
        double Vmax = Double.MIN_VALUE;
        Iterator it = this.values.iterator();
        while (it.hasNext()) {
            Number V = (Number)it.next();
            double tmp = V.doubleValue();
            if (tmp > Vmax) {
                Vmax = tmp;
            }
            if (!(tmp < Vmin)) continue;
            Vmin = tmp;
        }
        return Vmin;
    }

    public double getValueMax() {
        if (this.values == null) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.values.size() == 0) {
            return Double.POSITIVE_INFINITY;
        }
        double Vmin = Double.MAX_VALUE;
        double Vmax = Double.MIN_VALUE;
        Iterator it = this.values.iterator();
        while (it.hasNext()) {
            Number V = (Number)it.next();
            double tmp = V.doubleValue();
            if (tmp > Vmax) {
                Vmax = tmp;
            }
            if (!(tmp < Vmin)) continue;
            Vmin = tmp;
        }
        return Vmax;
    }

    public double getMin() {
        if (this.times == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.times.size() == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        Number L = (Number)this.times.get(0);
        return L.doubleValue();
    }

    public double getMax() {
        if (this.times == null) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.times.size() == 0) {
            return Double.POSITIVE_INFINITY;
        }
        Number L = (Number)this.times.get(this.times.size() - 1);
        return L.doubleValue();
    }
}

