/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http.internal.importWizard;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.test.common.TestCommonPlugin;
import org.eclipse.hyades.test.common.internal.util.TestCommonUtil;
import org.eclipse.hyades.test.http.TestHttpPlugin;
import org.eclipse.hyades.test.http.internal.preferences.HttpPreferenceUtil;
import org.eclipse.hyades.test.http.internal.util.RequestHelper;
import org.eclipse.hyades.test.java.TestJavaPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.util.CoreUtil;
import org.eclipse.hyades.ui.internal.util.JavaUtil;
import org.eclipse.hyades.ui.internal.util.XMLUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class HttpRequestFromXML
implements IDisposable {
    private String testSuiteBaseName;
    private String scriptFile;
    private IPath outputFolder;
    private List resources;
    private RequestHelper requestHelper;
    private int resourceNameIndex;
    private int requestCounter;

    public void dispose() {
        if (this.requestHelper != null) {
            this.requestHelper.dispose();
        }
        if (this.resources != null) {
            this.resources.clear();
        }
    }

    public IPath getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(IPath iPath) {
        this.outputFolder = iPath;
    }

    public String getScriptFile() {
        return this.scriptFile;
    }

    public void setScriptFile(String string) {
        this.scriptFile = string;
    }

    public String getTestSuiteBaseName() {
        return this.testSuiteBaseName;
    }

    public void setTestSuiteBaseName(String string) {
        this.testSuiteBaseName = string;
    }

    public boolean load() {
        Element element = null;
        try {
            element = XMLUtil.loadDom((InputStream)new FileInputStream(new File(this.scriptFile)), (String)"pageSet");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.openErrorMessage(TestHttpPlugin.getString("import.error.UnableToParse"), CoreUtil.getStackTrace((Throwable)fileNotFoundException));
            return false;
        }
        if (element == null) {
            this.openErrorMessage(TestHttpPlugin.getString("import.error.UnableToParse"), null);
            return false;
        }
        return this.loadPageSet(element);
    }

    protected boolean loadPageSet(Element element) {
        if ("5.0.0".equals(XMLUtil.getValue((Element)element, (String)"version"))) {
            return this.loadPageSet500(element);
        }
        this.openErrorMessage(TestHttpPlugin.getString("import.error.UnableToParse"), TestHttpPlugin.getString("import.error.UnableToParseDetail2"));
        return false;
    }

    protected boolean loadPageSet500(Element element) {
        NodeList nodeList = XMLUtil.getChildrenByName((Element)element, (String)"page");
        if (nodeList == null || nodeList.getLength() == 0) {
            this.openErrorMessage(TestHttpPlugin.getString("import.error.UnableToParse"), TestHttpPlugin.getString("import.error.UnableToParseDetail3"));
            return false;
        }
        this.requestHelper = new RequestHelper();
        boolean bl = HttpPreferenceUtil.getInstance().getImportAsSeparate();
        ITestSuite iTestSuite = null;
        int n = 0;
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            if (bl || iTestSuite == null) {
                iTestSuite = this.createTestSuite();
                n = 1;
            } else {
                ++n;
            }
            this.parsePage(iTestSuite, (Element)nodeList.item(i), n);
        }
        this.requestHelper.dispose();
        this.saveResources();
        return true;
    }

    protected void parsePage(ITestSuite iTestSuite, Element element, int n) {
        NodeList nodeList = XMLUtil.getChildrenByName((Element)element, (String)"request");
        if (nodeList != null) {
            ILoop iLoop = HyadesFactory.INSTANCE.createLoop();
            iLoop.setName(TestJavaPlugin.getString((String)"W_LOOP") + " " + n);
            iLoop.getCondition().setConstraint("1");
            iTestSuite.getImplementor().getBlock().getActions().add(iLoop);
            int n2 = nodeList.getLength();
            for (int i = 0; i < n2; ++i) {
                ITestCase iTestCase = this.createTestCase(iTestSuite, iLoop);
                this.parseRequest((Element)nodeList.item(i), iTestCase);
            }
        }
    }

    protected void parseRequest(Element element, ITestCase iTestCase) {
        this.requestHelper.setTestCase(iTestCase);
        this.requestHelper.setAttribute(5, XMLUtil.getValue((Element)element, (String)"method"));
        this.requestHelper.setAttribute(1, XMLUtil.getValue((Element)element, (String)"host"));
        this.requestHelper.setAttribute(2, XMLUtil.getValue((Element)element, (String)"port"));
        this.requestHelper.setAttribute(3, XMLUtil.getValue((Element)element, (String)"abs_path"));
        this.requestHelper.setAttribute(4, XMLUtil.getValue((Element)element, (String)"body"));
        this.requestHelper.setAttribute(6, XMLUtil.getValue((Element)element, (String)"version"));
        NodeList nodeList = XMLUtil.getChildrenByName((Element)element, (String)"header");
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                this.requestHelper.setHeader(XMLUtil.getValue((Element)element2, (String)"name"), XMLUtil.getValue((Element)element2, (String)"value"));
            }
        }
    }

    protected void openErrorMessage(String string, String string2) {
        if (string2 != null) {
            string = string + " \n\n" + string2;
        }
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)TestHttpPlugin.getString("W_ERROR"), (String)string);
    }

    protected ITestSuite createTestSuite() {
        String string;
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        IPath iPath = null;
        do {
            iPath = this.outputFolder.append(this.testSuiteBaseName + ++this.resourceNameIndex).addFileExtension("testsuite");
        } while (ResourcesPlugin.getWorkspace().getRoot().getFile(iPath).exists());
        URI uRI = URI.createPlatformResourceURI((String)iPath.toString());
        Resource resource = EMFUtil.getResourceFactory((String)"testsuite").createResource(uRI);
        this.resources.add(resource);
        ITestSuite iTestSuite = HyadesFactory.INSTANCE.createTestSuite(resource);
        iTestSuite.setType("org.eclipse.hyades.test.http.junit.testSuite");
        iTestSuite.setName(this.testSuiteBaseName + " " + this.resourceNameIndex);
        if (iTestSuite.getImplementor() == null) {
            HyadesFactory.INSTANCE.createImplementor((ITest)iTestSuite, false);
        }
        if ((string = JavaUtil.getValidClassName((String)iTestSuite.getName(), (boolean)true)) == null) {
            string = "Test";
        }
        iTestSuite.getImplementor().setResource("test." + string);
        return iTestSuite;
    }

    protected ITestCase createTestCase(ITestSuite iTestSuite, ILoop iLoop) {
        ITestCase iTestCase = TestCommonUtil.createTestCase((ITestSuite)iTestSuite, (String)"org.eclipse.hyades.test.http.junit.testCase", (boolean)false, (String)(TestHttpPlugin.getString("W_HTTP_REQUEST").toLowerCase() + " " + ++this.requestCounter));
        ITestInvocation iTestInvocation = HyadesFactory.INSTANCE.createTestInvocation((ITest)iTestCase);
        iLoop.getBlock().getActions().add(iTestInvocation);
        String string = TestJavaPlugin.getString((String)"W_LWR_INV");
        String string2 = iTestCase.getName();
        if (string2 == null) {
            iTestInvocation.setName(TestCommonUtil.getUniqueName((String)string, (List)iLoop.getBlock().getActions()));
        } else {
            iTestInvocation.setName(TestCommonPlugin.getString((String)"NME_CONCAT_SEP", (String[])new String[]{string2, string}));
        }
        return iTestCase;
    }

    protected void saveResources() {
        Iterator iterator = this.resources.iterator();
        while (iterator.hasNext()) {
            try {
                EMFUtil.save((Resource)((Resource)iterator.next()));
            }
            catch (Exception exception) {
                TestHttpPlugin.logError(exception);
            }
        }
    }

    public List getResources() {
        if (this.resources == null) {
            return Collections.EMPTY_LIST;
        }
        return this.resources;
    }
}

