/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.editors;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.internal.sdb.SDBDirective;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;
import org.eclipse.hyades.sdb.internal.editors.DBDetails;
import org.eclipse.hyades.sdb.internal.editors.DirectiveDetails;
import org.eclipse.hyades.sdb.internal.editors.IDetails;
import org.eclipse.hyades.sdb.internal.editors.SolutionDetails;
import org.eclipse.hyades.sdb.internal.editors.SymptomDBEditor;
import org.eclipse.hyades.sdb.internal.editors.SymptomDetails;
import org.eclipse.hyades.sdb.internal.util.RASWidgetFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DetailsContent
extends Composite {
    StackLayout detailsLayout;
    Composite details;
    DBDetails dbDetails;
    SymptomDetails symptoms;
    SolutionDetails solutions;
    DirectiveDetails directives;
    Composite composite;
    RASWidgetFactory factory;
    SymptomDBEditor editor;

    public DetailsContent(RASWidgetFactory factory, Composite composite, int style) {
        super(composite, style);
        this.composite = composite;
        this.factory = factory;
    }

    public Composite createContent() {
        this.detailsLayout = new StackLayout();
        this.setLayout((Layout)this.detailsLayout);
        GridData detailsGrid = new GridData(1808);
        detailsGrid.horizontalIndent = 10;
        this.setLayoutData(detailsGrid);
        this.dbDetails = new DBDetails(this.factory, this, 0);
        this.symptoms = new SymptomDetails(this.factory, this, 0);
        this.solutions = new SolutionDetails(this.factory, this, 0);
        this.directives = new DirectiveDetails(this.factory, this, 0);
        this.hideDetails();
        return this.details;
    }

    public void init(SymptomDBEditor editor) {
        this.editor = editor;
        this.dbDetails.init(editor);
        this.symptoms.init(editor);
        this.solutions.init(editor);
        this.directives.init(editor);
    }

    public void showDetailsFor(EObject data) {
        if (data instanceof SDBRuntime) {
            this.showDetail((Control)this.dbDetails, data);
        }
        if (data instanceof SDBSymptom) {
            this.showDetail((Control)this.symptoms, data);
        } else if (data instanceof SDBSolution) {
            this.showDetail((Control)this.solutions, data);
        } else if (data instanceof SDBDirective) {
            this.showDetail((Control)this.directives, data);
        }
    }

    public void setFocusFor(Object object) {
        if (object instanceof SDBRuntime) {
            this.dbDetails.setFocusToTextBox();
        }
        if (object instanceof SDBSymptom) {
            this.symptoms.setFocusToTextBox();
        } else if (object instanceof SDBSolution) {
            this.solutions.setFocusToTextBox();
        } else if (object instanceof SDBDirective) {
            this.directives.setFocusToTextBox();
        }
    }

    public boolean updateCurrentSelection(EObject sel) {
        if (sel instanceof SDBRuntime) {
            return this.dbDetails.updateCurrentSelection(sel);
        }
        if (sel instanceof SDBSymptom) {
            return this.symptoms.updateCurrentSelection(sel);
        }
        if (sel instanceof SDBSolution) {
            return this.solutions.updateCurrentSelection(sel);
        }
        if (sel instanceof SDBDirective) {
            return this.directives.updateCurrentSelection(sel);
        }
        return false;
    }

    private void hideDetails() {
        this.dbDetails.setVisible(false);
        this.symptoms.setVisible(false);
        this.solutions.setVisible(false);
        this.directives.setVisible(false);
    }

    private void showDetail(Control detail, EObject data) {
        ((IDetails)detail).display(data);
        this.detailsLayout.topControl = detail;
        this.layout();
    }

    protected void updateRegistry(EObject object, boolean add) {
        if (object instanceof SDBSolution) {
            this.solutions.updateSolutionRegistry((SDBSolution)object, add);
        } else if (object instanceof SDBDirective) {
            this.directives.updateDirectiveRegistry((SDBDirective)object, add);
        }
    }
}

