/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.internal.sdb.SDBDirective;
import org.eclipse.hyades.models.internal.sdb.SDBMatchPattern;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;

public class SymptomDBExportToV4Util {
    protected final String NL = System.getProperties().getProperty("line.separator");
    protected final String TEXT_1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + this.NL + "" + this.NL + "<!DOCTYPE symfile [" + this.NL + "<!-- ../dtd/symlog.dtd -->" + this.NL + "<!ELEMENT symrec ( matchsymptomv | nomatchsymptomv | symptominfov )* >" + this.NL + "<!ATTLIST symrec" + this.NL + "       recordid CDATA #REQUIRED" + this.NL + "       symptomtype CDATA #IMPLIED" + this.NL + "       symptomstatus CDATA #IMPLIED>" + this.NL + "" + this.NL + "<!ELEMENT symfile ( filterrecv | symrecv )* >" + this.NL + "<!ATTLIST symfile" + this.NL + "       totalrecords CDATA #IMPLIED" + this.NL + "       filtername CDATA #REQUIRED>" + this.NL + "" + this.NL + "<!ELEMENT symrecv ( symrec )* >" + this.NL + "<!ATTLIST symrecv>" + this.NL + "" + this.NL + "<!ELEMENT nomatchsymptomv ( #PCDATA )* >" + this.NL + "<!ATTLIST nomatchsymptomv>" + this.NL + "" + this.NL + "<!ELEMENT symfilterrec ( symrecv | symfilterrecv )* >" + this.NL + "<!ATTLIST symfilterrec" + this.NL + "       filtername CDATA #REQUIRED" + this.NL + "       filtervalue CDATA #IMPLIED" + this.NL + "       sortfield CDATA #IMPLIED" + this.NL + "       severity CDATA #REQUIRED>" + this.NL + "" + this.NL + "<!ELEMENT filterrecv ( symfilterrec )* >" + this.NL + "<!ATTLIST filterrecv>" + this.NL + "" + this.NL + "<!ELEMENT matchsymptomv ( #PCDATA )* >" + this.NL + "<!ATTLIST matchsymptomv>" + this.NL + "" + this.NL + "<!ELEMENT symptominfov ( #PCDATA )* >" + this.NL + "<!ATTLIST symptominfov>" + this.NL + "" + this.NL + "<!ELEMENT symfilterrecv ( symfilterrec )* >" + this.NL + "<!ATTLIST symfilterrecv>" + this.NL + "" + this.NL + "]>" + this.NL + "" + this.NL + "<!--  Created on " + new SimpleDateFormat("EEEE, MMMMM dd, yyyy 'at' h:mm:ss:SSSS a z").format(new Date()) + " -->" + this.NL;
    protected final String TEXT_2 = this.NL + "<symfile totalrecords=\"";
    protected final String TEXT_3 = "\" filtername=\"None\">" + this.NL + "  <symrecv>";
    protected final String TEXT_4 = this.NL + "    <symrec recordid=\"Symptom_";
    protected final String TEXT_5 = "\" symptomtype=\"\" symptomstatus=\"diagnosed\">" + this.NL + "      <matchsymptomv>";
    protected final String TEXT_6 = this.NL;
    protected final String TEXT_7 = this.NL + "      </matchsymptomv>" + this.NL + "      <symptominfov>";
    protected final String TEXT_8 = this.NL;
    protected final String TEXT_9 = this.NL;
    protected final String TEXT_10 = this.NL + "      </symptominfov>" + this.NL + "    </symrec>";
    protected final String TEXT_11 = this.NL + "  </symrecv>" + this.NL + "</symfile>";

    public String normalize(String string) {
        if (string == null) {
            return "null";
        }
        StringBuffer normalizedString = new StringBuffer();
        for (int counter = 0; counter < string.length(); ++counter) {
            char character = string.charAt(counter);
            if (character == '<') {
                normalizedString.append("&lt;");
                continue;
            }
            if (character == '>') {
                normalizedString.append("&gt;");
                continue;
            }
            if (character == '&') {
                normalizedString.append("&amp;");
                continue;
            }
            if (character == '\"') {
                normalizedString.append("&quot;");
                continue;
            }
            if (character == '\'') {
                normalizedString.append("&apos;");
                continue;
            }
            normalizedString.append(character);
        }
        return normalizedString.toString();
    }

    public String generate(SDBRuntime root, IProgressMonitor monitor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.TEXT_1);
        EList symptList = root.getSymptoms();
        int units = symptList.size();
        stringBuffer.append(this.TEXT_2);
        stringBuffer.append(units);
        stringBuffer.append(this.TEXT_3);
        for (int i = 0; i < symptList.size(); ++i) {
            int j;
            SDBSymptom current = (SDBSymptom)symptList.get(i);
            EList solList = current.getSolutions();
            EList matchPatterns = current.getPatterns();
            stringBuffer.append(this.TEXT_4);
            stringBuffer.append(i);
            stringBuffer.append(this.TEXT_5);
            for (j = 0; j < matchPatterns.size(); ++j) {
                stringBuffer.append(this.TEXT_6);
                stringBuffer.append(this.normalize(((SDBMatchPattern)matchPatterns.get(j)).getValue()));
            }
            stringBuffer.append(this.TEXT_7);
            for (j = 0; j < solList.size(); ++j) {
                SDBSolution sol = (SDBSolution)solList.get(j);
                EList dirList = sol.getDirectives();
                if (sol.getDescription().length() > 0) {
                    stringBuffer.append(this.TEXT_8);
                    stringBuffer.append(this.normalize(sol.getDescription()));
                }
                for (int k = 0; k < dirList.size(); ++k) {
                    SDBDirective dir = (SDBDirective)dirList.get(k);
                    if (dir.getDescription().length() > 0) {
                        stringBuffer.append(this.TEXT_8);
                        stringBuffer.append(this.normalize(dir.getDescription()));
                    }
                    if (dir.getDirectiveString().length() <= 0) continue;
                    stringBuffer.append(this.TEXT_9);
                    stringBuffer.append(this.normalize(dir.getDirectiveString()));
                }
            }
            stringBuffer.append(this.TEXT_10);
            monitor.worked(8000 / units);
        }
        stringBuffer.append(this.TEXT_11);
        return stringBuffer.toString();
    }
}

