/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.util;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.internal.sdb.SDBDirective;
import org.eclipse.hyades.models.internal.sdb.SDBMatchPattern;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;

public class SymptomDBTextSearch {
    private SDBRuntime root;
    private Object[] start = null;
    private int[] startIndex = null;
    private int[] index = null;

    public void initialize(SDBRuntime root, Object[] start) {
        this.root = root;
        this.start = start;
        this.startIndex = new int[]{-1, -1, -1, -1};
        this.index = new int[]{-1, -1, -1, -1};
        this.startIndex = this.lookForStartNode(start);
    }

    public Object[] search(String pattern, int direction, boolean bCaseSensitive) {
        if (this.startIndex == null) {
            this.setStartIndex(-1, -1, -1, -1);
            this.startIndex = this.lookForStartNode(this.start);
        }
        if (this.startIndex[1] == -1 && direction > 0) {
            this.setIndex(0, 0, 0, 0);
            return this.searchDown(pattern, bCaseSensitive);
        }
        if (this.startIndex[1] == -1 && direction < 0) {
            this.startIndex[0] = -1;
            this.setIndex(this.startIndex[0], this.startIndex[1], this.startIndex[2], this.startIndex[3]);
            return this.searchUp(pattern, bCaseSensitive);
        }
        if (this.startIndex[2] == -1 && direction > 0) {
            this.setIndex(0, this.startIndex[1], 0, 0);
            return this.searchDown(pattern, bCaseSensitive);
        }
        if (this.startIndex[2] == -1 && direction < 0) {
            if (this.startIndex[1] - 1 >= 0) {
                this.setIndex(0, this.startIndex[1] - 1, -11, -11);
                return this.searchUp(pattern, bCaseSensitive);
            }
            this.setIndex(0, -1, -1, -1);
            return this.searchUp(pattern, bCaseSensitive);
        }
        if (this.startIndex[3] == -1 && direction > 0) {
            this.setIndex(0, this.startIndex[1], this.startIndex[2], 0);
            return this.searchDown(pattern, bCaseSensitive);
        }
        if (this.startIndex[3] == -1 && direction < 0) {
            if (this.startIndex[2] - 1 >= 0) {
                this.setIndex(0, this.startIndex[1], this.startIndex[2] - 1, -11);
                return this.searchUp(pattern, bCaseSensitive);
            }
            this.setIndex(0, this.startIndex[1], this.startIndex[2] - 1, -1);
            return this.searchUp(pattern, bCaseSensitive);
        }
        if (direction > 0) {
            this.setIndex(0, this.startIndex[1], this.startIndex[2], this.startIndex[3]);
            return this.searchDown(pattern, bCaseSensitive);
        }
        this.setIndex(0, this.startIndex[1], this.startIndex[2], this.startIndex[3] - 1);
        return this.searchUp(pattern, bCaseSensitive);
    }

    private int[] lookForStartNode(Object[] start) {
        if (start[0] == null) {
            this.startIndex[0] = -1;
            return this.startIndex;
        }
        this.startIndex[0] = 0;
        if (start[1] == null) {
            return this.startIndex;
        }
        EList symptoms = this.root.getSymptoms();
        this.startIndex[1] = symptoms.indexOf((Object)((SDBSymptom)start[1]));
        if (start[2] == null) {
            this.startIndex[2] = -1;
            return this.startIndex;
        }
        SDBSymptom symptom = (SDBSymptom)start[1];
        EList solutions = symptom.getSolutions();
        this.startIndex[2] = solutions.indexOf((Object)((SDBSolution)start[2]));
        if (start[3] == null) {
            this.startIndex[3] = -1;
            return this.startIndex;
        }
        SDBSolution sol = (SDBSolution)start[2];
        EList directives = sol.getDirectives();
        this.startIndex[3] = directives.indexOf((Object)((SDBDirective)start[3]));
        return this.startIndex;
    }

    private boolean searchPatternIn(String pattern, String target, boolean bCaseSensitive) {
        return !(bCaseSensitive ? target.indexOf(pattern) < 0 : (target = target.toLowerCase()).indexOf(pattern = pattern.toLowerCase()) < 0);
    }

    private Object[] searchDown(String pattern, boolean bCaseSensitive) {
        if (this.startIndex[0] < 0 && this.searchPatternIn(pattern, this.root.getDescription() + this.root.getLocalExternalFileLocation() + this.root.getName() + this.root.getSymptomUrl(), bCaseSensitive)) {
            this.setStartIndex(0, -1, -1, -1);
            this.setStartObject(this.root, null, null, null);
            return this.start;
        }
        EList symptoms = this.root.getSymptoms();
        int k = this.index[2];
        int l = this.index[3];
        for (int i = this.index[1]; i >= 0 && i < symptoms.size(); ++i) {
            SDBSymptom symptom = (SDBSymptom)symptoms.get(i);
            if (i != this.startIndex[1]) {
                if (this.searchPatternIn(pattern, symptom.getDescription(), bCaseSensitive)) {
                    this.setStartIndex(0, i, -1, -1);
                    this.setStartObject(this.root, symptom, null, null);
                    return this.start;
                }
                EList patterns = symptom.getPatterns();
                for (int j = 0; j < patterns.size(); ++j) {
                    SDBMatchPattern match = (SDBMatchPattern)patterns.get(j);
                    if (!this.searchPatternIn(pattern, match.getValue(), bCaseSensitive)) continue;
                    this.setStartIndex(0, i, -1, -1);
                    this.setStartObject(this.root, symptom, null, null);
                    return this.start;
                }
            }
            EList solutions = symptom.getSolutions();
            while (k >= 0 && k < solutions.size()) {
                SDBSolution sol = (SDBSolution)solutions.get(k);
                if ((i != this.startIndex[1] || k != this.startIndex[2]) && this.searchPatternIn(pattern, sol.getDescription(), bCaseSensitive)) {
                    this.setStartIndex(0, i, k, -1);
                    this.setStartObject(this.root, symptom, sol, null);
                    return this.start;
                }
                EList directives = sol.getDirectives();
                while (l >= 0 && l < directives.size()) {
                    SDBDirective dir = (SDBDirective)directives.get(l);
                    if ((i != this.startIndex[1] || k != this.startIndex[2] || l != this.startIndex[3]) && (this.searchPatternIn(pattern, dir.getDescription(), bCaseSensitive) || this.searchPatternIn(pattern, dir.getDirectiveString(), bCaseSensitive))) {
                        this.setStartIndex(0, i, k, l);
                        this.setStartObject(this.root, symptom, sol, dir);
                        return this.start;
                    }
                    ++l;
                }
                l = 0;
                ++k;
            }
            k = 0;
        }
        this.setStartObject(null, null, null, null);
        return this.start;
    }

    private Object[] searchUp(String pattern, boolean bCaseSensitive) {
        EList symptoms = this.root.getSymptoms();
        for (int i = this.index[1]; i >= 0 && i < symptoms.size(); --i) {
            SDBSymptom symptom = (SDBSymptom)symptoms.get(i);
            EList solutions = symptom.getSolutions();
            int k = solutions.size() - 1;
            if (i == this.index[1] && this.index[2] >= -1) {
                k = this.index[2];
            }
            while (k >= 0 && k < solutions.size()) {
                SDBSolution sol = (SDBSolution)solutions.get(k);
                EList directives = sol.getDirectives();
                int l = directives.size() - 1;
                if (i == this.index[1] && k == this.index[2] && this.index[3] >= -1) {
                    l = this.index[3];
                }
                while (l >= 0 && l < directives.size()) {
                    SDBDirective dir = (SDBDirective)directives.get(l);
                    if ((i != this.startIndex[1] || k != this.startIndex[2] || l != this.startIndex[3]) && (this.searchPatternIn(pattern, dir.getDescription(), bCaseSensitive) || this.searchPatternIn(pattern, dir.getDirectiveString(), bCaseSensitive))) {
                        this.setStartIndex(0, i, k, l);
                        this.setStartObject(this.root, symptom, sol, dir);
                        return this.start;
                    }
                    --l;
                }
                if (this.searchPatternIn(pattern, sol.getDescription(), bCaseSensitive)) {
                    this.setStartIndex(0, i, k, -1);
                    this.setStartObject(this.root, symptom, sol, null);
                    return this.start;
                }
                --k;
            }
            if (this.searchPatternIn(pattern, symptom.getDescription(), bCaseSensitive)) {
                this.setStartIndex(0, i, -1, -1);
                this.setStartObject(this.root, symptom, null, null);
                return this.start;
            }
            EList patterns = symptom.getPatterns();
            for (int j = 0; j < patterns.size(); ++j) {
                SDBMatchPattern match = (SDBMatchPattern)patterns.get(j);
                if (!this.searchPatternIn(pattern, match.getValue(), bCaseSensitive)) continue;
                this.setStartIndex(0, i, -1, -1);
                this.setStartObject(this.root, symptom, null, null);
                return this.start;
            }
        }
        if (this.startIndex[0] > -1 && this.searchPatternIn(pattern, this.root.getDescription() + this.root.getLocalExternalFileLocation() + this.root.getName() + this.root.getSymptomUrl(), bCaseSensitive)) {
            this.setStartIndex(0, -1, -1, -1);
            this.setStartObject(this.root, null, null, null);
            return this.start;
        }
        this.setStartObject(null, null, null, null);
        return this.start;
    }

    private void setStartIndex(int i0, int i1, int i2, int i3) {
        this.startIndex[0] = i0;
        this.startIndex[1] = i1;
        this.startIndex[2] = i2;
        this.startIndex[3] = i3;
    }

    private void setIndex(int i0, int i1, int i2, int i3) {
        this.index[0] = i0;
        this.index[1] = i1;
        this.index[2] = i2;
        this.index[3] = i3;
    }

    private void setStartObject(Object s0, Object s1, Object s2, Object s3) {
        this.start[0] = s0;
        this.start[1] = s1;
        this.start[2] = s2;
        this.start[3] = s3;
    }
}

