/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.wizard;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.impl.SDBResourceFactoryImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBResourceSetImpl;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.SDbPluginImages;
import org.eclipse.hyades.sdb.internal.help.ContextIds;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.hyades.sdb.internal.util.SymptomDBExportToV4Util;
import org.eclipse.hyades.sdb.internal.util.SymptomDBExportUtil;
import org.eclipse.hyades.sdb.internal.util.SymptomDBSelectionDialog;
import org.eclipse.hyades.sdb.internal.util.TString;
import org.eclipse.hyades.sdb.internal.wizard.ExportSymptomDBWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class ExportSymptomDBWizardPage
extends WizardDataTransferPage
implements Listener,
ModifyListener,
IRunnableWithProgress {
    private Text txtSourceFileName;
    private Text txtTargetFileName;
    private Button btnSourceBrowse;
    private Button btnTargetBrowse;
    private Button btnOldVersion;
    private Button btnNewVersion;
    private Button btnOverwriteCheckbox;
    private Button btnCreateFolderCheckbox;
    private SDBRuntime root = null;
    private boolean exception = false;
    private File output = null;
    private Writer writer = null;
    private String lastTargetFolder = "";
    private boolean v5 = true;
    private String extension = "trcdbxmi";
    private String sourceName = "";

    protected ExportSymptomDBWizardPage(String pageName) {
        super(pageName);
        this.setTitle(SDbPlugin.getResourceString("STR_EXPORT_SYMPTOM_DB_PTITLE"));
        this.setDescription(SDbPlugin.getResourceString("STR_EXPORT_SYMPTOM_DB_PDESC"));
        this.setImageDescriptor(SDbPluginImages.getImageDescriptor("export_symptomdb_wiz.gif"));
    }

    public void handleEvent(Event event) {
        this.setErrorMessage(null);
        if (event.widget == this.btnTargetBrowse) {
            this.showTargetDialog();
        }
        if (event.widget == this.btnSourceBrowse) {
            this.showFileDialog();
        }
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData data = GridUtil.createFill();
        data.widthHint = 300;
        composite.setLayoutData((Object)data);
        composite.setLayoutData((Object)data);
        Composite sourceGrp = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 4;
        data = GridUtil.createHorizontalFill();
        data.widthHint = 300;
        sourceGrp.setLayout((Layout)layout);
        sourceGrp.setLayoutData((Object)data);
        Label sourceLabel = new Label(sourceGrp, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        sourceLabel.setLayoutData((Object)data);
        sourceLabel.setText(SDbPlugin.getResourceString("STR_SYMPTOM_DB_SOURCE"));
        this.txtSourceFileName = new Text(sourceGrp, 2048);
        data = GridUtil.createHorizontalFill();
        this.txtSourceFileName.setLayoutData((Object)data);
        this.btnSourceBrowse = new Button(sourceGrp, 8);
        this.btnSourceBrowse.setText(SDbPlugin.getResourceString("STR_IMPORT_LOG_FILE_BROWSE1"));
        Composite targetGrp = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 4;
        data = GridUtil.createHorizontalFill();
        data.widthHint = 300;
        targetGrp.setLayout((Layout)layout);
        targetGrp.setLayoutData((Object)data);
        Label locationLabel = new Label(targetGrp, 0);
        data = new GridData();
        data.horizontalSpan = 3;
        locationLabel.setLayoutData((Object)data);
        locationLabel.setText(SDbPlugin.getResourceString("STR_EXPORT_DESTINATION"));
        Label targetLabel = new Label(targetGrp, 0);
        data = new GridData();
        targetLabel.setLayoutData((Object)data);
        targetLabel.setText(SDbPlugin.getResourceString("STR_EXPORT_DEST_LABEL"));
        this.txtTargetFileName = new Text(targetGrp, 2048);
        this.txtTargetFileName.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.btnTargetBrowse = new Button(targetGrp, 8);
        this.btnTargetBrowse.setText(SDbPlugin.getResourceString("STR_IMPORT_XMLLOG_BROWSE"));
        this.createSpacer(composite);
        this.createVersionGroup(composite);
        this.createSpacer(composite);
        this.createPlainLabel(composite, SDbPlugin.getResourceString("ExportDBWizardPage.options"));
        this.createOptionsGroup(composite);
        this.initControls();
        this.setControl((Control)composite);
        this.btnSourceBrowse.addListener(13, (Listener)this);
        this.btnTargetBrowse.addListener(13, (Listener)this);
        this.txtTargetFileName.addModifyListener((ModifyListener)this);
        this.txtSourceFileName.addModifyListener((ModifyListener)this);
        WorkbenchHelp.setHelp((Control)this.txtSourceFileName, (String)ContextIds.EXPORT_SYMDB_RESOURCE);
        WorkbenchHelp.setHelp((Control)this.txtTargetFileName, (String)ContextIds.EXPORT_SYMDB_DESTINATION);
        this.setPageComplete(this.determinePageCompletion());
    }

    protected void createVersionGroup(Composite parent) {
        Group versionGrp = new Group(parent, 0);
        versionGrp.setText(SDbPlugin.getResourceString("STR_EXPORT_TO_VERSION"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData data = new GridData();
        data.horizontalIndent = 15;
        data.widthHint = -1;
        versionGrp.setLayout((Layout)layout);
        versionGrp.setLayoutData((Object)data);
        this.btnNewVersion = new Button((Composite)versionGrp, 16);
        this.btnNewVersion.setText(SDbPlugin.getResourceString("STR_EXPORT_NEW_VERSION"));
        this.btnNewVersion.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.btnOldVersion = new Button((Composite)versionGrp, 16);
        this.btnOldVersion.setText(SDbPlugin.getResourceString("STR_EXPORT_OLD_VERSION"));
        this.btnOldVersion.setLayoutData((Object)GridUtil.createHorizontalFill());
        WorkbenchHelp.setHelp((Control)versionGrp, (String)ContextIds.EXPORT_SYMDB_XML_FORMAT);
    }

    protected void createOptionsGroup(Composite parent) {
        Composite optionsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        optionsGroup.setLayout((Layout)layout);
        optionsGroup.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.btnOverwriteCheckbox = new Button(optionsGroup, 16416);
        this.btnOverwriteCheckbox.setText(SDbPlugin.getResourceString("ExportDBWizardPage.override.text"));
        this.btnOverwriteCheckbox.addListener(13, (Listener)this);
        WorkbenchHelp.setHelp((Control)this.btnOverwriteCheckbox, (String)ContextIds.EXPORT_SYMDB_OVERWRITE_FILE);
    }

    public void modifyText(ModifyEvent e) {
        this.setErrorMessage(null);
        this.setPageComplete(this.determinePageCompletion());
    }

    private void showFileDialog() {
        Object[] result;
        String fName = "";
        SymptomDBSelectionDialog dialog = new SymptomDBSelectionDialog(this.getShell(), SDbPlugin.getResourceString("STR_RES_DLG_MSG"));
        if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length == 1 && result[0] != null) {
            IPath path = (IPath)result[0];
            fName = path.toOSString();
            this.sourceName = path.toString();
        }
        if (fName != null && !fName.equals("")) {
            this.txtSourceFileName.setText(fName);
        }
        this.setPageComplete(this.determinePageCompletion());
    }

    private void showTargetDialog() {
        String currentSource = this.txtSourceFileName.getText();
        currentSource = this.getTargetFileNameFromSourceName(currentSource);
        FileDialog dlg = new FileDialog(this.getShell(), 8192);
        if (this.lastTargetFolder.length() > 0) {
            dlg.setFilterPath(this.lastTargetFolder);
        }
        dlg.setFileName(currentSource);
        dlg.setFilterExtensions(new String[]{"*.xml", "*.*"});
        String target = dlg.open();
        if (target != null) {
            this.txtTargetFileName.setText(target);
            this.lastTargetFolder = this.getDirectoryName(target);
        }
        this.setPageComplete(this.determinePageCompletion());
    }

    private String getTargetFileNameFromSourceName(String source) {
        int i = source.indexOf("trcdbxmi");
        if (i > -1) {
            source = source.substring(0, i) + "xml";
        }
        if ((i = source.lastIndexOf(File.separatorChar)) > -1) {
            source = source.substring(i + 1);
        }
        return source;
    }

    public void run(IProgressMonitor monitor) {
        try {
            String message = SDbPlugin.getResourceString("STR_EXPORT_GEN_XML_MSG");
            message = TString.change(message, "%1", this.output.getName());
            monitor.beginTask(message, 10000);
            if (this.root == null) {
                this.loadModel(monitor);
            }
            if (this.v5) {
                SymptomDBExportUtil generator = new SymptomDBExportUtil();
                this.writer.write(generator.generate(this.root, monitor));
            } else {
                SymptomDBExportToV4Util generator = new SymptomDBExportToV4Util();
                this.writer.write(generator.generate(this.root, monitor));
            }
            this.writer.flush();
            this.writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            monitor.done();
            this.exception = true;
        }
        monitor.done();
    }

    protected boolean determinePageCompletion() {
        boolean complete;
        boolean bl = complete = this.validateSourceGroup() && this.validateDestinationGroup();
        if (complete) {
            this.setErrorMessage(null);
        }
        return complete;
    }

    protected boolean validateSourceGroup() {
        boolean result;
        String source = this.txtSourceFileName.getText().trim();
        if (source.equals("")) {
            return false;
        }
        if (!source.startsWith(new String(new char[]{File.separatorChar}))) {
            source = File.separatorChar + source;
        }
        if (!(result = this.resourceExists(source))) {
            this.setErrorMessage(SDbPlugin.getResourceString("STR_INVALID_SOURCE_MSG"));
        }
        return result;
    }

    protected boolean validateDestinationGroup() {
        return !this.txtTargetFileName.getText().trim().equals("");
    }

    protected boolean performFinish() {
        String result;
        String fName = this.txtTargetFileName.getText();
        String dirName = this.getDirectoryName(fName);
        this.exception = false;
        if (!this.targetFolderExists(new File(dirName))) {
            return false;
        }
        this.output = new File(fName);
        if (this.output.exists() && !this.btnOverwriteCheckbox.getSelection() && ((result = this.queryOverwrite(fName)).equals("NO") || result.equals("NOALL") || result.equals("CANCEL"))) {
            return false;
        }
        try {
            FileOutputStream outStream = new FileOutputStream(this.output.toString(), false);
            this.writer = new OutputStreamWriter((OutputStream)outStream, "UTF-8");
        }
        catch (IOException e) {
            String errMsg = SDbPlugin.getResourceString("STR_CREATE_FILE_ERROR_");
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"), (String)errMsg);
            return false;
        }
        this.v5 = this.btnNewVersion.getSelection();
        try {
            this.getWizard().getContainer().run(true, true, (IRunnableWithProgress)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.exception = true;
        }
        if (this.exception) {
            String errMsg = SDbPlugin.getResourceString("STR_EXPORT_SYMPTOMDB_ERROR_");
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"), (String)errMsg);
            return false;
        }
        return true;
    }

    private boolean targetFolderExists(File directory) {
        if (!directory.exists()) {
            if (!this.queryYesNoQuestion(SDbPlugin.getResourceString("STR_FOLDER_CREATION_MSG"))) {
                return false;
            }
            if (!directory.mkdirs()) {
                String errMsg = SDbPlugin.getResourceString("STR_FOLDER_CREATION_ERROR_");
                MessageDialog.openError((Shell)this.getContainer().getShell(), (String)SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"), (String)errMsg);
                return false;
            }
        }
        return true;
    }

    private void initControls() {
        IFile iFile = ((ExportSymptomDBWizard)this.getWizard()).getFile();
        if (iFile != null) {
            String fName = iFile.getFullPath().toOSString();
            this.sourceName = iFile.getFullPath().toString();
            this.txtSourceFileName.setText(fName);
        }
        this.btnNewVersion.setSelection(true);
    }

    private void loadModel(IProgressMonitor monitor) throws Exception {
        try {
            SDBResourceSetImpl resourceSet = new SDBResourceSetImpl();
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("trcdbxmi", new SDBResourceFactoryImpl());
            monitor.worked(500);
            Resource res = resourceSet.getResource(URI.createURI((String)("platform:/resource" + this.sourceName)), true);
            monitor.worked(1000);
            Iterator i = res.getContents().iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                if (!(obj instanceof SDBRuntime)) continue;
                this.root = (SDBRuntime)obj;
                monitor.worked(500);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private String getDirectoryName(String fName) {
        int i = fName.lastIndexOf(File.separatorChar);
        if (i >= 0) {
            fName = fName.substring(0, i);
        }
        return fName;
    }

    private boolean resourceExists(String fName) {
        IStatus result = ResourcesPlugin.getWorkspace().validatePath(fName, 1);
        if (result.getSeverity() != 0) {
            return false;
        }
        Path path = new Path(fName);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        return file != null && file.exists();
    }

    public void setTxtTargetFileName(Text txtTargetFileName) {
        this.txtTargetFileName = txtTargetFileName;
    }
}

