/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.testgen.http;

public class TRCAsciifier {
    private static final char C_DELIM = '`';
    private static final char C_ZERO = '0';

    public String encode(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = n; i < n2; ++i) {
            char c = (char)byArray[i];
            if (Character.isISOControl(c) || c == '`') {
                if (!bl) {
                    stringBuffer.append('`');
                }
                stringBuffer.append(Character.forDigit(c >> 4, 16));
                stringBuffer.append(Character.forDigit(c & 0xF, 16));
                if (i == n2 - 1) {
                    stringBuffer.append('`');
                }
                bl = true;
                continue;
            }
            if (bl) {
                stringBuffer.append('`');
            }
            stringBuffer.append(c);
            bl = false;
        }
        return stringBuffer.toString();
    }

    public int decode(String string, int n, int n2, byte[] byArray) {
        boolean bl = false;
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '`') {
                bl = !bl;
                continue;
            }
            byArray[n3++] = bl ? (byte)(Character.digit(c, 16) << 4 | Character.digit(string.charAt(++i), 16)) : (byte)c;
        }
        return n3;
    }

    public static void main(String[] stringArray) {
        TRCAsciifier tRCAsciifier = new TRCAsciifier();
        byte[] byArray = new byte[]{48, 96, 48, 1, 96, 1, 50, 96, 50, 3, 96, 3};
        String string = tRCAsciifier.encode(byArray, 0, byArray.length);
        System.out.println("[" + string + "]");
        byte[] byArray2 = new byte[string.length()];
        int n = tRCAsciifier.decode(string, 0, string.length(), byArray2);
        String string2 = tRCAsciifier.encode(byArray2, 0, n);
        System.out.println("[" + string2 + "]");
        if (string2.equals(string)) {
            System.out.println("same");
        } else {
            System.out.println("wrong");
        }
        byArray = new byte[]{0, 96, 0, 49, 96, 49, 2, 96, 2, 51, 96, 51};
        string = tRCAsciifier.encode(byArray, 0, byArray.length);
        System.out.println("[" + string + "]");
        byArray2 = new byte[string.length()];
        n = tRCAsciifier.decode(string, 0, string.length(), byArray2);
        string2 = tRCAsciifier.encode(byArray2, 0, n);
        System.out.println("[" + string2 + "]");
        if (string2.equals(string)) {
            System.out.println("same");
        } else {
            System.out.println("wrong");
        }
    }
}

