/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.testgen.http;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.execution.testgen.http.TRCContext;
import org.eclipse.hyades.execution.testgen.http.TRCElement;
import org.eclipse.hyades.execution.testgen.http.TRCNodeAssembler;
import org.eclipse.hyades.execution.testgen.http.TRCNodeDispatcher;
import org.eclipse.hyades.execution.testgen.http.Testgen;
import org.eclipse.hyades.execution.testgen.http.TestgenHttpPlugin;
import org.eclipse.hyades.internal.execution.testgen.TestgenException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class TRCFileLoader
extends DefaultHandler {
    private XMLReader xmlReader;
    private FileReader fileReader;
    private LinkedList list = new LinkedList();
    private TRCFileLoader handler = this;
    private TRCNodeAssembler assembler;
    private TRCNodeDispatcher dispatcher;
    private Testgen.ProgressUpdater updater;
    private PrintStream debugStream;

    public TRCFileLoader(Testgen.ProgressUpdater progressUpdater) {
        this.updater = progressUpdater;
    }

    public TRCFileLoader(Testgen.ProgressUpdater progressUpdater, PrintStream printStream) {
        this.updater = progressUpdater;
        this.debugStream = printStream;
    }

    public boolean load(IFile iFile, String string) throws TestgenException {
        Object object;
        if (iFile == null) {
            throw new TestgenException(TestgenHttpPlugin.getResourceString("E_INVALID_REC_FILE"));
        }
        TRCContext tRCContext = new TRCContext();
        File file = new File(string.toString());
        tRCContext.setOutputFolder((IPath)new Path(file.getParent()));
        String string2 = file.getName();
        string2 = string2.substring(0, string2.lastIndexOf(46));
        tRCContext.setTestSuiteBaseName(string2);
        tRCContext.newTestSuiteContext();
        this.dispatcher = new TRCNodeDispatcher(tRCContext);
        this.assembler = new TRCNodeAssembler(this.dispatcher);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setValidating(false);
        try {
            sAXParserFactory.setFeature("http://xml.org/sax/features/validation", false);
            sAXParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            sAXParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            object = sAXParserFactory.newSAXParser();
            this.xmlReader = ((SAXParser)object).getXMLReader();
        }
        catch (SAXException sAXException) {
            throw new TestgenException(TestgenHttpPlugin.getResourceString("E_SAX_DRIVER_FAILURE"), (Exception)sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new TestgenException(TestgenHttpPlugin.getResourceString("E_SAX_DRIVER_FAILURE"), (Exception)parserConfigurationException);
        }
        if (this.xmlReader == null) {
            throw new TestgenException(TestgenHttpPlugin.getResourceString("E_SAX_DRIVER_FAILURE"));
        }
        this.xmlReader.setContentHandler(this.handler);
        this.xmlReader.setErrorHandler(this.handler);
        object = null;
        try {
            object = iFile.getContents();
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        InputSource inputSource = new InputSource((InputStream)object);
        try {
            this.xmlReader.parse(inputSource);
        }
        catch (IOException iOException) {
            throw new TestgenException(TestgenHttpPlugin.getResourceString("E_SAX_IOEXCEPTION"), (Exception)iOException);
        }
        catch (SAXException sAXException) {
            throw new TestgenException(TestgenHttpPlugin.getResourceString("E_SAX_SAXEXCEPTION"), (Exception)sAXException);
        }
        tRCContext.finish();
        return true;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        this.updater.progress(TestgenHttpPlugin.getResourceString("I_PROCESSING") + " " + string3);
        TRCElement tRCElement = new TRCElement(attributes.getLength());
        tRCElement.setName(string3);
        for (int i = 0; i < attributes.getLength(); ++i) {
            tRCElement.addAttribute(attributes.getQName(i), attributes.getValue(i));
        }
        this.list.addLast(tRCElement);
        try {
            this.assembler.newElement(tRCElement, this.list.size(), string3);
        }
        catch (TestgenException testgenException) {
            testgenException.printStackTrace();
        }
    }

    public void endElement(String string, String string2, String string3) {
        TRCElement tRCElement = (TRCElement)this.list.removeLast();
        try {
            this.assembler.completeElement(tRCElement, this.list.size() + 1, string3);
        }
        catch (TestgenException testgenException) {
            testgenException.printStackTrace();
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        TRCElement tRCElement = (TRCElement)this.list.getLast();
        tRCElement.setContent(new String(cArray, n, n2));
    }
}

