/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.testgen.http;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.execution.testgen.http.TRCContext;
import org.eclipse.hyades.execution.testgen.http.TRCNode;
import org.eclipse.hyades.execution.testgen.http.TRCNodeHandler;
import org.eclipse.hyades.execution.testgen.http.TestgenHttpPlugin;
import org.eclipse.hyades.internal.execution.testgen.TestgenException;

public class TRCNodeDispatcher {
    private static final String DEFAULT_HANDLER_PACKAGE_NAME = "org.eclipse.hyades.execution.testgen.http";
    private static final String[] HANDLER_KINDS = new String[]{"TRCAnnotation", "TRCConnection", "TRCExecutorInfo", "TRCPacket", "TRCRecorderInfo"};
    private static final String NODE_HANDLER_NAME_SUFFIX = "NodeHandler";
    private static final String NODE_HANDLER_BASE_CLASS_NAME = "TRCNodeHandler";
    private HashMap map = new HashMap();

    public TRCNodeDispatcher(TRCContext tRCContext) throws TestgenException {
        this.registerHandlersFromRegistry(tRCContext);
        this.registerHandlersFromProperties(tRCContext);
    }

    private void registerHandlersFromRegistry(TRCContext tRCContext) throws TestgenException {
        IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
        IExtensionPoint iExtensionPoint = iPluginRegistry.getExtensionPoint(DEFAULT_HANDLER_PACKAGE_NAME, "nodeHandlers");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        for (int i = 0; i < iExtensionArray.length; ++i) {
            IExtension iExtension = iExtensionArray[i];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            for (int j = 0; j < iConfigurationElementArray.length; ++j) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[j];
                String string = iConfigurationElement.getAttribute("nodeKind");
                TRCNodeHandler tRCNodeHandler = null;
                try {
                    tRCNodeHandler = (TRCNodeHandler)iConfigurationElement.createExecutableExtension("class");
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
                tRCNodeHandler.init(tRCContext);
                this.registerHandler(string, tRCNodeHandler);
            }
        }
    }

    private void registerHandlersFromProperties(TRCContext tRCContext) throws TestgenException {
        for (int i = 0; i < HANDLER_KINDS.length; ++i) {
            String string = HANDLER_KINDS[i];
            if (this.handlerIsRegistered(string)) continue;
            String string2 = string + NODE_HANDLER_NAME_SUFFIX;
            String string3 = TestgenHttpPlugin.getResourceString(string2);
            if (string3.equals(string2)) {
                string3 = "org.eclipse.hyades.execution.testgen.http." + string2;
            }
            TRCNodeHandler tRCNodeHandler = this.newNodeHandler(string3, tRCContext);
            tRCNodeHandler.init(tRCContext);
            this.registerHandler(HANDLER_KINDS[i], tRCNodeHandler);
        }
    }

    private void registerHandler(String string, TRCNodeHandler tRCNodeHandler) {
        this.map.put(string, tRCNodeHandler);
    }

    private boolean handlerIsRegistered(String string) {
        return this.map.get(string) != null;
    }

    private TRCNodeHandler newNodeHandler(String string, TRCContext tRCContext) throws TestgenException {
        Object object;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            throw new TestgenException(TestgenHttpPlugin.getResourceString("E_LOAD_NODE_HANDLER") + " " + string, exception);
        }
        String string2 = "org.eclipse.hyades.execution.testgen.http.TRCNodeHandler";
        if (!string.equals(string2) && !((Class)(object = clazz.getSuperclass())).getName().equals(string2)) {
            throw new TestgenException(TestgenHttpPlugin.getResourceString("E_INVALID_NODE_HANDLER") + " " + string);
        }
        object = null;
        try {
            Constructor<?> constructor = clazz.getConstructor(null);
            object = (TRCNodeHandler)constructor.newInstance(null);
        }
        catch (Exception exception) {
            throw new TestgenException(null, exception);
        }
        return object;
    }

    public void dispatch(TRCNode tRCNode) throws TestgenException {
        TRCNodeHandler tRCNodeHandler = (TRCNodeHandler)this.map.get(tRCNode.getName());
        if (tRCNodeHandler == null) {
            tRCNodeHandler = new TRCNodeHandler();
            this.registerHandler(tRCNode.getName(), tRCNodeHandler);
        }
        tRCNodeHandler.node(tRCNode);
    }
}

