/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.extension;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.extension.IWriteAccessChangeListener;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.ui.adapter.ISynchronizedEditorAdapter;
import org.eclipse.hyades.ui.editor.EditorExtension;
import org.eclipse.hyades.ui.editor.IHyadesEditorExtension;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public abstract class BaseEditorExtension
extends EditorExtension
implements ISynchronizedEditorAdapter,
IHyadesEditorExtension {
    private ListenerList writeAccessChangeListeners = new ListenerList();
    private boolean dirty = false;
    private Clipboard clipboard;
    static /* synthetic */ Class class$org$eclipse$hyades$ui$adapter$ISynchronizedEditorAdapter;

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        this.writeAccessChangeListeners.clear();
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        if ((class$org$eclipse$hyades$ui$adapter$ISynchronizedEditorAdapter == null ? (class$org$eclipse$hyades$ui$adapter$ISynchronizedEditorAdapter = BaseEditorExtension.class$("org.eclipse.hyades.ui.adapter.ISynchronizedEditorAdapter")) : class$org$eclipse$hyades$ui$adapter$ISynchronizedEditorAdapter) == adapter) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    protected ResourceSet getResourceSet() {
        return ((EObject)this.getHyadesEditorPart().getEditorObject()).eResource().getResourceSet();
    }

    public Clipboard getClipboard() {
        if (this.clipboard == null) {
            this.clipboard = new Clipboard(this.getHyadesEditorPart().getEditorPart().getEditorSite().getShell().getDisplay());
        }
        return this.clipboard;
    }

    public void addListener(IWriteAccessChangeListener listener) {
        this.writeAccessChangeListeners.add((Object)listener);
    }

    public void removeListener(IWriteAccessChangeListener listener) {
        this.writeAccessChangeListeners.remove((Object)listener);
    }

    protected void notifyWriteAccessChangeListeners(IFile file, boolean isReadOnly) {
        if (file == null) {
            return;
        }
        Object[] listeners = this.writeAccessChangeListeners.getListeners();
        int maxi = listeners.length;
        for (int i = 0; i < maxi; ++i) {
            ((IWriteAccessChangeListener)listeners[i]).writeAccessChanged(file, isReadOnly);
        }
    }

    public synchronized void markDirty() {
        if (!this.dirty) {
            this.dirty = true;
            this.getHyadesEditorPart().firePropertyChange(257);
        }
    }

    protected void clearDirty() {
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public final void doSave(IProgressMonitor monitor) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                try {
                    BaseEditorExtension.this.save(monitor);
                    BaseEditorExtension.this.clearDirty();
                }
                catch (Exception e) {
                    BaseEditorExtension.this.handleException(e);
                }
            }
        };
        IActionBars actionBars = this.getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
        if (actionBars != null && actionBars.getStatusLineManager() != null) {
            actionBars.getStatusLineManager().setErrorMessage(null);
            actionBars.getStatusLineManager().setMessage(null);
            monitor = actionBars.getStatusLineManager().getProgressMonitor();
            actionBars.getStatusLineManager().setCancelEnabled(false);
        } else if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            ModalContext.run((IRunnableWithProgress)operation, (boolean)false, (IProgressMonitor)monitor, (Display)Display.getCurrent());
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void save(IProgressMonitor monitor) throws Exception {
        Resource[] resources = (Resource[])this.getResourceSet().getResources().toArray((Object[])new Resource[this.getResourceSet().getResources().size()]);
        int length = resources.length;
        int counter = 0;
        monitor.beginTask("", length);
        int maxi = resources.length;
        for (int i = 0; i < maxi; ++i) {
            if (resources[i].isModified()) {
                this.logSaveMessage(monitor, resources[i], length, counter++);
                EMFUtil.save(resources[i]);
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    protected void logSaveMessage(IProgressMonitor monitor, Resource resource, int total, int current) {
        String resourceName = "";
        IFile file = EMFUtil.getWorkspaceFile(resource);
        if (file != null) {
            resourceName = file.getFullPath().toString();
        }
        monitor.subTask(TestUIPlugin.getString("PRG_SAVE_RSRS", new String[]{Integer.toString(current), Integer.toString(total), resourceName}));
    }

    protected void handleException(Exception exception) {
        TestUIPlugin.logError(exception);
        String filePath = "";
        IFile file = EMFUtil.getWorkspaceFile((EObject)this.getHyadesEditorPart().getEditorObject());
        if (file != null) {
            filePath = file.getFullPath().toString();
        }
        UIUtil.openSaveFileErrorDialog((Shell)this.getHyadesEditorPart().getEditorPart().getSite().getShell(), (String)filePath, (Throwable)exception);
    }

    protected boolean reloadEditorObject() {
        Resource resource = ((EObject)this.getHyadesEditorPart().getEditorObject()).eResource();
        resource.unload();
        try {
            resource.load(EMFUtil.RESOURCE_OPTIONS);
        }
        catch (Exception e) {
            TestUIPlugin.logError(e);
        }
        if (!resource.getContents().isEmpty()) {
            this.getHyadesEditorPart().setEditorObject(resource.getContents().get(0));
        } else {
            this.getHyadesEditorPart().setEditorObject(null);
        }
        return false;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part instanceof TestNavigator) {
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() != 1) {
                return;
            }
            URI uri = this.getObjectURI(structuredSelection.getFirstElement());
            if (uri == null) {
                return;
            }
            EObject eObject = this.getResourceSet().getEObject(uri, false);
            if (eObject == null) {
                return;
            }
            this.setSelection((IStructuredSelection)new StructuredSelection((Object)eObject));
        }
    }

    protected URI getObjectURI(Object object) {
        EObject eObject;
        if (object != null && object instanceof EObject && (eObject = (EObject)object).eResource() != null) {
            return eObject.eResource().getURI().appendFragment(eObject.eResource().getURIFragment(eObject));
        }
        return null;
    }

    public boolean editorFileChanged() {
        return false;
    }

    public boolean editorFileDeleted() {
        return false;
    }

    public boolean editorFileWriteAccessChanged(boolean isReadOnly) {
        this.notifyWriteAccessChangeListeners(EMFUtil.getWorkspaceFile((EObject)this.getHyadesEditorPart().getEditorObject()), isReadOnly);
        return false;
    }

    public void handle(List changedFiles, List removedFiles) {
    }

    public boolean reload() {
        Object selection;
        String fragment = null;
        IStructuredSelection structuredSelection = this.getSelection();
        if (structuredSelection.size() == 1 && (selection = structuredSelection.getFirstElement()) instanceof EObject) {
            fragment = ((EObject)selection).eResource().getURIFragment((EObject)selection);
        }
        if (!this.reloadEditorObject()) {
            Object editorObject = this.getHyadesEditorPart().getEditorObject();
            this.refreshContent(editorObject);
            if (editorObject instanceof EObject && fragment != null) {
                EObject selection2 = ((EObject)editorObject).eResource().getEObject(fragment);
                structuredSelection = selection2 != null ? new StructuredSelection((Object)selection2) : StructuredSelection.EMPTY;
                this.setSelection(structuredSelection);
            }
            this.dirty = false;
            this.getHyadesEditorPart().firePropertyChange(257);
        }
        return true;
    }

    public boolean doSaveEditorFile(boolean wasDeleted) {
        this.getHyadesEditorPart().getEditorPart().doSave((IProgressMonitor)new NullProgressMonitor());
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

