/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.tabs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.ui.internal.launch.providers.ExecutionHistoryLocationProvider;
import org.eclipse.hyades.test.ui.launch.configurations.ExecutionHistoryLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.extensions.IExecutionResultsLocationFilter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExecutionHistoryTab
extends AbstractLaunchConfigurationTab {
    private TreeViewer tree;
    private Text nameText;
    private Button override;
    protected boolean userHasChosenName;
    protected boolean userHasChosenOverrideState;
    protected boolean userHasChosenLocation;
    protected boolean disableNotification = false;
    private String launchConfigurationType;

    public ExecutionHistoryTab(String launchConfigurationType) {
        this.launchConfigurationType = launchConfigurationType;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Label lblName = new Label(composite, 0);
        GridData gdl = new GridData(32);
        gdl.horizontalSpan = 2;
        lblName.setLayoutData((Object)gdl);
        lblName.setText(TestUIPlugin.getString("ExecutionHistoryTab.name"));
        this.nameText = new Text(composite, 2048);
        GridData gdt = new GridData(768);
        gdt.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)gdt);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ExecutionHistoryTab.this.disableNotification) {
                    ExecutionHistoryTab.this.userHasChosenName = true;
                    ExecutionHistoryTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.override = new Button(composite, 32);
        this.override.setText(TestUIPlugin.getString("ExecutionHistoryTab.override"));
        this.override.setToolTipText(TestUIPlugin.getString("ExecutionHistoryTab.overrideTooltip"));
        this.override.setSelection(false);
        this.override.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ExecutionHistoryTab.this.disableNotification) {
                    ExecutionHistoryTab.this.userHasChosenOverrideState = true;
                    ExecutionHistoryTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        GridData gdl3 = new GridData(32);
        gdl3.horizontalSpan = 2;
        this.override.setLayoutData((Object)gdl3);
        Label lblLocation = new Label(composite, 0);
        GridData gdl2 = new GridData(32);
        gdl2.horizontalSpan = 2;
        lblLocation.setLayoutData((Object)gdl2);
        lblLocation.setText(TestUIPlugin.getString("ExecutionHistoryTab.location"));
        this.createLocationSelector(composite);
        this.setControl((Control)composite);
    }

    private void createLocationSelector(Composite composite) {
        GridData grid = new GridData(1808);
        grid.widthHint = composite.getClientArea().width / 2;
        grid.heightHint = composite.getClientArea().height / 2;
        this.tree = new TreeViewer(composite);
        this.tree.getControl().setLayoutData((Object)grid);
        IExecutionResultsLocationFilter filter = LaunchConfigurationExtensionsManager.getInstance().getExecutionResultsLocationFilter(this.launchConfigurationType);
        ExecutionHistoryLocationProvider provider = new ExecutionHistoryLocationProvider(filter);
        this.tree.setContentProvider((IContentProvider)provider);
        this.tree.setLabelProvider((IBaseLabelProvider)provider);
        this.tree.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.tree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!ExecutionHistoryTab.this.disableNotification) {
                    ExecutionHistoryTab.this.userHasChosenLocation = true;
                    ExecutionHistoryTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        ExecutionHistoryLaunchConfigurationFacade.setUsingDefaultName(configuration, true);
        ExecutionHistoryLaunchConfigurationFacade.setUsingDefaultOverrideState(configuration, true);
        ExecutionHistoryLaunchConfigurationFacade.setUsingDefaultLocation(configuration, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.userHasChosenName = !ExecutionHistoryLaunchConfigurationFacade.isUsingDefaultName(configuration);
            this.userHasChosenOverrideState = !ExecutionHistoryLaunchConfigurationFacade.isUsingDefaultOverrideState(configuration);
            this.userHasChosenLocation = !ExecutionHistoryLaunchConfigurationFacade.isUsingDefaultLocation(configuration);
            this.disableNotification = true;
            try {
                String name = ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryName(configuration);
                if (name == null) {
                    this.nameText.setText("");
                } else {
                    this.nameText.setText(name);
                }
                boolean overrideState = ExecutionHistoryLaunchConfigurationFacade.isExecutionHistoryOverriden(configuration);
                this.override.setSelection(overrideState);
                IContainer location = ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryLocation(configuration);
                if (location == null) {
                    this.tree.setSelection((ISelection)new StructuredSelection());
                } else {
                    StructuredSelection sel = new StructuredSelection((Object)location);
                    this.tree.setSelection((ISelection)sel, true);
                }
            }
            finally {
                this.disableNotification = false;
            }
        }
        catch (CoreException e) {
            TestUIPlugin.logError(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.userHasChosenName) {
            String name = this.getExecutionHistoryName();
            ExecutionHistoryLaunchConfigurationFacade.setExecutionHistoryName(configuration, name);
        } else {
            ExecutionHistoryLaunchConfigurationFacade.setUsingDefaultName(configuration, true);
        }
        if (this.userHasChosenOverrideState) {
            boolean overrideState = this.getOverrideState();
            ExecutionHistoryLaunchConfigurationFacade.setExecutionHistoryOverriden(configuration, overrideState);
        } else {
            ExecutionHistoryLaunchConfigurationFacade.setUsingDefaultOverrideState(configuration, true);
        }
        if (this.userHasChosenLocation) {
            IContainer location = this.getSelectedLocation();
            ExecutionHistoryLaunchConfigurationFacade.setExecutionHistoryLocation(configuration, location);
        } else {
            ExecutionHistoryLaunchConfigurationFacade.setUsingDefaultLocation(configuration, true);
        }
    }

    public String getName() {
        return TestUIPlugin.getString("ExecutionHistoryTab.tabName");
    }

    public Image getImage() {
        return TestUIImages.INSTANCE.getImage("launch_execresultstab.gif");
    }

    private String getExecutionHistoryName() {
        return this.nameText.getText();
    }

    public boolean getOverrideState() {
        return this.override.getSelection();
    }

    private IContainer getSelectedLocation() {
        Object obj;
        ISelection selection = this.tree.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IContainer) {
            return (IContainer)obj;
        }
        return null;
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        IContainer location;
        String name;
        this.setErrorMessage(null);
        try {
            name = ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryName(configuration);
        }
        catch (CoreException e) {
            TestUIPlugin.logError(e);
            name = null;
        }
        if (name == null || name.equals("")) {
            this.setErrorMessage(TestUIPlugin.getString("_ERROR_ExecutionHistoryTab.invalidName"));
            return false;
        }
        try {
            location = ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryLocation(configuration);
        }
        catch (CoreException e) {
            TestUIPlugin.logError(e);
            location = null;
        }
        if (location == null) {
            this.setErrorMessage(TestUIPlugin.getString("_ERROR_ExecutionHistoryTab.invalidLocation"));
            return false;
        }
        return true;
    }
}

