/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.wizard.DeploymentMapPage;
import org.eclipse.hyades.test.ui.internal.wizard.DeploymentObjectPage;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.PartInitException;

public class DeploymentNewWizard
extends HyadesNewWizard {
    DeploymentObjectPage artifactPage = null;
    DeploymentObjectPage locationPage = null;
    DeploymentMapPage mapPage = null;
    TPFDeployment deployment = null;

    public DeploymentNewWizard() {
        this.setWindowTitle(TestUIPlugin.getString("WIZ_DEPLOY_TTL"));
        this.setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("newdeployment_wiz.gif"));
        IDialogSettings dialogSettings = TestUIPlugin.getInstance().getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection("TestSuiteNewWizard");
        if (settings == null) {
            settings = dialogSettings.addNewSection("TestSuiteNewWizard");
        }
        this.setDialogSettings(settings);
        this.deployment = Common_TestprofileFactory.eINSTANCE.createTPFDeployment();
    }

    protected String getFileExtension() {
        return "deploy";
    }

    public void addPages() {
        this.getLocationPage().setTitle(TestUIPlugin.getString("WIZ_DEPLOY_PG_TTL"));
        this.getLocationPage().setDescription(TestUIPlugin.getString("WIZ_DEPLOY_PG_LOC_DSC"));
        this.addPage((IWizardPage)this.getLocationPage());
        this.getAttributeWizardPage().setTitle(TestUIPlugin.getString("WIZ_DEPLOY_PG_TTL"));
        this.getAttributeWizardPage().setDescription(TestUIPlugin.getString("WIZ_DEPLOY_PG_ATT_DSC"));
        this.addPage((IWizardPage)this.getAttributeWizardPage());
        String pageName = TestUIPlugin.getString("W_DEPLOYMENT") + " ";
        this.artifactPage = new DeploymentObjectPage(pageName + TestUIPlugin.getString("W_ARTIFACTS"), this.deployment, Common_ConfigurationFactory.eINSTANCE.createCFGArtifact());
        this.artifactPage.setTitle(TestUIPlugin.getString("WIZ_DEPLOY_PG_TTL"));
        this.artifactPage.setDescription(TestUIPlugin.getString("WIZ_DEPLOY_PG_ART_DSC"));
        this.addPage((IWizardPage)this.artifactPage);
        this.locationPage = new DeploymentObjectPage(pageName + TestUIPlugin.getString("W_LOCS"), this.deployment, Common_ConfigurationFactory.eINSTANCE.createCFGMachineConstraint());
        this.locationPage.setTitle(TestUIPlugin.getString("WIZ_DEPLOY_PG_TTL"));
        this.locationPage.setDescription(TestUIPlugin.getString("WIZ_DEPLOY_PG_LOCATION_DSC"));
        this.addPage((IWizardPage)this.locationPage);
        this.mapPage = new DeploymentMapPage(pageName + TestUIPlugin.getString("W_PAIRS"), this.deployment);
        this.mapPage.setTitle(TestUIPlugin.getString("WIZ_DEPLOY_PG_TTL"));
        this.mapPage.setDescription(TestUIPlugin.getString("WIZ_DEPLOY_PG_MAP_DSC"));
        this.addPage((IWizardPage)this.mapPage);
    }

    protected boolean createObject(IFile file) throws Exception {
        Resource resource = this.createResource(file);
        resource.getContents().add((Object)this.createEObject());
        EMFUtil.save(resource);
        return true;
    }

    protected EObject createEObject() {
        this.deployment.setName(this.getAttributeWizardPage().getItemName());
        String description = this.getAttributeWizardPage().getItemDescription();
        if (description != null && description.trim().length() > 0) {
            this.deployment.setDescription(description);
        }
        return this.deployment;
    }

    protected Resource createResource(IFile file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString());
        Resource.Factory factory = EMFUtil.getResourceFactory("deploy");
        return factory.createResource(uri);
    }

    protected void openEditor(IFile file) throws PartInitException {
        if (TestUIPlugin.getInstance().getPreferenceStore().getBoolean("openEditor")) {
            UIUtil.openEditor((IFile)file, (String)"org.eclipse.hyades.test.ui.editor.DeploymentEditorPart", (boolean)false);
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        this.mapPage.refresh();
        return super.getNextPage(page);
    }
}

