/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.recorder;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.hyades.internal.execution.recorder.Recorder;
import org.eclipse.hyades.internal.execution.recorder.ui.actions.IRecorderAction;

public class RecorderFactory {
    private static RecorderFactory instance = null;
    private HashMap recorderMap = new HashMap();
    private HashMap listeningActionMap = new HashMap();
    private String[] recorderIDs = null;

    public static RecorderFactory getInstance() {
        if (instance == null) {
            instance = new RecorderFactory();
        }
        return instance;
    }

    protected void addRecorder(Recorder recorder) {
        this.recorderMap.put(recorder.getId(), recorder);
    }

    private RecorderFactory() {
    }

    public String[] getRecorderIDs() {
        if (this.recorderIDs == null) {
            Object[] objectArray = this.recorderMap.keySet().toArray();
            this.recorderIDs = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                this.recorderIDs[i] = (String)objectArray[i];
            }
        }
        return this.recorderIDs;
    }

    public Recorder getRecorderWithID(String string) {
        return (Recorder)this.recorderMap.get(string);
    }

    public Recorder getActiveRecorder() {
        Collection collection = this.recorderMap.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Recorder recorder = (Recorder)iterator.next();
            if (!recorder.isActive()) continue;
            return recorder;
        }
        return null;
    }

    public void addListener(IRecorderAction iRecorderAction) {
        this.listeningActionMap.put(iRecorderAction.toString(), iRecorderAction);
        if (this.getActiveRecorder() == null) {
            iRecorderAction.updateRecorderStatus(false);
        } else {
            iRecorderAction.updateRecorderStatus(this.getActiveRecorder().isActive());
        }
    }

    public void updateActiveState(Recorder recorder, boolean bl) {
        Object[] objectArray = this.listeningActionMap.values().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof IRecorderAction)) continue;
            ((IRecorderAction)objectArray[i]).updateRecorderStatus(bl);
        }
    }
}

