/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.recorder.local;

import java.net.InetAddress;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.recorder.local.IRecorderDataProcessor;
import org.eclipse.hyades.internal.execution.recorder.remote.IRecorderMessageTypes;
import org.eclipse.hyades.internal.execution.recorder.ui.views.RecorderControlView;

public class RecorderDataProcessorHelper
implements DataProcessor,
IRecorderMessageTypes {
    private IRecorderDataProcessor loadTestDataProcessor = null;
    private boolean recordingComplete;
    private int bytesReceived = 0;
    private Date lastReceivedReportTime = null;

    public RecorderDataProcessorHelper(IRecorderDataProcessor iRecorderDataProcessor) {
        this.loadTestDataProcessor = iRecorderDataProcessor;
    }

    public void incommingData(byte[] byArray, int n, InetAddress inetAddress) {
        int n2 = this.decipherContolByte(byArray);
        byte[] byArray2 = this.trimBuffer(byArray, n);
        switch (n2) {
            case 1: {
                this.loadTestDataProcessor.processData(byArray2);
                this.updateBytesRecievedControl(n, false);
                break;
            }
            case 3: {
                this.loadTestDataProcessor.processControlString(new String(byArray2));
                break;
            }
            case 4: {
                this.complete();
                break;
            }
            default: {
                String string = new String(byArray2);
                this.loadTestDataProcessor.processDebugString(string);
            }
        }
    }

    private void updateBytesRecievedControl(int n, boolean bl) {
        this.bytesReceived += n;
        Date date = Calendar.getInstance().getTime();
        if (bl || this.lastReceivedReportTime == null || date.getTime() - this.lastReceivedReportTime.getTime() > 500L) {
            RecorderControlView.getInstance().setKBytesReceived(this.bytesReceived / 1000);
            this.lastReceivedReportTime = date;
        }
    }

    private byte[] trimBuffer(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n - 1];
        for (int i = 1; i < n; ++i) {
            byArray2[i - 1] = byArray[i];
        }
        return byArray2;
    }

    private int decipherContolByte(byte[] byArray) {
        return new Integer(byArray[0]);
    }

    public void incommingData(char[] cArray, int n, InetAddress inetAddress) {
    }

    public void invalidDataType(byte[] byArray, int n, InetAddress inetAddress) {
    }

    public void waitingForData() {
    }

    private void complete() {
        this.updateBytesRecievedControl(0, true);
        this.loadTestDataProcessor.complete();
        this.recordingComplete = true;
    }

    public boolean isRecordingComplete() {
        return this.recordingComplete;
    }
}

