/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.load;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.ui.IWorkbenchPage;

public class LoadersManager {
    private static IUml2SDLoader currentLoader;
    private static LoadersManager loadersManager;

    private LoadersManager() {
    }

    public static LoadersManager getLoadersManager() {
        if (loadersManager == null) {
            loadersManager = new LoadersManager();
        }
        return loadersManager;
    }

    public IUml2SDLoader createLoader(String className, ClassLoader cl, SDView view) {
        IUml2SDLoader loader = null;
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        try {
            Class<?> clazz = cl.loadClass(className);
            loader = (IUml2SDLoader)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        this.setCurrentLoader(loader);
        if (loader != null) {
            loader.setViewer(view);
        }
        return loader;
    }

    public void setCurrentLoader(IUml2SDLoader loader) {
        if (currentLoader != null) {
            IWorkbenchPage persp;
            SDView view;
            if (loader != null && (view = (SDView)(persp = UIPlugin.getActivePage()).findView("org.eclipse.hyades.uml2sd.ui.view.SDView")) != null) {
                view.resetProviders();
            }
            currentLoader.aboutToBeReplaced();
        }
        if ((currentLoader = loader) != null) {
            SDViewerPlugin.getDefault().setLastLoader(currentLoader.getClass().getName());
        }
    }

    public IUml2SDLoader getCurrentLoader() {
        if (currentLoader == null) {
            SDViewerPlugin.getDefault().createLastLoaderIfAny();
        }
        return currentLoader;
    }
}

