/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class JarReader {
    private JarInputStream fJarInputStream;

    public JarReader(File file) throws IOException {
        this.fJarInputStream = new JarInputStream(new FileInputStream(file));
    }

    public Manifest getManifest() throws IOException {
        return this.fJarInputStream.getManifest();
    }

    public void extractAll(File file) throws IOException {
        JarEntry jarEntry;
        if (!file.exists()) {
            throw new MissingTargetDirectoryException(file.toString());
        }
        while ((jarEntry = this.fJarInputStream.getNextJarEntry()) != null) {
            int n;
            Object object;
            String string;
            if (jarEntry.getName().startsWith("..")) {
                throw new EntryStartsWithDotDotException(jarEntry.getName());
            }
            if (jarEntry.isDirectory()) {
                string = jarEntry.getName();
                File file2 = new File(file, string);
                if (file2.exists() || file2.mkdirs()) continue;
                throw new FailedToCreateDirectoryOrFile(file2.toString());
            }
            string = jarEntry.getName();
            int n2 = string.lastIndexOf(47);
            if (n2 != -1) {
                object = string.substring(0, n2);
                File file3 = new File(file.getCanonicalPath() + File.separator + (String)object);
                if (!file3.exists() ? !file3.mkdirs() : !file3.isDirectory()) {
                    throw new FailedToCreateDirectoryOrFile(file3.toString());
                }
            }
            if (!((File)(object = new File(file, string))).createNewFile()) {
                throw new FailedToCreateDirectoryOrFile(((File)object).toString());
            }
            int n3 = (int)jarEntry.getSize();
            FileOutputStream fileOutputStream = new FileOutputStream((File)object);
            int n4 = Math.max(n3, 4096);
            byte[] byArray = new byte[n4];
            while ((n = this.fJarInputStream.read(byArray, 0, n4)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
        }
    }

    public void close() throws IOException {
        if (this.fJarInputStream != null) {
            this.fJarInputStream.close();
        }
    }

    public static class FailedToCreateDirectoryOrFile
    extends IOException {
        public FailedToCreateDirectoryOrFile(String string) {
            super(string);
        }
    }

    public static class EntryStartsWithDotDotException
    extends IOException {
        public EntryStartsWithDotDotException(String string) {
            super(string);
        }
    }

    public static class MissingTargetDirectoryException
    extends IOException {
        public MissingTargetDirectoryException(String string) {
            super(string);
        }
    }
}

