/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.testgen;

import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class TestGeneratorFactory {
    private String extensionPointID = "org.eclipse.hyades.execution.testgen.TestGenerator";
    private static TestGeneratorFactory instance = null;
    private HashMap elementsByID = new HashMap();

    private TestGeneratorFactory() {
    }

    public static TestGeneratorFactory getInstance() {
        if (instance == null) {
            instance = new TestGeneratorFactory();
            instance.loadMetadata();
        }
        return instance;
    }

    private void loadMetadata() {
        IConfigurationElement[] iConfigurationElementArray = Platform.getPluginRegistry().getConfigurationElementsFor(this.extensionPointID);
        for (int i = 0; i < iConfigurationElementArray.length; ++i) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[i];
            this.elementsByID.put(iConfigurationElement.getAttribute("id"), iConfigurationElement);
        }
    }

    public String getGeneratorName(String string) {
        return ((IConfigurationElement)this.elementsByID.get(string)).getAttribute("name");
    }

    public String getGeneratorClassPath(String string) {
        return ((IConfigurationElement)this.elementsByID.get(string)).getAttribute("class");
    }

    public int getGeneratorPriority(String string) {
        String string2 = ((IConfigurationElement)this.elementsByID.get(string)).getAttribute("priority");
        if (string2 == null) {
            return 0;
        }
        try {
            int n = Integer.parseInt(string2);
            if (n < -1 || n > 99) {
                return -1;
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public String[] getGeneratorIDs() {
        Object[] objectArray = this.elementsByID.keySet().toArray();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        return stringArray;
    }

    public String getGeneratorIDByIndex(int n) {
        Object[] objectArray = this.elementsByID.values().toArray();
        if (n > objectArray.length - 1) {
            return null;
        }
        IConfigurationElement iConfigurationElement = (IConfigurationElement)objectArray[n];
        return iConfigurationElement.getAttribute("id");
    }

    public IConfigurationElement getGeneratorConfigElement(String string) {
        return (IConfigurationElement)this.elementsByID.get(string);
    }
}

