/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.impl.tests;

import java.util.Arrays;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.MsgCatalogToken;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.impl.tests.Util;

public class MsgDataElementImplTest
extends TestCase {
    private MsgDataElement mde = null;

    public MsgDataElementImplTest(String string) {
        super(string);
    }

    public void testGetMsgIdType() {
        Assert.assertNull((Object)this.mde.getMsgIdType());
        String string = "Testing getMsgIdType()";
        this.mde.setMsgIdType(string);
        Assert.assertEquals((String)string, (String)this.mde.getMsgIdType());
    }

    public void testSetMsgIdType() {
        String string = "Testing setMsgIdType()";
        this.mde.setMsgIdType(string);
        Assert.assertEquals((String)string, (String)this.mde.getMsgIdType());
        string = "setting another string";
        this.mde.setMsgIdType(string);
        Assert.assertEquals((String)string, (String)this.mde.getMsgIdType());
    }

    public void testGetMsgCatalogType() {
        Assert.assertNull((Object)this.mde.getMsgCatalogType());
        String string = "Testing getMsgCatalogType()";
        this.mde.setMsgCatalogType(string);
        Assert.assertEquals((String)string, (String)this.mde.getMsgCatalogType());
    }

    public void testSetMsgCatalogType() {
        String string = "Testing setMsgCatalogType()";
        this.mde.setMsgCatalogType(string);
        Assert.assertEquals((String)string, (String)this.mde.getMsgCatalogType());
        string = "setting another string";
        this.mde.setMsgCatalogType(string);
        Assert.assertEquals((String)string, (String)this.mde.getMsgCatalogType());
    }

    public void testGetMsgCatalog() {
        Assert.assertNull((Object)this.mde.getMsgCatalog());
        String string = "Testing getMsgCatalog()";
        this.mde.setMsgCatalog(string);
        Assert.assertEquals((String)string, (String)this.mde.getMsgCatalog());
    }

    public void testSetMsgCatalog() {
        String string = "Testing setMsgCatalog()";
        this.mde.setMsgCatalog(string);
        Assert.assertEquals((String)string, (String)this.mde.getMsgCatalog());
        string = "setting another string";
        this.mde.setMsgCatalog(string);
        Assert.assertEquals((String)string, (String)this.mde.getMsgCatalog());
    }

    public void testGetMsgCatalogId() {
        Assert.assertNull((Object)this.mde.getMsgCatalogId());
        String string = "Testing getMsgCatalogId()";
        this.mde.setMsgCatalogId(string);
        Assert.assertEquals((String)string, (String)this.mde.getMsgCatalogId());
    }

    public void testSetMsgCatalogId() {
        String string = "Testing setMsgCatalogId()";
        this.mde.setMsgCatalogId(string);
        Assert.assertEquals((String)string, (String)this.mde.getMsgCatalogId());
        string = "setting another string";
        this.mde.setMsgCatalogId(string);
        Assert.assertEquals((String)string, (String)this.mde.getMsgCatalogId());
    }

    public void testGetMsgId() {
        Assert.assertNull((Object)this.mde.getMsgId());
        String string = "Testing getMsgId()";
        this.mde.setMsgId(string);
        Assert.assertEquals((String)string, (String)this.mde.getMsgId());
    }

    public void testSetMsgId() {
        String string = "Testing setMsgId()";
        this.mde.setMsgId(string);
        Assert.assertEquals((String)string, (String)this.mde.getMsgId());
        string = "setting another string";
        this.mde.setMsgId(string);
        Assert.assertEquals((String)string, (String)this.mde.getMsgId());
    }

    public void testGetMsgLocale() {
        Assert.assertNull((Object)this.mde.getMsgLocale());
        String string = "Testing getMsgLocale()";
        this.mde.setMsgLocale(string);
        Assert.assertEquals((String)string, (String)this.mde.getMsgLocale());
    }

    public void testSetMsgLocale() {
        String string = "Testing setMsgLocale()";
        this.mde.setMsgLocale(string);
        Assert.assertEquals((String)string, (String)this.mde.getMsgLocale());
        string = "setting another string";
        this.mde.setMsgLocale(string);
        Assert.assertEquals((String)string, (String)this.mde.getMsgLocale());
    }

    public void testGetMsgCatalogTokens() {
        Assert.assertTrue((boolean)this.mde.getMsgCatalogTokens().isEmpty());
        String[] stringArray = new String[]{"child1", "child2"};
        this.mde.setMsgCatalogTokensAsStrings(stringArray);
        Assert.assertEquals((int)2, (int)this.mde.getMsgCatalogTokens().size());
    }

    public void testAddMsgCatalogToken() {
        MsgCatalogToken msgCatalogToken = EventFactory.eINSTANCE.createMsgCatalogToken();
        msgCatalogToken.setValue("test1");
        MsgCatalogToken msgCatalogToken2 = EventFactory.eINSTANCE.createMsgCatalogToken();
        msgCatalogToken2.setValue("test2");
        this.mde.addMsgCatalogToken(msgCatalogToken);
        this.mde.addMsgCatalogToken(msgCatalogToken2);
        EList eList = this.mde.getMsgCatalogTokens();
        Assert.assertEquals((int)2, (int)eList.size());
        Assert.assertTrue((boolean)eList.contains(msgCatalogToken));
        Assert.assertTrue((boolean)eList.contains(msgCatalogToken2));
    }

    public void testAddMsgCatalogTokenAsString() {
        String string = "test1";
        String string2 = "test2";
        this.mde.addMsgCatalogTokenAsString(string);
        this.mde.addMsgCatalogTokenAsString(string2);
        String[] stringArray = this.mde.getMsgCatalogTokensAsStrings();
        Assert.assertEquals((int)2, (int)stringArray.length);
        Assert.assertTrue((boolean)Arrays.asList(stringArray).contains(string));
        Assert.assertTrue((boolean)Arrays.asList(stringArray).contains(string2));
    }

    public void testGetMsgCatalogTokensAsStrings() {
        Assert.assertEquals((int)0, (int)this.mde.getMsgCatalogTokensAsStrings().length);
        String[] stringArray = new String[]{"test1", "test2", "test3", "test4"};
        this.mde.setMsgCatalogTokensAsStrings(stringArray);
        String[] stringArray2 = this.mde.getMsgCatalogTokensAsStrings();
        Assert.assertTrue((boolean)Arrays.asList(stringArray2).containsAll(Arrays.asList(stringArray)));
    }

    public void testSetMsgCatalogTokensAsStrings() {
        String[] stringArray = new String[]{"test1", "test2", "test3"};
        this.mde.setMsgCatalogTokensAsStrings(stringArray);
        String[] stringArray2 = this.mde.getMsgCatalogTokensAsStrings();
        Assert.assertTrue((boolean)Arrays.asList(stringArray2).containsAll(Arrays.asList(stringArray)));
        String[] stringArray3 = new String[]{"test4", "test5"};
        this.mde.setMsgCatalogTokensAsStrings(stringArray3);
        stringArray2 = this.mde.getMsgCatalogTokensAsStrings();
        Assert.assertTrue((boolean)Arrays.asList(stringArray2).containsAll(Arrays.asList(stringArray3)));
    }

    public void testSetMsgCatalogTokens() {
        MsgCatalogToken msgCatalogToken = EventFactory.eINSTANCE.createMsgCatalogToken();
        msgCatalogToken.setValue("test1");
        MsgCatalogToken msgCatalogToken2 = EventFactory.eINSTANCE.createMsgCatalogToken();
        msgCatalogToken2.setValue("test2");
        MsgCatalogToken[] msgCatalogTokenArray = new MsgCatalogToken[]{msgCatalogToken, msgCatalogToken2};
        this.mde.setMsgCatalogTokens(msgCatalogTokenArray);
        Assert.assertTrue((boolean)this.mde.getMsgCatalogTokens().containsAll(Arrays.asList(msgCatalogTokenArray)));
        MsgCatalogToken msgCatalogToken3 = EventFactory.eINSTANCE.createMsgCatalogToken();
        msgCatalogToken3.setValue("another test1");
        MsgCatalogToken msgCatalogToken4 = EventFactory.eINSTANCE.createMsgCatalogToken();
        msgCatalogToken4.setValue("another test2");
        MsgCatalogToken[] msgCatalogTokenArray2 = new MsgCatalogToken[]{msgCatalogToken3, msgCatalogToken4};
        this.mde.setMsgCatalogTokens(msgCatalogTokenArray2);
        Assert.assertTrue((boolean)this.mde.getMsgCatalogTokens().containsAll(Arrays.asList(msgCatalogTokenArray2)));
    }

    public void testSerialize() throws Exception {
        MsgDataElement msgDataElement = EventFactory.eINSTANCE.createMsgDataElement();
        msgDataElement.setMsgCatalog("A");
        msgDataElement.setMsgCatalogId("B");
        msgDataElement.setMsgCatalogType("C");
        msgDataElement.setMsgId("D");
        msgDataElement.setMsgIdType("E");
        msgDataElement.setMsgLocale("L");
        MsgCatalogToken msgCatalogToken = EventFactory.eINSTANCE.createMsgCatalogToken();
        msgCatalogToken.setValue("value1");
        msgDataElement.getMsgCatalogTokens().add(msgCatalogToken);
        msgCatalogToken = EventFactory.eINSTANCE.createMsgCatalogToken();
        msgCatalogToken.setValue("value2");
        msgDataElement.getMsgCatalogTokens().add(msgCatalogToken);
        Util.testEObjectSerialization(msgDataElement);
    }

    public void testDuplicateTokens() {
        EventFactory eventFactory = EventFactory.eINSTANCE;
        MsgDataElement msgDataElement = eventFactory.createMsgDataElement();
        msgDataElement.addMsgCatalogTokenAsString("1");
        msgDataElement.addMsgCatalogTokenAsString("1");
        Assert.assertEquals((int)2, (int)msgDataElement.getMsgCatalogTokens().size());
    }

    public void testEquals() {
        MsgDataElement msgDataElement = (MsgDataElement)Util.clone(this.mde);
        Assert.assertEquals((Object)this.mde, (Object)msgDataElement);
        msgDataElement.setMsgIdType("difference");
        Assert.assertFalse((boolean)this.mde.equals(msgDataElement));
    }

    public void testToString() {
        Assert.assertNotNull((Object)this.mde.toString());
    }

    public void testValidationMissingAttributes() throws ValidationException {
        this.mde = EventFactory.eINSTANCE.createMsgDataElement();
        this.mde.validate();
        this.mde = EventFactory.eINSTANCE.createMsgDataElement();
        this.mde.setMsgId("my msg id");
        this.mde.setMsgIdType("my msg id type");
        this.mde.validate();
        this.mde = EventFactory.eINSTANCE.createMsgDataElement();
        this.mde.setMsgIdType(Util.getPaddedString(32));
        try {
            this.mde.validate();
            Assert.fail((String)"missing msgId attribute");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0209E", validationException);
        }
        this.mde = EventFactory.eINSTANCE.createMsgDataElement();
        this.mde.setMsgId(Util.getPaddedString(256));
        try {
            this.mde.validate();
            Assert.fail((String)"missing msgIdType attribute");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0209E", validationException);
        }
        this.mde = EventFactory.eINSTANCE.createMsgDataElement();
        this.mde.setMsgCatalog("my catalog");
        this.mde.setMsgCatalogId("my catalog id");
        this.mde.setMsgCatalogType("my catalog type");
        this.mde.validate();
        this.mde = EventFactory.eINSTANCE.createMsgDataElement();
        this.mde.setMsgCatalog("my catalog");
        this.mde.setMsgCatalogId("my catalog id");
        try {
            this.mde.validate();
            Assert.fail((String)"missing msgCatalogType attribute");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0209E", validationException);
        }
        this.mde = EventFactory.eINSTANCE.createMsgDataElement();
        this.mde.setMsgCatalog("my catalog");
        this.mde.setMsgCatalogType("my catalog type");
        try {
            this.mde.validate();
            Assert.fail((String)"missing msgCatalogId attribute");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0209E", validationException);
        }
        this.mde = EventFactory.eINSTANCE.createMsgDataElement();
        this.mde.setMsgCatalog("my catalog");
        try {
            this.mde.validate();
            Assert.fail((String)"missing msgCatalog... attribute");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0209E", validationException);
        }
        this.mde = EventFactory.eINSTANCE.createMsgDataElement();
        this.mde.setMsgCatalogId("my catalog id");
        this.mde.setMsgCatalogType("my catalog type");
        try {
            this.mde.validate();
            Assert.fail((String)"missing msgCatalof attribute");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0209E", validationException);
        }
        this.mde = EventFactory.eINSTANCE.createMsgDataElement();
        this.mde.setMsgCatalogType("my catalog type");
        try {
            this.mde.validate();
            Assert.fail((String)"missing msgCatalog... attribute");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0209E", validationException);
        }
        this.mde = EventFactory.eINSTANCE.createMsgDataElement();
        this.mde.setMsgCatalogId("my catalog id");
        try {
            this.mde.validate();
            Assert.fail((String)"missing msgCatalog... attribute");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0209E", validationException);
        }
    }

    public void testValidationInvalidLengths() {
        this.mde.setMsgId(Util.getPaddedString(256));
        this.mde.setMsgIdType(Util.getPaddedString(32));
        Util.assertValidBoundaries(this.mde);
        this.mde.setMsgId(Util.getPaddedString(257));
        Util.assertInvalidBoundaries(this.mde, "msgId");
        this.mde.setMsgId(Util.getPaddedString(256));
        Util.assertValidBoundaries(this.mde);
        this.mde.setMsgIdType(Util.getPaddedString(33));
        Util.assertInvalidBoundaries(this.mde, "msgIdType");
        this.mde.setMsgIdType(Util.getPaddedString(32));
        Util.assertValidBoundaries(this.mde);
        this.mde.setMsgCatalogId(Util.getPaddedString(64));
        this.mde.setMsgCatalog(Util.getPaddedString(128));
        this.mde.setMsgCatalogType(Util.getPaddedString(32));
        Util.assertValidBoundaries(this.mde);
        this.mde.setMsgCatalogId(Util.getPaddedString(65));
        Util.assertInvalidBoundaries(this.mde, "msgCatalogId");
        this.mde.setMsgCatalogId(Util.getPaddedString(64));
        Util.assertValidBoundaries(this.mde);
        this.mde.setMsgCatalog(Util.getPaddedString(129));
        Util.assertInvalidBoundaries(this.mde, "msgCatalog");
        this.mde.setMsgCatalog(Util.getPaddedString(128));
        Util.assertValidBoundaries(this.mde);
        this.mde.setMsgCatalogType(Util.getPaddedString(33));
        Util.assertInvalidBoundaries(this.mde, "msgCatalogType");
        this.mde.setMsgCatalogType(Util.getPaddedString(32));
        Util.assertValidBoundaries(this.mde);
        this.mde.setMsgLocale(Util.getPaddedString(11));
        Util.assertValidBoundaries(this.mde);
        this.mde.setMsgLocale(Util.getPaddedString(12));
        Util.assertInvalidBoundaries(this.mde, "msgLocale");
        this.mde.setMsgLocale(Util.getPaddedString(11));
        Util.assertValidBoundaries(this.mde);
        MsgCatalogToken msgCatalogToken = EventFactory.eINSTANCE.createMsgCatalogToken();
        msgCatalogToken.setValue(Util.getAlphaString(256));
        MsgCatalogToken msgCatalogToken2 = EventFactory.eINSTANCE.createMsgCatalogToken();
        msgCatalogToken2.setValue(Util.getAlphaString(256));
        MsgCatalogToken[] msgCatalogTokenArray = new MsgCatalogToken[]{msgCatalogToken, msgCatalogToken2};
        this.mde.setMsgCatalogTokens(msgCatalogTokenArray);
        Util.assertValidBoundaries(this.mde);
        msgCatalogToken2.setValue(Util.getAlphaString(257));
        this.mde.setMsgCatalogTokens(msgCatalogTokenArray);
        Util.assertInvalidBoundaries(this.mde, "msgCatalogTokens");
        msgCatalogToken2.setValue(Util.getAlphaString(256));
        this.mde.setMsgCatalogTokens(msgCatalogTokenArray);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.mde = EventFactory.eINSTANCE.createMsgDataElement();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

