/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.tests;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.hyades.logging.events.cbe.EventException;

public class EventExceptionTest
extends TestCase {
    public EventExceptionTest(String string) {
        super(string);
    }

    public void testEventException() {
        new EventException();
    }

    public void testEventExceptionString() {
        String string = "test";
        EventException eventException = new EventException(string);
        Assert.assertEquals((String)string, (String)eventException.getMessage());
    }

    public void testEventExceptionStringString() {
        EventException eventException = new EventException("LOG_INVALID_JNDI_REFERENCE_EXC_", "org.eclipse.hyades.logging.events.cbe.util.EventMessages");
        EventExceptionTest.assertExceptionMsg(eventException, "LOG_INVALID_JNDI_REFERENCE_EXC_", null);
    }

    public void testEventExceptionStringStringObjectArray() {
        Object[] objectArray = new Object[]{"a"};
        String string = "LOG_INVALID_JNDI_REFERENCE_EXC_";
        EventException eventException = new EventException(string, "org.eclipse.hyades.logging.events.cbe.util.EventMessages", objectArray);
        EventExceptionTest.assertExceptionMsg(eventException, string, objectArray);
    }

    public void testEventExceptionStringStringObjectArrayThrowable() {
        Object[] objectArray = new Object[]{"a"};
        String string = "LOG_INVALID_JNDI_REFERENCE_EXC_";
        Exception exception = new Exception();
        EventException eventException = new EventException(string, "org.eclipse.hyades.logging.events.cbe.util.EventMessages", objectArray, exception);
        EventExceptionTest.assertExceptionMsg(eventException, string, objectArray);
        Assert.assertEquals((Object)exception, (Object)eventException.getCause());
    }

    static void assertExceptionMsg(EventException eventException, String string, Object[] objectArray) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.hyades.logging.events.cbe.util.EventMessages");
        String string2 = resourceBundle.getString(string);
        String string3 = MessageFormat.format(string2, objectArray);
        Assert.assertEquals((String)string3, (String)eventException.getLocalizedMessage());
    }
}

