/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.editor.action;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.hyades.ui.internal.editor.action.CopyAction;
import org.eclipse.hyades.ui.internal.editor.action.CutAction;
import org.eclipse.hyades.ui.internal.editor.action.EditAction;
import org.eclipse.hyades.ui.internal.editor.action.PasteAction;
import org.eclipse.hyades.ui.internal.editor.action.RevertAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.PartSite;

public class ActionHandlerListener
implements IPartListener,
MenuListener {
    public static final ActionHandlerListener DEFAULT = new ActionHandlerListener();
    private List workbenchWindows = new ArrayList();
    private List registeredParts = new ArrayList();
    private EditAction cut;
    private EditAction copy;
    private EditAction paste;
    private RevertAction revert;

    public ActionHandlerListener() {
        this.createEditActions();
    }

    protected void createEditActions() {
        this.cut = new CutAction();
        this.copy = new CopyAction();
        this.paste = new PasteAction();
        this.revert = new RevertAction();
    }

    protected void listenToWorkbenchWindow(IWorkbenchWindow workbenchWindow) {
        if (!this.workbenchWindows.contains(workbenchWindow)) {
            this.workbenchWindows.add(workbenchWindow);
            workbenchWindow.getPartService().addPartListener((IPartListener)this);
            MenuManager menuManager = (MenuManager)((ApplicationWindow)workbenchWindow).getMenuBarManager().findMenuUsingPath("edit");
            if (menuManager != null) {
                menuManager.getMenu().addMenuListener((MenuListener)this);
            }
            if ((menuManager = (MenuManager)((ApplicationWindow)workbenchWindow).getMenuBarManager().findMenuUsingPath("file")) != null) {
                menuManager.getMenu().addMenuListener((MenuListener)this);
            }
        }
    }

    protected IActionBars getActionBars(IWorkbenchPart part) {
        IWorkbenchPartSite partSite;
        IActionBars actionBars = null;
        if (part != null && (partSite = part.getSite()) instanceof PartSite) {
            actionBars = ((PartSite)partSite).getActionBars();
        }
        return actionBars;
    }

    public void connectPart(IWorkbenchPart part) {
        IWorkbenchWindow wbw = part.getSite().getWorkbenchWindow();
        this.listenToWorkbenchWindow(wbw);
        this.registerPartId(part);
        this.connectCutCopyPasteActions(part);
    }

    protected boolean isRegisteredPart(IWorkbenchPart part) {
        String partId = part.getSite().getId();
        return this.registeredParts.contains(partId);
    }

    protected void registerPartId(IWorkbenchPart part) {
        if (!this.isRegisteredPart(part)) {
            String partId = part.getSite().getId();
            this.registeredParts.add(partId);
        }
    }

    protected void connectCutCopyPasteActions(IWorkbenchPart part) {
        this.revert.setWorkbenchPart(part);
        IActionBars actionBars = this.getActionBars(part);
        if (actionBars != null) {
            part.getSite().getKeyBindingService().registerAction((IAction)this.cut);
            part.getSite().getKeyBindingService().registerAction((IAction)this.copy);
            part.getSite().getKeyBindingService().registerAction((IAction)this.paste);
            part.getSite().getKeyBindingService().registerAction((IAction)this.revert);
            this.connectCutCopyPasteActions(actionBars);
        }
    }

    protected void connectCutCopyPasteActions(IActionBars actionBars) {
        if (actionBars.getGlobalActionHandler(ActionFactory.CUT.getId()) == null) {
            actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cut);
        }
        if (actionBars.getGlobalActionHandler(ActionFactory.COPY.getId()) == null) {
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copy);
        }
        if (actionBars.getGlobalActionHandler(ActionFactory.PASTE.getId()) == null) {
            actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.paste);
        }
        if (actionBars.getGlobalActionHandler(ActionFactory.REVERT.getId()) == null) {
            actionBars.setGlobalActionHandler(ActionFactory.REVERT.getId(), (IAction)this.revert);
        }
        this.enableActions();
        actionBars.updateActionBars();
    }

    protected IWorkbenchPart getWorkbenchPart() {
        IWorkbenchWindow wbw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (wbw == null) {
            return null;
        }
        IWorkbenchPage wbp = wbw.getActivePage();
        if (wbp == null) {
            return null;
        }
        return wbp.getActivePart();
    }

    protected void updateActions() {
        IWorkbenchPart part = this.getWorkbenchPart();
        if (part != null && this.isRegisteredPart(part)) {
            this.revert.setWorkbenchPart(part);
            IActionBars actionBars = this.getActionBars(part);
            Control focusControl = this.cut.getFocusControl();
            if (this.isValidFocusControl() && actionBars != null) {
                String clipboardText = this.paste.getClipboardText();
                String selectionText = this.copy.getSelectionText();
                boolean isReadOnly = this.paste.isReadOnlyFocusControl();
                boolean clipboardNotEmpty = clipboardText != null && !clipboardText.equals("");
                boolean textSelected = selectionText != null && !selectionText.equals("");
                this.cut.setEnabled(!isReadOnly && textSelected);
                this.copy.setEnabled(textSelected && (!(focusControl instanceof Combo) || !isReadOnly));
                this.paste.setEnabled(!isReadOnly && clipboardNotEmpty);
            } else {
                this.cut.setEnabled(false);
                this.copy.setEnabled(false);
                this.paste.setEnabled(false);
            }
            actionBars.updateActionBars();
        }
    }

    protected boolean isValidFocusControl() {
        return this.cut.isValidFocusControl();
    }

    public void enableActions() {
        this.cut.setEnabled(true);
        this.copy.setEnabled(true);
        this.paste.setEnabled(true);
    }

    public void partActivated(IWorkbenchPart part) {
        if (this.isRegisteredPart(part)) {
            this.connectCutCopyPasteActions(part);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void menuHidden(MenuEvent e) {
        IWorkbenchPart part = this.getWorkbenchPart();
        if (part != null && this.isRegisteredPart(part)) {
            this.enableActions();
            IActionBars actionbars = this.getActionBars(part);
            actionbars.updateActionBars();
        }
    }

    public void menuShown(MenuEvent e) {
        this.updateActions();
    }

    public void disableActions() {
        this.cut.setEnabled(false);
        this.copy.setEnabled(false);
        this.paste.setEnabled(false);
        this.revert.setEnabled(false);
    }
}

