/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.navigator.action;

import java.util.ArrayList;
import org.eclipse.hyades.ui.internal.action.CommonNavigatorFilterSetAction;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.hyades.ui.internal.extension.NavigatorFilterSet;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.action.FiltersAction;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;

public abstract class NavigatorActionGroup
extends ActionGroup
implements IDisposable {
    public static final String GROUP_FILTERS = "group.filters";
    private Separator fAdditionsGroup;
    private Separator fNewGroup;
    private Separator fOpenGroup;
    private Separator fDeleteGroup;
    private Separator fSaveGroup;
    private Separator fImportGroup;
    private Separator fRefreshGroup;
    private Separator fWorkbenchAdditionsGroup;
    private Separator fPropertiesGroup;
    private Separator fFiltersGroup;
    private IAction fFiltersAction;
    private IAction[] fCommonFilters;
    private INavigator navigator;

    public NavigatorActionGroup(INavigator navigator) {
        this.navigator = navigator;
        this.createActions();
        this.createActionGroups();
    }

    public void dispose() {
        this.navigator = null;
        this.disposeActionGroups();
        super.dispose();
    }

    public INavigator getNavigator() {
        return this.navigator;
    }

    public void handleKeyPressed(KeyEvent event) {
    }

    protected void createActions() {
        this.fFiltersAction = new FiltersAction(this.navigator);
        ArrayList<CommonNavigatorFilterSetAction> common = new ArrayList<CommonNavigatorFilterSetAction>();
        NavigatorFilterSet[] filters = NavigatorExtensionUtil.getFilterSetElements(this.navigator.getID());
        for (int i = 0; i < filters.length; ++i) {
            if (!filters[i].isCommon()) continue;
            common.add(new CommonNavigatorFilterSetAction(filters[i], this.navigator));
        }
        this.fCommonFilters = new IAction[common.size()];
        common.toArray(this.fCommonFilters);
    }

    protected void createActionGroups() {
        this.fAdditionsGroup = new Separator("group.additions");
        this.fNewGroup = new Separator("group.new");
        this.fOpenGroup = new Separator("org.eclipse.ui.OpenWithSubMenu");
        this.fDeleteGroup = new Separator("group.delete");
        this.fSaveGroup = new Separator("group.save");
        this.fImportGroup = new Separator("group.import");
        this.fRefreshGroup = new Separator("group.refresh");
        this.fWorkbenchAdditionsGroup = new Separator("additions");
        this.fPropertiesGroup = new Separator("group.properties");
        this.fFiltersGroup = new Separator(GROUP_FILTERS);
    }

    protected void disposeActionGroups() {
        if (this.fAdditionsGroup != null) {
            this.fAdditionsGroup.dispose();
            this.fAdditionsGroup = null;
        }
        if (this.fNewGroup != null) {
            this.fNewGroup.dispose();
            this.fNewGroup = null;
        }
        if (this.fOpenGroup != null) {
            this.fOpenGroup.dispose();
            this.fOpenGroup = null;
        }
        if (this.fDeleteGroup != null) {
            this.fDeleteGroup.dispose();
            this.fDeleteGroup = null;
        }
        if (this.fSaveGroup != null) {
            this.fSaveGroup.dispose();
            this.fSaveGroup = null;
        }
        if (this.fImportGroup != null) {
            this.fImportGroup.dispose();
            this.fImportGroup = null;
        }
        if (this.fRefreshGroup != null) {
            this.fRefreshGroup.dispose();
            this.fRefreshGroup = null;
        }
        if (this.fWorkbenchAdditionsGroup != null) {
            this.fWorkbenchAdditionsGroup.dispose();
            this.fWorkbenchAdditionsGroup = null;
        }
        if (this.fPropertiesGroup != null) {
            this.fPropertiesGroup.dispose();
            this.fPropertiesGroup = null;
        }
    }

    public void runDefaultAction(IStructuredSelection selection) {
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        menu.add((IContributionItem)this.fAdditionsGroup);
        menu.add((IContributionItem)this.fNewGroup);
        menu.add((IContributionItem)this.fOpenGroup);
        menu.add((IContributionItem)this.fDeleteGroup);
        menu.add((IContributionItem)this.fSaveGroup);
        menu.add((IContributionItem)this.fImportGroup);
        menu.add((IContributionItem)this.fRefreshGroup);
        menu.add((IContributionItem)this.fWorkbenchAdditionsGroup);
        menu.add((IContributionItem)this.fPropertiesGroup);
        NavigatorExtensionUtil.fillContextMenu(menu, this.navigator.getStructuredSelection(), this.navigator.getID());
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        if (this.fCommonFilters != null && this.fFiltersAction != null && NavigatorExtensionUtil.getFilterSetElements(this.navigator.getID()).length > 0) {
            IMenuManager menu = actionBars.getMenuManager();
            menu.add((IContributionItem)this.fFiltersGroup);
            for (int i = 0; i < this.fCommonFilters.length; ++i) {
                menu.appendToGroup(GROUP_FILTERS, this.fCommonFilters[i]);
            }
            menu.appendToGroup(GROUP_FILTERS, this.fFiltersAction);
        }
    }
}

