/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.report;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.report.ReportDescription;
import org.eclipse.hyades.ui.internal.util.XMLUtil;
import org.eclipse.hyades.ui.report.IReportDescription;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ReportManager
implements IDisposable {
    private static String prefKey = "reportDescriptions";
    private List pluginReportDescription;
    private List preferenceReportDescription = new ArrayList();
    private AbstractUIPlugin plugin;
    private String extensionPoint;

    public ReportManager(AbstractUIPlugin plugin, String extensionPoint) {
        this.plugin = plugin;
        this.extensionPoint = extensionPoint;
    }

    public void dispose() {
        if (this.pluginReportDescription != null) {
            this.pluginReportDescription.clear();
        }
        this.preferenceReportDescription.clear();
        this.plugin = null;
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.plugin.getPreferenceStore();
    }

    public void addReportDefinition(IReportDescription reportDescription) {
        this.preferenceReportDescription.add(reportDescription);
    }

    public void removeReportDefinition(IReportDescription reportDescription) {
        this.preferenceReportDescription.remove(reportDescription);
    }

    public IReportDescription[] getPreferenceStoreReportDescriptions() {
        return this.preferenceReportDescription.toArray(new ReportDescription[this.preferenceReportDescription.size()]);
    }

    public IReportDescription[] getReportDescriptions() {
        ArrayList ret = null;
        if (this.pluginReportDescription != null) {
            ret = new ArrayList(this.pluginReportDescription);
            ret.addAll(this.preferenceReportDescription);
        } else {
            ret = this.preferenceReportDescription;
        }
        return ret.toArray(new ReportDescription[ret.size()]);
    }

    public void loadFromPluginRegistry() {
        if (this.pluginReportDescription != null) {
            return;
        }
        this.pluginReportDescription = new ArrayList();
        if (this.plugin != null) {
            IConfigurationElement[] configurationElements = Platform.getPluginRegistry().getConfigurationElementsFor(HyadesUIPlugin.getID(), this.extensionPoint);
            int maxi = configurationElements.length;
            for (int i = 0; i < maxi; ++i) {
                if (!"reportDescription".equals(configurationElements[i].getName())) continue;
                String name = configurationElements[i].getAttribute("name");
                String className = configurationElements[i].getAttribute("class");
                this.pluginReportDescription.add(new ReportDescription(name, className, "", configurationElements[i]));
            }
        }
    }

    public void loadFromPreferenceStore() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        String value = preferenceStore.getString(prefKey);
        if (value == null || value.length() == 0) {
            return;
        }
        XMLUtil.setLogger(HyadesUIPlugin.getLogger());
        Element registryElement = XMLUtil.loadDom(value, "reportDescriptions");
        if (registryElement == null) {
            return;
        }
        NodeList nodeList = XMLUtil.getChildrenByName(registryElement, "reportDescription");
        int maxi = nodeList.getLength();
        for (int i = 0; i < maxi; ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            this.loadDescription((Element)nodeList.item(i));
        }
    }

    protected void loadDescription(Element descriptionElement) {
        String name = XMLUtil.getValue(descriptionElement, "name");
        String clas = XMLUtil.getValue(descriptionElement, "class");
        if (name == null || clas == null) {
            return;
        }
        String classpath = XMLUtil.getValue(descriptionElement, "classpath");
        classpath = XMLUtil.removeXMLSymbols(classpath);
        ReportDescription report = new ReportDescription(this.plugin.getClass().getClassLoader(), name, clas, classpath);
        this.preferenceReportDescription.add(report);
    }

    public void saveIntoPreferenceStore() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml");
        xml.append(XMLUtil.createXMLAttribute("version", "1.0", false)).append(XMLUtil.createXMLAttribute("encoding", "UTF-8", false));
        xml.append("?>");
        xml.append("<reportDescriptions>");
        Iterator i = this.preferenceReportDescription.iterator();
        while (i.hasNext()) {
            IReportDescription reportGeneratorDefinition = (IReportDescription)i.next();
            this.storeDescription(xml, reportGeneratorDefinition);
        }
        xml.append("</reportDescriptions>");
        String xmlString = xml.toString();
        if (xmlString.equals(preferenceStore.getString(prefKey))) {
            return;
        }
        preferenceStore.setValue(prefKey, xmlString);
    }

    protected void storeDescription(StringBuffer xml, IReportDescription reportDefinition) {
        StringBuffer tempXML = new StringBuffer();
        tempXML.append("<reportDescription");
        tempXML.append(XMLUtil.createXMLAttribute("name", reportDefinition.getName(), false));
        tempXML.append(XMLUtil.createXMLAttribute("class", reportDefinition.getClassName(), false));
        tempXML.append(XMLUtil.createXMLAttribute("classpath", reportDefinition.getClassPath(), false));
        tempXML.append("/>");
        xml.append(tempXML);
    }
}

