/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.AbstractListenerActionDelegate;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class StopTraceActionDelegate
extends AbstractListenerActionDelegate {
    public void doAction(Object object) throws Exception {
        if (object == null || !(object instanceof TRCAgentProxy)) {
            return;
        }
        INavigator fViewer = (INavigator)this.getView();
        if (fViewer == null) {
            MessageDialog.openInformation((Shell)UIPlugin.getActiveWorkbenchShell(), (String)"title", (String)"Action not available in current context");
            return;
        }
        this.run((TRCAgentProxy)object, fViewer);
    }

    public void run(TRCAgentProxy agent, INavigator fViewer) {
        TRCProcessProxy process = agent.getProcessProxy();
        String host = process.getNode().getName();
        try {
            Agent a;
            Node node = PDCoreUtil.profileConnect(host, String.valueOf(process.getNode().getPort()));
            if (node == null) {
                return;
            }
            Object instance = LoadersUtils.locateAgentInstance((TRCAgentProxy)agent);
            if (instance != null && instance instanceof Agent && (a = (Agent)instance).isMonitored()) {
                a.stopMonitoring();
                agent.setMonitored(false);
                agent.setAttached(true);
                agent.setActive(true);
                ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                event.setSource(agent);
                event.setType(2);
                UIPlugin.getDefault().notifyProfileEventListener(event);
            }
            fViewer.getViewer().refresh((Object)agent);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    protected boolean isEnabledFor(Object element) {
        if (element != null && element instanceof TRCAgentProxy && ((TRCAgentProxy)element).isMonitored()) {
            this.getAction().setEnabled(true);
            return true;
        }
        this.getAction().setEnabled(false);
        return false;
    }

    public void dispose() {
        super.dispose();
    }
}

