/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.common.Options;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileOptionsUI;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenProfAgentWizard;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class OpenProfOptionsPage
extends WizardPage {
    protected PDProjectExplorer fViewer;
    protected TraceProfileOptionsUI _optionsUI;

    public OpenProfOptionsPage(String name, PDProjectExplorer viewer) {
        super(name);
        this.setTitle(UIPlugin.getResourceString("PROF_FILTER_TITLE"));
        this.setDescription(UIPlugin.getResourceString("PROF_FILTER_DESC"));
        this.fViewer = viewer;
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        content.setLayout((Layout)layout);
        GridData gd = GridUtil.createFill();
        content.setLayoutData((Object)gd);
        this._optionsUI = new TraceProfileOptionsUI();
        this._optionsUI.createControl(content);
        this._optionsUI.setWizardPage(this);
        TRCAgentProxy agent = ((OpenProfAgentWizard)this.getWizard()).getAgent();
        this.setControl((Control)content);
        this.populateData();
        this._optionsUI.enable(false);
        if (agent == null || !agent.isActive()) {
            this.setPageComplete(false);
            this._optionsUI.enable(false);
        }
        WorkbenchHelp.setHelp((Control)parent, (String)(UIPlugin.getPluginId() + ".opop0000"));
    }

    public boolean finish(boolean shouldSend) {
        TRCAgentProxy agent = ((OpenProfAgentWizard)this.getWizard()).getAgent();
        if (agent == null || !agent.isActive()) {
            return true;
        }
        try {
            Object[] configs = agent.getConfigurations().toArray();
            if (configs.length > 0) {
                this.setConfiguration((TRCConfiguration)configs[0]);
            } else {
                HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();
                TRCConfiguration config = factory.createTRCConfiguration();
                config.setAgentProxy(agent);
                agent.getConfigurations().add((Object)config);
                this.setConfiguration(config);
            }
            if (shouldSend && agent.isActive() && agent.isMonitored()) {
                TRCProcessProxy process = agent.getProcessProxy();
                TRCNode node = process.getNode();
                this.sendConfigurationToAgent(agent, node.getName(), process.getPid());
            }
        }
        catch (ConcurrentModificationException exc) {
            exc.printStackTrace();
        }
        return true;
    }

    public boolean finish() {
        return this.finish(true);
    }

    private void sendConfigurationToAgent(TRCAgentProxy agent, String host, int processId) {
        Node node = PDCoreUtil.profileConnect(host, String.valueOf(agent.getProcessProxy().getNode().getPort()));
        if (node == null) {
            return;
        }
        Process p = node.getProcess(String.valueOf(processId));
        if (p != null) {
            try {
                Agent a = p.getAgent(agent.getName());
                PDCoreUtil.setAgentConfiguration(agent, a);
                if (a != null && a.isActive()) {
                    a.publishConfiguration();
                    CustomCommand command = new CustomCommand();
                    command.setData("APPLYFILTERS");
                    a.invokeCustomCommand(command);
                }
            }
            catch (InactiveAgentException aex) {
                // empty catch block
            }
        }
    }

    protected void populateData() {
        TRCAgentProxy agent = ((OpenProfAgentWizard)this.getWizard()).getAgent();
        if (agent == null) {
            return;
        }
        int collectionModeValue = agent.getCollectionMode().getValue();
        this._optionsUI.setHeapDetails(collectionModeValue == 1 || collectionModeValue == 7 || collectionModeValue == 2);
        this._optionsUI.setExecutionStatistic(collectionModeValue == 3 || collectionModeValue == 7 || collectionModeValue == 0);
        this._optionsUI.setExecutionFlow(!this._optionsUI.getExecutionStatistic());
        EList options = null;
        EList configs = agent.getConfigurations();
        Iterator i = configs.iterator();
        if (i.hasNext()) {
            TRCConfiguration config = (TRCConfiguration)i.next();
            options = config.getOptions();
            this.updateConfigData(options);
            return;
        }
        this.updateConfigData(options);
    }

    protected void setConfiguration(TRCConfiguration config) {
        block19: {
            boolean collectStatistics = false;
            try {
                TRCOption opt;
                int idx;
                String[][] execution;
                Object[] options = config.getOptions().toArray();
                for (int idx2 = 0; idx2 < options.length; ++idx2) {
                    ((TRCOption)options[idx2]).setConfiguration(null);
                }
                HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();
                if (!this._optionsUI.getExecution()) {
                    collectStatistics = true;
                }
                if (!this._optionsUI.getHeap()) {
                    execution = Options.OPTIONS_ANALYZE_HEAP_NONE;
                    for (idx = 0; idx < execution.length; ++idx) {
                        opt = factory.createTRCOption();
                        opt.setKey(execution[idx][0]);
                        opt.setValue(execution[idx][1]);
                        opt.setConfiguration(config);
                    }
                } else {
                    execution = Options.OPTIONS_ANALYZE_HEAP;
                    for (idx = 0; idx < execution.length; ++idx) {
                        opt = factory.createTRCOption();
                        opt.setKey(execution[idx][0]);
                        opt.setValue(execution[idx][1]);
                        opt.setConfiguration(config);
                    }
                }
                if (this._optionsUI.getHeap() && !this._optionsUI.getExecution()) {
                    execution = Options.OPTIONS_EXECUTION_FLOW_NONE;
                    for (idx = 0; idx < execution.length; ++idx) {
                        opt = factory.createTRCOption();
                        opt.setKey(execution[idx][0]);
                        opt.setValue(execution[idx][1]);
                        opt.setConfiguration(config);
                    }
                    break block19;
                }
                if (this._optionsUI.getExecutionBoundary()) {
                    String[][] executionBoundary = Options.OPTIONS_EXECUTION_FLOW_BOUNDARY;
                    for (idx = 0; idx < executionBoundary.length; ++idx) {
                        opt = factory.createTRCOption();
                        opt.setKey(executionBoundary[idx][0]);
                        opt.setValue(executionBoundary[idx][1]);
                        opt.setConfiguration(config);
                    }
                    TRCOption opt2 = factory.createTRCOption();
                    opt2.setKey("BOUNDARY_DEPTH");
                    opt2.setValue(String.valueOf(this._optionsUI.getCollectionDepth()));
                    opt2.setConfiguration(config);
                } else if (this._optionsUI.getExecution()) {
                    execution = Options.OPTIONS_EXECUTION_FLOW;
                    for (idx = 0; idx < execution.length; ++idx) {
                        opt = factory.createTRCOption();
                        opt.setKey(execution[idx][0]);
                        opt.setValue(execution[idx][1]);
                        opt.setConfiguration(config);
                    }
                } else {
                    execution = Options.OPTIONS_EXECUTION_FLOW_NONE;
                    for (idx = 0; idx < execution.length; ++idx) {
                        opt = factory.createTRCOption();
                        opt.setKey(execution[idx][0]);
                        opt.setValue(execution[idx][1]);
                        opt.setConfiguration(config);
                    }
                }
                if (this._optionsUI.getExecution() && !this._optionsUI.getHeap()) {
                    String[][] heapInfo = Options.OPTIONS_NO_INSTANCE_INFORMATION;
                    for (int idx3 = 0; idx3 < heapInfo.length; ++idx3) {
                        opt = factory.createTRCOption();
                        opt.setKey(heapInfo[idx3][0]);
                        opt.setValue(heapInfo[idx3][1]);
                        opt.setConfiguration(config);
                    }
                }
            }
            catch (ConcurrentModificationException exc) {
                exc.printStackTrace();
            }
        }
    }

    protected void updateConfigData(EList options) {
        this._optionsUI.setExecutionBoundary(false);
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        this._optionsUI.setCollectionDepth(store.getString("collect_depth"));
        if (options != null) {
            Iterator i = options.iterator();
            while (i.hasNext()) {
                TRCOption option = (TRCOption)i.next();
                if (option.getKey().equals("STACK_INFORMATION")) {
                    this._optionsUI.setExecution(true);
                    if (option.getValue().equals("boundaryAndContiguous")) {
                        this._optionsUI.setExecutionBoundary(true);
                        continue;
                    }
                    if (!option.getValue().equals("none")) continue;
                    this._optionsUI.setExecution(false);
                    continue;
                }
                if (option.getKey().equals("TRACE_MODE")) {
                    if (option.getValue().equals("noObjectCorrelation")) {
                        this._optionsUI.setHeap(false);
                    }
                    if (!option.getValue().equals("default")) continue;
                    this._optionsUI.setHeap(true);
                    continue;
                }
                if (!option.getKey().equals("BOUNDARY_DEPTH")) continue;
                this._optionsUI.setCollectionDepth(option.getValue());
                this._optionsUI.setExecutionBoundary(true);
                this._optionsUI.setExecution(true);
            }
        }
        this._optionsUI.enableBtnGroup();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (!((OpenProfAgentWizard)this.getWizard()).isProfilingAgent()) {
                this.getControl().setEnabled(false);
                this.getControl().setVisible(false);
                this.setDescription(UIPlugin.getResourceString("STR_OPTION_IGNORED"));
            } else {
                this.getControl().setEnabled(true);
                this.getControl().setVisible(true);
                this.setDescription(UIPlugin.getResourceString("PROF_FILTER_DESC"));
            }
        }
    }
}

