/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.LogUIPluginImages;
import org.eclipse.hyades.log.ui.internal.actions.provider.ILogFilterProvider;
import org.eclipse.hyades.log.ui.internal.actions.provider.ILogFindProvider;
import org.eclipse.hyades.log.ui.internal.util.ColumnsDialog;
import org.eclipse.hyades.log.ui.internal.util.FeatureNode;
import org.eclipse.hyades.log.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.log.ui.internal.util.FiltersDialog;
import org.eclipse.hyades.log.ui.internal.util.LogFindCriteria;
import org.eclipse.hyades.log.ui.internal.util.LogRecordSearch;
import org.eclipse.hyades.log.ui.internal.util.LogUtil;
import org.eclipse.hyades.log.ui.internal.util.RecordChangeEvent;
import org.eclipse.hyades.log.ui.internal.util.SearchRecordDialog;
import org.eclipse.hyades.log.ui.internal.util.SortDialog;
import org.eclipse.hyades.log.ui.internal.util.TerminalNode;
import org.eclipse.hyades.log.ui.internal.util.TreeNode;
import org.eclipse.hyades.log.ui.internal.views.LogContentProvider;
import org.eclipse.hyades.log.ui.internal.views.LogPage;
import org.eclipse.hyades.log.ui.internal.views.LogViewerUI;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.util.LogQueryBuilder;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.util.ILogFilterCriteria;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPage;

public class LogViewer
extends TraceViewer
implements ILogFindProvider,
ILogFilterProvider {
    protected final String _title = LogUIPlugin.getResourceString("STR_WAS_VIEW_TITLE");
    private LogPage logPage;
    private Action pageDown;
    private Action pageUp;
    private Action goToPage;
    private LogRecordSearch logRecordSearch = null;
    private Object lastMatch = null;
    private List cbeList;
    private SearchRecordDialog searchDialog = null;
    public boolean handleRefreshEvent = false;

    public TraceViewerPage createPage(EObject mofObject) {
        this.logPage = new LogPage(mofObject, this);
        return this.logPage;
    }

    public void handleProfileEvent(ProfileEvent event) {
        if ((event.getType() == 64 || event.getType() == 32 || event.getType() == 2048) && event.getSource() instanceof EObject) {
            if (!this.fPartVisible) {
                this.fRefreshView = true;
                return;
            }
            this.handleRefreshEvent = true;
            this.refreshPage(this.getObjectToView((EObject)event.getSource()));
            this.handleRefreshEvent = false;
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void makeActions() {
        if (this.isInitializedMenu()) {
            return;
        }
        this.initializedMenu(true);
        String STR_SORT = LogUIPlugin.getResourceBundle().getString("STR_SORT");
        Action sort = new Action(STR_SORT){

            public void run() {
                IPage page;
                SortDialog dialog = new SortDialog(LogViewer.this.getViewSite().getShell(), LogUIPlugin.getResourceString("STR_ST_SORT_COL_SETTINGS"), null);
                dialog.open();
                if (dialog.getReturnCode() == 0 && (page = LogViewer.this.getCurrentPage()) != null && page instanceof LogPage) {
                    BusyIndicator.showWhile(null, (Runnable)new Runnable(this, page){
                        private final /* synthetic */ IPage val$page;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$page = val$page;
                        }

                        public void run() {
                            ((LogPage)this.val$page).getView().update();
                        }
                    });
                }
            }
        };
        sort.setText(STR_SORT);
        LogUIPluginImages.setImageDescriptors((IAction)sort, "lcl16", "sortrecords_co.gif");
        sort.setDescription(STR_SORT);
        sort.setToolTipText(STR_SORT);
        String STR_FILTER = LogUIPlugin.getResourceBundle().getString("STR_FILTER");
        Action filter = new Action(STR_FILTER){

            public void run() {
                ColumnsDialog dialog = new ColumnsDialog(LogViewer.this.getViewSite().getShell(), LogUIPlugin.getResourceString("STR_ST_COL_SETTINGS"), null);
                dialog.open();
            }
        };
        filter.setText(STR_FILTER);
        LogUIPluginImages.setImageDescriptors((IAction)filter, "lcl16", "filter_ps.gif");
        filter.setDescription(STR_FILTER);
        filter.setToolTipText(STR_FILTER);
        String STR_ADV_FILTER = LogUIPlugin.getResourceBundle().getString("STR_ADV_FILTER");
        Action advfilter = new Action(STR_ADV_FILTER){

            public void run() {
                LogViewer.this.filter();
            }
        };
        advfilter.setText(STR_ADV_FILTER);
        LogUIPluginImages.setImageDescriptors((IAction)advfilter, "lcl16", "adv_filter_co.gif");
        advfilter.setDescription(STR_ADV_FILTER);
        advfilter.setToolTipText(STR_ADV_FILTER);
        Action searchRecord = this.createSearchButton();
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)searchRecord);
        this.createPageUpButton();
        this.createPageDownButton();
        this.createGoToPageButton();
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.add((IAction)sort);
        tbm.add((IAction)filter);
        tbm.add((IAction)advfilter);
        tbm.add((IAction)searchRecord);
        tbm.add((IAction)this.pageUp);
        tbm.add((IAction)this.pageDown);
        tbm.add((IAction)this.goToPage);
        this.getViewSite().getActionBars().updateActionBars();
    }

    private Action createSearchButton() {
        String STR_FIND_RECORD = LogUIPlugin.getResourceBundle().getString("STR_FIND_RECORD");
        Action searchRecord = new Action(STR_FIND_RECORD){

            public void run() {
                LogViewer.this.find();
            }
        };
        searchRecord.setText(STR_FIND_RECORD);
        LogUIPluginImages.setImageDescriptors((IAction)searchRecord, "lcl16", "searchrecord.gif");
        searchRecord.setDescription(STR_FIND_RECORD);
        searchRecord.setToolTipText(STR_FIND_RECORD);
        return searchRecord;
    }

    private Action createPageUpButton() {
        String STR_PAGE_UP = LogUIPlugin.getResourceBundle().getString("STR_PAGE_UP");
        this.pageUp = new Action(STR_PAGE_UP){

            public void run() {
                IPage page = LogViewer.this.getCurrentPage();
                if (page != null && page instanceof LogPage) {
                    BusyIndicator.showWhile(null, (Runnable)new Runnable(this, page){
                        private final /* synthetic */ IPage val$page;
                        private final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$page = val$page;
                        }

                        public void run() {
                            LogContentProvider logContentProvider = (LogContentProvider)((LogPage)this.val$page).getView().getViewer().getContentProvider();
                            LogViewer.access$100(6.access$000(this.this$1)).setEnabled(logContentProvider.pageUp());
                            ((LogPage)this.val$page).getView().update();
                        }
                    });
                }
            }

            static /* synthetic */ LogViewer access$000(6 x0) {
                return x0.LogViewer.this;
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this.pageUp);
        this.pageUp.setText(STR_PAGE_UP);
        LogUIPluginImages.setImageDescriptors((IAction)this.pageUp, "lcl16", "pageup.gif");
        this.pageUp.setDescription(STR_PAGE_UP);
        this.pageUp.setToolTipText(STR_PAGE_UP);
        return this.pageUp;
    }

    private Action createGoToPageButton() {
        String STR_GO_TO_PAGE = LogUIPlugin.getResourceString("STR_GO_TO_PAGE");
        this.goToPage = new Action(STR_GO_TO_PAGE){

            public void run() {
                IPage page = LogViewer.this.getCurrentPage();
                LogContentProvider logContentProvider = (LogContentProvider)((LogPage)page).getView().getViewer().getContentProvider();
                int totalPages = logContentProvider.getTotalPages();
                if (totalPages < 2) {
                    LogViewer.this.goToPage.setEnabled(false);
                    return;
                }
                String[] variables = new String[]{"1", "" + totalPages};
                String dialogTitle = LogUIPlugin.getResourceString("GO_TO_PAGE_DIALOG_TITLE");
                String dialogMessage = LogUIPlugin.getResourceString("GO_TO_PAGE_DIALOG_MESSAGE", variables);
                InputDialog inputDialog = new InputDialog(LogViewer.this.getSite().getShell(), dialogTitle, dialogMessage, null, new IInputValidator(this, totalPages){
                    private final /* synthetic */ int val$totalPages;
                    private final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$totalPages = val$totalPages;
                    }

                    public String isValid(String newText) {
                        if (newText == null || newText.length() == 0) {
                            return "";
                        }
                        try {
                            int pageNr = Integer.parseInt(newText);
                            if (pageNr < 1 || pageNr > this.val$totalPages) {
                                return LogUIPlugin.getResourceString("GO_TO_PAGE_VNIR");
                            }
                        }
                        catch (Exception e) {
                            return LogUIPlugin.getResourceString("GO_TO_PAGE_VNAN");
                        }
                        return null;
                    }
                });
                inputDialog.open();
                if (inputDialog.getReturnCode() != 0) {
                    return;
                }
                int pageNr = Integer.parseInt(inputDialog.getValue());
                if (page != null && page instanceof LogPage) {
                    BusyIndicator.showWhile(null, (Runnable)new Runnable(this, logContentProvider, pageNr, page){
                        private final /* synthetic */ LogContentProvider val$logContentProvider;
                        private final /* synthetic */ int val$pageNr;
                        private final /* synthetic */ IPage val$page;
                        private final /* synthetic */ 8 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$logContentProvider = val$logContentProvider;
                            this.val$pageNr = val$pageNr;
                            this.val$page = val$page;
                        }

                        public void run() {
                            boolean res = this.val$logContentProvider.goToPage(this.val$pageNr);
                            if (this.val$pageNr == 1) {
                                LogViewer.access$100(8.access$300(this.this$1)).setEnabled(false);
                            }
                            LogViewer.access$200(8.access$300(this.this$1)).setEnabled(res);
                            ((LogPage)this.val$page).getView().update();
                        }
                    });
                }
            }

            static /* synthetic */ LogViewer access$300(8 x0) {
                return x0.LogViewer.this;
            }
        };
        this.goToPage.setText(STR_GO_TO_PAGE);
        this.getViewSite().getActionBars().setGlobalActionHandler("navigate/goToPage", (IAction)this.goToPage);
        LogUIPluginImages.setImageDescriptors((IAction)this.goToPage, "lcl16", "gotopage.gif");
        this.goToPage.setDescription(STR_GO_TO_PAGE);
        this.goToPage.setToolTipText(STR_GO_TO_PAGE);
        return this.goToPage;
    }

    private Action createPageDownButton() {
        String STR_PAGE_DOWN = LogUIPlugin.getResourceBundle().getString("STR_PAGE_DOWN");
        this.pageDown = new Action(STR_PAGE_DOWN){

            public void run() {
                IPage page = LogViewer.this.getCurrentPage();
                if (page != null && page instanceof LogPage) {
                    BusyIndicator.showWhile(null, (Runnable)new Runnable(this, page){
                        private final /* synthetic */ IPage val$page;
                        private final /* synthetic */ 11 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$page = val$page;
                        }

                        public void run() {
                            LogContentProvider logContentProvider = (LogContentProvider)((LogPage)this.val$page).getView().getViewer().getContentProvider();
                            LogViewer.access$500(11.access$400(this.this$1)).setEnabled(logContentProvider.pageDown());
                            ((LogPage)this.val$page).getView().update();
                        }
                    });
                }
            }

            static /* synthetic */ LogViewer access$400(11 x0) {
                return x0.LogViewer.this;
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this.pageDown);
        this.pageDown.setText(STR_PAGE_DOWN);
        LogUIPluginImages.setImageDescriptors((IAction)this.pageDown, "lcl16", "pagedown.gif");
        this.pageDown.setDescription(STR_PAGE_DOWN);
        this.pageDown.setToolTipText(STR_PAGE_DOWN);
        return this.pageDown;
    }

    public void setFocus() {
        if (this.getCurrentPage() != null) {
            this.getCurrentPage().setFocus();
        }
    }

    public boolean isValidObject(Object mofObject) {
        if (mofObject == null) {
            return false;
        }
        if (mofObject instanceof TRCAgent && ((TRCAgent)mofObject).getType().equals("Logging")) {
            return true;
        }
        if (mofObject instanceof TRCProcessProxy) {
            return this.hasProcessLogAgents((TRCProcessProxy)mofObject);
        }
        if (mofObject instanceof TRCNode) {
            return this.hasNodeLogAgents((TRCNode)mofObject);
        }
        if (mofObject instanceof TRCMonitor) {
            return this.hasMonitorLogAgents((TRCMonitor)mofObject);
        }
        return true;
    }

    public EObject getObjectToView(EObject selObject) {
        if (selObject == null) {
            return selObject;
        }
        List list = null;
        if (selObject instanceof TRCMonitor) {
            return selObject;
        }
        if (selObject instanceof TRCNode) {
            return selObject;
        }
        if (selObject instanceof TRCProcessProxy) {
            list = this.getLogAgentInProcess((EObject)((TRCProcessProxy)selObject));
        }
        if (list != null && list.size() == 1) {
            return (EObject)list.get(0);
        }
        return selObject;
    }

    private List getLogObjectInMonitor(EObject selObject) {
        List list;
        EList nodes = ((TRCMonitor)selObject).getNodes();
        TRCNode node = null;
        int size = nodes.size();
        int nrOfNodes = 0;
        ArrayList<Object> object_list = new ArrayList<Object>();
        for (int i = 0; i < size && nrOfNodes < 2; ++i) {
            node = (TRCNode)nodes.get(i);
            if (node == null || (list = this.getLogObjectInNode((EObject)node)).size() < 1) continue;
            ++nrOfNodes;
            object_list.add(node);
        }
        if (object_list.size() == 1 && (list = this.getLogObjectInNode((EObject)((TRCNode)object_list.get(0)))).size() == 1) {
            object_list.clear();
            object_list.add(list.get(0));
        }
        return object_list;
    }

    private List getLogObjectInNode(EObject selObject) {
        List list;
        EList processes = ((TRCNode)selObject).getProcessProxies();
        TRCProcessProxy process = null;
        int nrOfProcesses = 0;
        int size = processes.size();
        ArrayList<Object> object_list = new ArrayList<Object>();
        for (int i = 0; i < size && nrOfProcesses < 2; ++i) {
            process = (TRCProcessProxy)processes.get(i);
            if (process == null || (list = this.getLogAgentInProcess((EObject)process)).size() < 1) continue;
            ++nrOfProcesses;
            object_list.add(process);
        }
        if (object_list.size() == 1 && (list = this.getLogAgentInProcess((EObject)((TRCProcessProxy)object_list.get(0)))).size() == 1) {
            object_list.clear();
            object_list.add(list.get(0));
        }
        return object_list;
    }

    private List getLogAgentInProcess(EObject selObject) {
        int nrOfAgents = 0;
        EList agents = ((TRCProcessProxy)selObject).getAgentProxies();
        int size = agents.size();
        TRCAgentProxy a = null;
        ArrayList<TRCAgentProxy> list = new ArrayList<TRCAgentProxy>();
        for (int idx = 0; idx < size && nrOfAgents < 2; ++idx) {
            a = (TRCAgentProxy)agents.get(idx);
            if (a == null || a.eIsProxy() || !a.getType().equals("Logging")) continue;
            ++nrOfAgents;
            list.add(a);
        }
        return list;
    }

    private boolean hasMonitorLogAgents(TRCMonitor monitor) {
        EList nodes = monitor.getNodes();
        TRCNode node = null;
        int size = nodes.size();
        boolean ret = false;
        for (int i = 0; i < size && !ret; ++i) {
            node = (TRCNode)nodes.get(i);
            if (node == null) continue;
            ret = this.hasNodeLogAgents(node);
        }
        return ret;
    }

    private boolean hasNodeLogAgents(TRCNode node) {
        EList processes = node.getProcessProxies();
        TRCProcessProxy process = null;
        boolean ret = false;
        int size = processes.size();
        for (int i = 0; i < size && !ret; ++i) {
            process = (TRCProcessProxy)processes.get(i);
            if (process == null) continue;
            ret = this.hasProcessLogAgents(process);
        }
        return ret;
    }

    private boolean hasProcessLogAgents(TRCProcessProxy process) {
        EList agents = process.getAgentProxies();
        int size = agents.size();
        TRCAgentProxy agent = null;
        for (int idx = 0; idx < size; ++idx) {
            agent = (TRCAgentProxy)agents.get(idx);
            if (agent == null || agent.eIsProxy() || !agent.getType().equals("Logging")) continue;
            return true;
        }
        return false;
    }

    public String getViewTitle() {
        return this._title;
    }

    public void setRecordSelection(EObject record, EObject treeSel) {
        if (this.getPage(treeSel) == null) {
            return;
        }
        LogViewerUI ui = ((LogPage)this.getPage(treeSel)).getView();
        if (ui != null && ui.getViewer() != null) {
            LogContentProvider logContentProvider = (LogContentProvider)ui.getViewer().getContentProvider();
            if (logContentProvider.revealObject(record)) {
                ui.update();
            }
            ui.getViewer().setSelection((ISelection)new StructuredSelection((Object)record), true);
        }
    }

    protected void setViewTitle(Object selection) {
        if (selection != null && selection instanceof TRCAgentProxy) {
            TRCAgentProxy a = (TRCAgentProxy)selection;
            String status = HyadesUtil.getAgentLabel((TRCAgentProxy)a);
            if (a.getProcessProxy() != null) {
                this.setTitle(this._title + " - " + a.getName());
            }
            return;
        }
        this.setTitle(this.getViewTitle());
    }

    public Action getPageDownAction() {
        return this.pageDown;
    }

    public Action getPageUpAction() {
        return this.pageUp;
    }

    public Action getGotPageAction() {
        return this.goToPage;
    }

    public void find() {
        this.searchDialog = new SearchRecordDialog(this.getViewSite().getShell(), LogUIPlugin.getResourceString("STR_ST_FIND_SETTINGS"), null, this);
        this.initializeRecordSearchEngine();
        this.searchDialog.open();
    }

    public void filter() {
        FiltersDialog dialog = new FiltersDialog(this.getViewSite().getShell(), LogUIPlugin.getResourceString("STR_ST_FILTER_SETTINGS"), null, this, false);
        dialog.open();
    }

    public boolean findRecord(LogFindCriteria criteria) {
        Object sel = null;
        LogRecordSearch searchUtil = this.getRecordSearchEngine();
        if (searchUtil.getType() == 0) {
            searchUtil.initStartNode(this.getStartNode(), 0);
            sel = this.getRecordSearchEngine().search(criteria.getFilters(), criteria.isForwardDirection() ? 1 : -1, this.lastMatch);
        } else if (searchUtil.getType() == 1) {
            Object inputObject = this.logPage.getView().getViewer().getInput();
            SimpleSearchQuery query = (SimpleSearchQuery)((LogContentProvider)this.logPage.getView().getViewer().getContentProvider()).getQuery();
            if (query != null) {
                sel = searchUtil.search(query, criteria);
            } else {
                ILogFilterCriteria filterCriteria = ((LogContentProvider)this.logPage.getView().getViewer().getContentProvider()).getFilterCriteria();
                sel = searchUtil.search((SimpleSearchQuery)LogQueryBuilder.createQuery((List)((List)HyadesUtil.getLogAgents((EObject)((EObject)inputObject))), (ILogFilterCriteria)filterCriteria), criteria);
            }
        }
        this.setSelection(sel);
        return true;
    }

    public boolean filterRecord(ILogFilterCriteria criteria) {
        LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(5, this));
        return true;
    }

    public LogRecordSearch getRecordSearchEngine() {
        if (this.logRecordSearch == null) {
            this.logRecordSearch = new LogRecordSearch();
            this.initializeRecordSearchEngine();
        }
        return this.logRecordSearch;
    }

    protected void initializeRecordSearchEngine() {
        ILogFilterCriteria filterCriteria = ((LogContentProvider)this.logPage.getView().getViewer().getContentProvider()).getFilterCriteria();
        Object inputObject = this.logPage.getView().getViewer().getInput();
        if (!(inputObject instanceof EObject)) {
            return;
        }
        LogViewerUI ui = this.logPage.getView();
        if (ui != null && ui.getViewer() != null) {
            LogContentProvider logContentProvider = (LogContentProvider)ui.getViewer().getContentProvider();
            this.cbeList = logContentProvider.getCachedElements();
        }
        Object start = this.getStartNode();
        if (this.logRecordSearch == null) {
            this.logRecordSearch = new LogRecordSearch();
        }
        if (this.isInputXMI((EObject)inputObject)) {
            this.logRecordSearch.initialize(this.cbeList, start, 0);
        } else {
            this.logRecordSearch.initialize(this.cbeList, start, 1);
        }
    }

    private void setSelection(Object sel) {
        if (sel == null) {
            this.searchDialog.updateMessage(LogUIPlugin.getResourceString("STR_STRING_NOT_FOUND"));
            return;
        }
        EObject mofObject = this.logPage.getTraceViewer().getObjectToView(HyadesUtil.getMofObject());
        if (sel != null && sel instanceof EObject) {
            this.logPage.getTraceViewer().setRecordSelection((EObject)sel, mofObject);
        }
        this.lastMatch = sel;
        this.logPage.getView().getViewer().reveal(this.lastMatch);
        this.notifySelectionChanged((EObject)sel);
    }

    private void notifySelectionChanged(EObject sel) {
        LogUtil.notifyViewSelectionChanged(this.logPage.getView(), sel);
    }

    private Object getStartNode() {
        IStructuredSelection sel = (IStructuredSelection)this.logPage.getView().getViewer().getSelection();
        Object object = sel.getFirstElement();
        if (object instanceof CBECommonBaseEvent) {
            return object;
        }
        if (object instanceof EObject) {
            return this.getCBENode(object);
        }
        if (object instanceof FeatureNode) {
            return this.getCBENode(((FeatureNode)object).getElement());
        }
        if (object instanceof TreeNode) {
            return this.getCBENode(((TreeNode)object).getParent());
        }
        if (object instanceof TerminalNode) {
            return this.getCBENode(((TerminalNode)object).getTreeParent());
        }
        return null;
    }

    private Object getCBENode(Object object) {
        if (object instanceof CBECommonBaseEvent) {
            return object;
        }
        if (object instanceof EObject) {
            return this.getCBENode(((EObject)object).eContainer());
        }
        return null;
    }

    private boolean isInputXMI(EObject inputObject) {
        List agentProxies = (List)HyadesUtil.getLogAgents((EObject)inputObject);
        TRCAgentProxy proxy = null;
        TRCAgent agent = null;
        int s = agentProxies.size();
        for (int i = 0; i < s; ++i) {
            proxy = (TRCAgentProxy)agentProxies.get(i);
            agent = (TRCAgent)proxy.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false);
            if (agent == null || !EcoreUtil.getURI((EObject)agent).path().endsWith("xmi")) continue;
            return true;
        }
        return false;
    }

    public boolean storeFindOptions(LogFindCriteria criteria) {
        FilterTableElement.saveFilters(criteria.getFilters(), "pd_src_filter_options", LogUIPlugin.getDefault().getPreferenceStore());
        LogUIPlugin.getDefault().getPreferenceStore().setValue("pd_src_direction_options", criteria.isForwardDirection() ? "1" : "-1");
        return true;
    }

    public String loadFindPreferenceString() {
        IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
        return store.getString("pd_src_filter_options");
    }

    public boolean loadFindDirection() {
        return LogUIPlugin.getDefault().getPreferenceStore().getString("pd_src_direction_options").equals("1");
    }

    public LogPage getLogPage() {
        return this.logPage;
    }

    static /* synthetic */ Action access$100(LogViewer x0) {
        return x0.pageUp;
    }

    static /* synthetic */ Action access$500(LogViewer x0) {
        return x0.pageDown;
    }
}

