/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.wizards.IImportWizardWidget;
import org.eclipse.hyades.log.ui.internal.wizards.ImportLogWizardPage;
import org.eclipse.hyades.log.ui.internal.wizards.ImportWizardCheckBox;
import org.eclipse.hyades.log.ui.internal.wizards.ImportWizardComboBox;
import org.eclipse.hyades.log.ui.internal.wizards.ImportWizardRadioButton;
import org.eclipse.hyades.log.ui.internal.wizards.ImportWizardTextArea;
import org.eclipse.hyades.log.ui.internal.wizards.ImportWizardTextField;
import org.eclipse.hyades.log.ui.internal.wizards.LogFileDetailsUI;
import org.eclipse.hyades.log.ui.internal.wizards.LogFileElement;
import org.eclipse.hyades.log.ui.internal.wizards.LogParserItem;
import org.eclipse.hyades.log.ui.internal.wizards.ParserField;
import org.eclipse.hyades.logging.parsers.IWidgetListener;
import org.eclipse.hyades.sdb.internal.util.TString;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class LogLocationUI
implements Listener,
ModifyListener {
    private String _logParserId;
    private String lastWasHome = "";
    private String prefix = "ImportLogFile.";
    private String host = "";
    private ImportLogWizardPage page;
    private LogFileDetailsUI details;
    private ParserPropertiesComposite[] composites;
    private Shell shell;
    private Map _widgets = new HashMap();
    private Map _listeners = new HashMap();
    private static final short COMBO_BOX = 0;
    private static final short CHECK_BOX = 1;
    private static final short RADIO = 2;
    private static final short TEXT_AREA = 3;
    private static final short TEXT_FIELD = 4;
    private Vector _listenersServed = new Vector();

    public LogLocationUI(ImportLogWizardPage page, LogFileDetailsUI details) {
        this.page = page;
        this.details = details;
    }

    public Composite createControl(Composite parent) {
        this.composites = new ParserPropertiesComposite[this.details.getParserCount()];
        LogParserItem item = this.details.getSelectedParser();
        return this.createControl(parent, item);
    }

    protected Composite createControl(Composite parent, LogParserItem parser) {
        ParserPropertiesComposite composite = new ParserPropertiesComposite(parent, 0);
        GridLayout layout = new GridLayout();
        this._widgets = new HashMap();
        this._listenersServed = new Vector();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData(GridUtil.createFill());
        ArrayList fields = parser.getFields();
        this.prefix = this.details.getHostName() + "." + this.details.getSelectedParser().getDescription() + ".";
        for (int idx = 0; idx < fields.size(); ++idx) {
            ParserField field = (ParserField)fields.get(idx);
            if (field == null) continue;
            this.createWidget(composite, field);
        }
        this.composites[this.details.indexOf((LogParserItem)parser)] = composite;
        this.enableButtons(composite);
        return composite;
    }

    protected void createVerticalSpace(Composite comp, int colSpan) {
        Label label = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = colSpan;
        label.setLayoutData((Object)gd);
    }

    public void createWidget(ParserPropertiesComposite composite, ParserField field) {
        IImportWizardWidget widget = null;
        String trim = field.getUiType().trim();
        int type = 4;
        if (trim.equals("combobox")) {
            widget = new ImportWizardComboBox(field);
            type = 0;
        } else if (trim.equals("checkbox")) {
            widget = new ImportWizardCheckBox(field);
            type = 1;
        } else if (trim.equals("radio")) {
            widget = new ImportWizardRadioButton(field);
            type = 2;
        } else if (trim.equals("text_area")) {
            widget = new ImportWizardTextArea(field);
            type = 3;
        } else {
            widget = new ImportWizardTextField(composite.getFiltersTable(), field);
        }
        widget.createControl(composite, this.prefix);
        IWidgetListener listener = widget.getField().getListenerInstance();
        if (type == 0) {
            WorkbenchHelp.setHelp((Control)((ImportWizardComboBox)widget).getComboBox(), (String)(LogUIPlugin.getPluginId() + ".importloglocation"));
            this._widgets.put(field.getId(), ((ImportWizardComboBox)widget).getComboBox());
            if (listener != null) {
                this._listeners.put(((ImportWizardComboBox)widget).getComboBox(), listener);
                ((ImportWizardComboBox)widget).getComboBox().addListener(13, (Listener)this);
            }
        } else if (type == 1) {
            WorkbenchHelp.setHelp((Control)((ImportWizardCheckBox)widget).getCheckBox(), (String)(LogUIPlugin.getPluginId() + ".importloglocation"));
            this._widgets.put(field.getId(), ((ImportWizardCheckBox)widget).getCheckBox());
            if (listener != null) {
                this._listeners.put(((ImportWizardCheckBox)widget).getCheckBox(), listener);
                ((ImportWizardCheckBox)widget).getCheckBox().addListener(13, (Listener)this);
            }
        } else if (type == 2) {
            Iterator buttons = ((ImportWizardRadioButton)widget).getButtonList().iterator();
            int i = 0;
            while (buttons.hasNext()) {
                Button currentButton = (Button)buttons.next();
                WorkbenchHelp.setHelp((Control)currentButton, (String)(LogUIPlugin.getPluginId() + ".importloglocation"));
                this._widgets.put(field.getId() + "_" + i, currentButton);
                if (listener != null) {
                    this._listeners.put(currentButton, listener);
                    currentButton.addListener(13, (Listener)this);
                }
                ++i;
            }
        } else if (type == 3) {
            WorkbenchHelp.setHelp((Control)((ImportWizardTextArea)widget).getText(), (String)(LogUIPlugin.getPluginId() + ".importloglocation"));
            this._widgets.put(field.getId(), ((ImportWizardTextArea)widget).getText());
            if (listener != null) {
                this._listeners.put(((ImportWizardTextArea)widget).getText(), listener);
                ((ImportWizardTextArea)widget).getText().addListener(13, (Listener)this);
            }
        } else {
            WorkbenchHelp.setHelp((Control)((ImportWizardTextField)widget).getText(), (String)(LogUIPlugin.getPluginId() + ".importloglocation"));
            WorkbenchHelp.setHelp((Control)((ImportWizardTextField)widget).getBtn(), (String)(LogUIPlugin.getPluginId() + ".browsebtn"));
            this._widgets.put(field.getId(), ((ImportWizardTextField)widget).getText());
            if (listener != null) {
                this._listeners.put(((ImportWizardTextField)widget).getText(), listener);
                ((ImportWizardTextField)widget).getText().addListener(13, (Listener)this);
            }
        }
        if (widget instanceof ImportWizardTextField) {
            ImportWizardTextField textField = (ImportWizardTextField)widget;
            textField.getText().addModifyListener((ModifyListener)this);
            composite.getButtonList().add(((ImportWizardTextField)widget).getBtn());
            composite.getFieldList().put(field.getId(), field);
        }
        composite.getControlLookup().put(field.getId(), widget);
        composite.getFieldIDs().add(field.getId());
    }

    public void initialize(Composite composite, LogFileElement elem) {
        this.prefix = this.details.getHostName() + "." + this.details.getSelectedParser().getDescription() + ".";
        IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
        String previousValue = "";
        ParserField field = null;
        List values = elem.getValues();
        Map input = ((ParserPropertiesComposite)composite).getControlLookup();
        List fieldIDs = ((ParserPropertiesComposite)composite).getFieldIDs();
        IImportWizardWidget widget = null;
        boolean i = false;
        Iterator iter = fieldIDs.iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            widget = (IImportWizardWidget)input.get(id);
            field = widget.getField();
            previousValue = store.getString(this.prefix + field.getId());
            if (previousValue != null && !previousValue.equals("")) {
                widget.setValue(previousValue);
                continue;
            }
            widget.setValue(field.getDefaultValue());
        }
    }

    public void initializeUIFromLogElement(Composite composite, LogFileElement elem) {
        ParserField field = null;
        List values = elem.getValues();
        List fieldIDs = ((ParserPropertiesComposite)composite).getFieldIDs();
        Map input = ((ParserPropertiesComposite)composite).getControlLookup();
        IImportWizardWidget widget = null;
        int i = 0;
        Iterator iter = fieldIDs.iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            widget = (IImportWizardWidget)input.get(id);
            field = widget.getField();
            if (i < values.size() && values.get(i) != null && values.get(i).toString().length() > 0) {
                widget.setValue((String)values.get(i));
            }
            ++i;
        }
    }

    public Hashtable getUserInput(LogParserItem item) {
        ParserPropertiesComposite composite = this.composites[this.details.indexOf(item)];
        Hashtable<String, String> table = new Hashtable<String, String>();
        Iterator iter = composite.getControlLookup().keySet().iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            IImportWizardWidget widget = (IImportWizardWidget)composite.getControlLookup().get(id);
            table.put(id, widget.getValue());
        }
        return table;
    }

    public Composite getCompositeFor(LogParserItem parser) {
        int index = this.details.indexOf(parser);
        if (index > -1) {
            return this.composites[index];
        }
        return null;
    }

    public boolean finish() {
        ParserField field = null;
        Object text = null;
        LogFileElement logElem = this.page.getSelectedElement();
        Hashtable input = this.getUserInput(this.details.getSelectedParser());
        this.prefix = this.details.getHostName() + "." + this.details.getSelectedParser().getDescription() + ".";
        this.updateElement(logElem, input);
        Composite selected = this.getCompositeFor(this.details.getSelectedParser());
        ParserPropertiesComposite composite = (ParserPropertiesComposite)selected;
        Map fields = composite.getFieldList();
        Set keys = fields.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            field = (ParserField)fields.get(iter.next());
            IImportWizardWidget widget = (IImportWizardWidget)composite.getControlLookup().get(field.getId());
            if (field.useBrowse() && this.details.isLocalHost() && !new File(widget.getValue()).exists()) {
                String message = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_NO_FILE_EXISTS");
                message = TString.change((String)message, (String)"%1", (String)widget.getValue());
                MessageDialog.openError((Shell)this.page.getShell(), (String)LogUIPlugin.getResourceString("LOGGING_MESSAGE"), (String)message);
                return false;
            }
            if (widget.isValid()) {
                IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
                store.setValue(this.prefix + field.getId(), widget.getValue());
                continue;
            }
            return false;
        }
        return true;
    }

    public void updateElement(LogFileElement logElem, Map input) {
        List fieldIDs = ((ParserPropertiesComposite)this.getCompositeFor(logElem.getParser())).getFieldIDs();
        List values = logElem.getValues();
        values.clear();
        Iterator iter = fieldIDs.iterator();
        while (iter.hasNext()) {
            values.add(input.get(iter.next()));
        }
    }

    public void modifyText(ModifyEvent e) {
        this.details.setOKButtonEnabled(this.isTabItemComplete());
    }

    public void handleEvent(Event event) {
        if (this._listeners.containsKey(event.widget)) {
            IWidgetListener listener = (IWidgetListener)this._listeners.get(event.widget);
            String value = String.valueOf(listener.hashCode());
            if (!this._listenersServed.contains(value)) {
                this._listenersServed.add(value);
                this.details.updateListenersServed(this._listenersServed);
                listener.storeWidgets(this._widgets);
            }
            listener.takeAction(event);
        }
    }

    public boolean isTabItemComplete() {
        Composite selected = this.getCompositeFor(this.details.getSelectedParser());
        Iterator iter = ((ParserPropertiesComposite)selected).getControlLookup().values().iterator();
        while (iter.hasNext()) {
            IImportWizardWidget widget = (IImportWizardWidget)iter.next();
            if (widget.isValid()) continue;
            return false;
        }
        return true;
    }

    public void enableButtons(Composite composite) {
        boolean isLocalHost = this.details.isLocalHost();
        List buttons = ((ParserPropertiesComposite)composite).getButtonList();
        for (int idx = 0; idx < buttons.size(); ++idx) {
            Button btn = (Button)buttons.get(idx);
            btn.setEnabled(isLocalHost);
        }
    }

    public void setWidgets(Map widgets) {
        this._widgets = widgets;
    }

    public Map getWidgets() {
        return this._widgets;
    }

    public void setListenersServed(Vector listenersServed) {
        this._listenersServed = listenersServed;
    }

    public Vector getListenersServed() {
        return this._listenersServed;
    }

    class ParserPropertiesComposite
    extends Composite {
        private Hashtable _filtersTable = new Hashtable();
        private Map controlLookup = new HashMap();
        private Map _fieldList = new Hashtable();
        private List _buttonList = new ArrayList();
        private List ids = new ArrayList();

        public ParserPropertiesComposite(Composite parent, int style) {
            super(parent, style);
        }

        public List getButtonList() {
            return this._buttonList;
        }

        public Map getFieldList() {
            return this._fieldList;
        }

        public List getFieldIDs() {
            return this.ids;
        }

        public Hashtable getFiltersTable() {
            return this._filtersTable;
        }

        public Map getControlLookup() {
            return this.controlLookup;
        }
    }
}

