/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.wizards.ParserField;
import org.eclipse.hyades.log.ui.internal.wizards.ParserParameter;
import org.eclipse.hyades.logging.parsers.IParser;
import org.eclipse.hyades.logging.parsers.Parser;
import org.eclipse.jface.resource.ImageDescriptor;

public class LogParserItem {
    private String _id = "";
    private String _name = "";
    private String _uiName = "_unknown";
    private String _desc = "";
    private ImageDescriptor _imgDesc;
    private String _class = "";
    private String _uiType = "text_field";
    private ArrayList _parserFields = new ArrayList();
    private IConfigurationElement _config;
    private ArrayList _parserParameters = new ArrayList();
    private Map _widgets;
    private Vector _listenersServed;

    public LogParserItem(String id, String name, String uiName, String desc) {
        if (id != null) {
            this._id = id;
        }
        if (name != null) {
            this._name = name;
        }
        if (uiName != null) {
            this._uiName = uiName;
        }
        if (desc != null) {
            this._desc = desc;
        }
    }

    public void setImageDescriptor(ImageDescriptor imgDesc) {
        this._imgDesc = imgDesc;
    }

    public void setClass(String cls) {
        if (cls != null) {
            this._class = cls;
        }
    }

    public void setUIType(String type) {
        if (type != null) {
            this._uiType = type;
        }
    }

    public void addEntry(ParserField field) {
        this._parserFields.add(field);
    }

    public String getName() {
        return this._name;
    }

    public String getUIType() {
        return this._uiType;
    }

    public String getUIName() {
        return this._uiName;
    }

    public String getDescription() {
        return this._desc;
    }

    public ImageDescriptor getImageDescriptor() {
        return this._imgDesc;
    }

    public ArrayList getFields() {
        return this._parserFields;
    }

    public String getId() {
        return this._id;
    }

    public String getParserClass() {
        return this._class;
    }

    public Parser getParserInstance() {
        try {
            if (this._config == null) {
                return null;
            }
            Object elem = this._config.createExecutableExtension("class");
            if (elem instanceof IParser) {
                return (Parser)elem;
            }
            System.err.println(LogUIPlugin.getResourceString("LOG_PARSER_ERROR"));
        }
        catch (CoreException exc) {
            return null;
        }
        return null;
    }

    public void setConfigurationElement(IConfigurationElement elem) {
        this._config = elem;
    }

    public void setWidgets(Map widgets) {
        this._widgets = widgets;
    }

    public Map getWidgets() {
        return this._widgets;
    }

    public void setListenersServed(Vector listenersServed) {
        this._listenersServed = listenersServed;
    }

    public Vector getListenersServed() {
        return this._listenersServed;
    }

    public ArrayList getParserParameters() {
        return this._parserParameters;
    }

    public void addParameter(ParserParameter para) {
        this._parserParameters.add(para);
    }
}

