/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.remote;

import java.util.HashMap;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutionComponentFactory;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.invocation.IRemoteObject;
import org.eclipse.hyades.execution.invocation.Marshaller;
import org.eclipse.hyades.execution.invocation.RemoteInvocationException;
import org.eclipse.hyades.execution.invocation.ReturnData;
import org.eclipse.hyades.execution.remote.ClassRelationship;
import org.eclipse.hyades.execution.remote.ExecutionComponentSkeleton;
import org.eclipse.hyades.execution.remote.RemoteObjectSkeleton;

public class ExecutionComponentFactoryImpl
implements IExecutionComponentFactory,
IRemoteObject {
    private static ExecutionComponentFactoryImpl instance;
    private static ISession sessionContext;
    private HashMap components = new HashMap();

    private ExecutionComponentFactoryImpl(ISession session) {
        sessionContext = session;
        Marshaller.addInstanceToMap((Integer)this.getUniqueId(), (Object)this);
    }

    public static ExecutionComponentFactoryImpl getInstance(ISession session) {
        if (instance == null) {
            instance = new ExecutionComponentFactoryImpl(session);
        }
        return instance;
    }

    public ISession getSessionContext() {
        return sessionContext;
    }

    public void setSessionContext(ISession session) {
        throw new UnsupportedOperationException("The session context of the factory should not be set via this method");
    }

    public Integer getUniqueId() {
        return new Integer(-1);
    }

    public IExecutionComponent createExecutionComponentByType(String type) {
        return null;
    }

    public IExecutionComponent createExecutionComponentByType(Integer remoteId, String type) {
        ClassRelationship rel = (ClassRelationship)this.components.get(type);
        if (rel != null) {
            try {
                Class impl = rel.impl;
                Class skel = rel.skeletonClass;
                IExecutionComponent implInstance = (IExecutionComponent)impl.newInstance();
                ExecutionComponentSkeleton skelInstance = (ExecutionComponentSkeleton)skel.newInstance();
                skelInstance.setId(remoteId);
                skelInstance.setDelegate(implInstance);
                skelInstance.setSessionContext(sessionContext);
                Marshaller.addInstanceToMap((Integer)skelInstance.getUniqueId(), (Object)skelInstance);
                skelInstance.init();
                return skelInstance;
            }
            catch (Throwable e) {
                throw new RemoteInvocationException(e);
            }
        }
        throw new RemoteInvocationException("Factory not configured for this type");
    }

    public IRemoteObject createRemoteObjectByType(Integer remoteId, String type) {
        ClassRelationship rel = (ClassRelationship)this.components.get(type);
        if (rel != null) {
            try {
                Class impl = rel.impl;
                Class skel = rel.skeletonClass;
                Object implInstance = impl.newInstance();
                RemoteObjectSkeleton skelInstance = (RemoteObjectSkeleton)skel.newInstance();
                skelInstance.setId(remoteId);
                skelInstance.setDelegate(implInstance);
                skelInstance.setSessionContext(sessionContext);
                Marshaller.addInstanceToMap((Integer)skelInstance.getUniqueId(), (Object)skelInstance);
                skelInstance.init();
                return skelInstance;
            }
            catch (Throwable e) {
                throw new RemoteInvocationException(e);
            }
        }
        throw new RemoteInvocationException("Factory not configured for this type");
    }

    public void addExecutionComponent(String type, String implClass) throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(implClass, true, this.getClass().getClassLoader());
            ClassRelationship rel = new ClassRelationship();
            rel.impl = clazz;
            this.components.put(type, rel);
        }
        catch (ClassNotFoundException e) {
            throw new RemoteInvocationException((Throwable)e);
        }
    }

    public void addStub(String type, String stubClass) throws ClassNotFoundException {
    }

    public void addSkeleton(String type, String skeletonClass) throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(skeletonClass, true, this.getClass().getClassLoader());
            ClassRelationship rel = (ClassRelationship)this.components.get(type);
            if (rel != null) {
                rel.skeletonClass = clazz;
            }
        }
        catch (ClassNotFoundException e) {
            throw new RemoteInvocationException((Throwable)e);
        }
    }

    public ReturnData delegateRemoteCall(Class[] argTypes, Object[] callArgs, String call) throws RemoteInvocationException {
        return null;
    }

    public Object getDelegate() {
        return this;
    }

    public void setDelegate(Object delegate) {
    }

    public void init() {
    }
}

