/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.logc.internal.uml2sd;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.sd.logc.SDLogcPluginImages;
import org.eclipse.hyades.sd.logc.internal.util.LogcUtil;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.uml2sd.ui.core.ExecutionOccurrence;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class LogGraphNode
extends ExecutionOccurrence
implements IPropertySource,
IActionFilter {
    private EObject element;
    private List elements = null;
    private boolean expanded = false;
    private IPropertyDescriptor[] propertyDescriptors;
    private static String PROPERTY = "cbe.node.";

    protected LogGraphNode() {
    }

    public LogGraphNode(EObject element) {
        this.element = element;
    }

    public EObject getElement() {
        if (!this.hasElements() || this.hasElements() && this.isExpanded()) {
            return this.element;
        }
        return (EObject)this.elements.get(0);
    }

    public List getElements() {
        return this.elements;
    }

    public void addElement(EObject newElement) {
        if (this.elements == null) {
            this.elements = new ArrayList();
            if (this.element != null) {
                this.elements.add(this.element);
            }
        }
        this.elements.add(newElement);
    }

    public boolean hasElements() {
        return this.elements != null && this.elements.size() > 0;
    }

    public void setBackgroundColor() {
        short sev = 0;
        if (!this.hasElements() || this.isExpanded()) {
            sev = ((CBECommonBaseEvent)this.element).getSeverity();
        } else {
            CBECommonBaseEvent max = (CBECommonBaseEvent)Collections.max(this.elements, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (((CBECommonBaseEvent)o1).getSeverity() > ((CBECommonBaseEvent)o2).getSeverity()) {
                        return 1;
                    }
                    if (((CBECommonBaseEvent)o1).getSeverity() == ((CBECommonBaseEvent)o2).getSeverity()) {
                        return 0;
                    }
                    return -1;
                }
            });
            sev = max.getSeverity();
        }
        if (sev >= 0 && sev <= 70) {
            if (sev >= 50) {
                this.setFillColor(LogcUtil.redFill[0], LogcUtil.redFill[1], LogcUtil.redFill[2]);
                this.setStrokeColor(LogcUtil.redStroke[0], LogcUtil.redStroke[1], LogcUtil.redStroke[2]);
            } else if (sev >= 30 && sev < 50) {
                this.setFillColor(LogcUtil.yellowFill[0], LogcUtil.yellowFill[1], LogcUtil.yellowFill[2]);
                this.setStrokeColor(LogcUtil.yellowStroke[0], LogcUtil.yellowStroke[1], LogcUtil.yellowStroke[2]);
            } else if (sev < 30) {
                this.setFillColor(LogcUtil.blueFill[0], LogcUtil.blueFill[1], LogcUtil.blueFill[2]);
                this.setStrokeColor(LogcUtil.blueStroke[0], LogcUtil.blueStroke[1], LogcUtil.blueStroke[2]);
            }
        }
        if (this.hasElements()) {
            if (this.isExpanded()) {
                this.setImage(SDLogcPluginImages.getImage("collapse_ovr.gif"));
            } else {
                this.setImage(SDLogcPluginImages.getImage("expand_ovr.gif"));
            }
        }
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (!this.hasElements() || this.isExpanded()) {
            if (this.propertyDescriptors == null) {
                this.propertyDescriptors = new IPropertyDescriptor[1];
                PropertyDescriptor cbeListsDescriptor = new PropertyDescriptor((Object)PROPERTY, "[" + CBEUtils.formatCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)this.element), (SimpleDateFormat)LogUIPlugin.getDateTimeFormat()) + "] " + ((CBECommonBaseEvent)this.element).getMsg());
                cbeListsDescriptor.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        return TString.change((String)SDLogcPlugin.getString("STR_SEVERITY_A"), (String)"%1", (String)("" + ((CBECommonBaseEvent)element).getSeverity()));
                    }
                });
                this.propertyDescriptors[0] = cbeListsDescriptor;
            }
        } else if (this.propertyDescriptors == null) {
            this.propertyDescriptors = new IPropertyDescriptor[this.elements.size()];
            for (int i = 0; i < this.elements.size(); ++i) {
                PropertyDescriptor cbeListsDescriptor = new PropertyDescriptor((Object)(PROPERTY + i), i + ": [" + CBEUtils.formatCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)this.elements.get(i)), (SimpleDateFormat)LogUIPlugin.getDateTimeFormat()) + "] " + ((CBECommonBaseEvent)this.elements.get(i)).getMsg());
                final int idx = i;
                cbeListsDescriptor.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        return TString.change((String)SDLogcPlugin.getString("STR_SEVERITY_A"), (String)"%1", (String)("" + ((CBECommonBaseEvent)LogGraphNode.this.elements.get(idx)).getSeverity()));
                    }
                });
                cbeListsDescriptor.setCategory(TString.change((String)SDLogcPlugin.getString("STR_CBES"), (String)"%1", (String)("" + this.elements.size())));
                this.propertyDescriptors[i] = cbeListsDescriptor;
            }
        }
        return this.propertyDescriptors;
    }

    public Object getPropertyValue(Object id) {
        if (!this.hasElements() || this.isExpanded()) {
            return this.element;
        }
        return this.elements;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (target instanceof LogGraphNode) {
            if (name.equals("isExpanded") && value.equals("true")) {
                return ((LogGraphNode)((Object)target)).isExpanded();
            }
            if (name.equals("isExpanded") && value.equals("false")) {
                return ((LogGraphNode)((Object)target)).hasElements() && !((LogGraphNode)((Object)target)).isExpanded();
            }
        }
        return false;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }
}

