/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.harness.util;

import java.util.Iterator;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;

public class DeploymentUtilities {
    public static String getTestMachine(CFGClass rootResource, IImplementor theImplementor, TPFDeployment deployment) {
        CFGArtifactLocationPair pair;
        String machineName = null;
        if (!deployment.getArtifactLocations().isEmpty() && (pair = DeploymentUtilities.searchPairWithTestAsset(rootResource, deployment)) != null) {
            CFGLocation location = pair.getLocation();
            if (location instanceof CFGMachineConstraint) {
                machineName = ((CFGMachineConstraint)location).getHostname();
            } else if (location != null) {
                machineName = location.getName();
            }
        }
        return machineName;
    }

    public static CFGArtifactLocationPair searchPairWithTestAsset(CFGClass testAsset, TPFDeployment deployment) {
        CFGArtifactLocationPair pair = null;
        CFGArtifact artifact = null;
        Iterator i = deployment.getArtifactLocations().iterator();
        while (i.hasNext()) {
            pair = (CFGArtifactLocationPair)i.next();
            artifact = pair.getArtifact();
            if (artifact == null || artifact.getDeployableInstances().isEmpty()) continue;
            Iterator it = artifact.getDeployableInstances().iterator();
            while (it.hasNext()) {
                CFGClass cls = (CFGClass)it.next();
                if (cls.getId() == null || !cls.getId().equals(testAsset.getId())) continue;
                return pair;
            }
        }
        return null;
    }
}

