/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// EObject -> INavigatorItem
public class SampleItemRegistry {
	private static final Map _map = new HashMap();
	
	public static final void addChild(Object obj, SampleItem item) {
		List children = (List)_map.get(obj);
		if (children == null) {
			children = new ArrayList();
			_map.put(obj, children);
		}
		children.add(item);
	}
	
	public static final void removeChild(Object obj, SampleItem item) {
		List children = (List)_map.get(obj);
		if (children != null)
			children.remove(item);
	}
	
	public static final boolean hasChildren(Object obj) {
		List children = (List)_map.get(obj);
		return (children != null && !children.isEmpty());
	}

	public static final List getChildren(Object obj) {
		List children = (List)_map.get(obj);
		if (children == null)
			return new ArrayList(0);
		return children;
	}
}
