/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;

public class JavaSearchScope
implements IJavaSearchScope,
IDisposable {
    private Collection elements = new HashSet();
    private Collection resourcePaths = new HashSet();
    private Collection projectAndJarPaths = new HashSet();
    private boolean includesBinaries = true;
    private boolean includesClasspaths = true;
    private IJavaSearchScope workspaceScope = SearchEngine.createWorkspaceScope();

    public void dispose() {
        this.elements.clear();
        this.resourcePaths.clear();
        this.projectAndJarPaths.clear();
        this.workspaceScope = null;
    }

    public boolean addJavaElement(IJavaElement element) {
        if (element == null) {
            return false;
        }
        return this.elements.add(element);
    }

    public boolean addResource(IResource resource) {
        return this.addResource(resource.getFullPath().toString());
    }

    public boolean addResource(String resource) {
        if (resource == null) {
            return false;
        }
        return this.resourcePaths.add(resource);
    }

    public boolean addProjectAndJarPath(IPath path) {
        if (path == null) {
            return false;
        }
        return this.projectAndJarPaths.add(path);
    }

    public boolean encloses(IJavaElement element) {
        if (this.elements.isEmpty()) {
            return this.workspaceScope.encloses(element);
        }
        return this.elements.contains(element);
    }

    public boolean encloses(String resourcePath) {
        if (this.resourcePaths.isEmpty()) {
            return this.workspaceScope.encloses(resourcePath);
        }
        return this.resourcePaths.contains(resourcePath);
    }

    public IPath[] enclosingProjectsAndJars() {
        if (this.projectAndJarPaths.isEmpty()) {
            return this.workspaceScope.enclosingProjectsAndJars();
        }
        return this.projectAndJarPaths.toArray(new IPath[this.projectAndJarPaths.size()]);
    }

    public boolean includesBinaries() {
        return this.includesBinaries;
    }

    public boolean includesClasspaths() {
        return this.includesClasspaths;
    }

    public void setIncludesBinaries(boolean includesBinaries) {
        this.includesBinaries = includesBinaries;
    }

    public void setIncludesClasspaths(boolean includesClasspaths) {
        this.includesClasspaths = includesClasspaths;
    }
}

