/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ILibrary;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ISetSelectionTarget;

public class ResourceUtil {
    static /* synthetic */ Class class$org$eclipse$ui$part$ISetSelectionTarget;

    public static void createContainer(IContainer container, IProgressMonitor progressMonitor) throws CoreException {
        if (container == null || container.exists()) {
            return;
        }
        ResourceUtil.createContainer(container.getParent(), progressMonitor);
        if (container instanceof IProject) {
            ((IProject)container).create(progressMonitor);
        } else if (container instanceof IFolder) {
            ((IFolder)container).create(true, true, progressMonitor);
        }
    }

    public static void selectAndReveal(IResource resource, IWorkbenchWindow window) {
        int i;
        if (window == null || resource == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        for (i = 0; i < refs.length; ++i) {
            IWorkbenchPart part = refs[i].getPart(false);
            if (part == null) continue;
            parts.add(part);
        }
        refs = page.getEditorReferences();
        for (i = 0; i < refs.length; ++i) {
            if (refs[i].getPart(false) == null) continue;
            parts.add(refs[i].getPart(false));
        }
        StructuredSelection selection = new StructuredSelection((Object)resource);
        Iterator iterator = parts.iterator();
        while (iterator.hasNext()) {
            IWorkbenchPart part = (IWorkbenchPart)iterator.next();
            ISetSelectionTarget target = null;
            target = part instanceof ISetSelectionTarget ? (ISetSelectionTarget)part : (ISetSelectionTarget)part.getAdapter(class$org$eclipse$ui$part$ISetSelectionTarget == null ? ResourceUtil.class$("org.eclipse.ui.part.ISetSelectionTarget") : class$org$eclipse$ui$part$ISetSelectionTarget);
            if (target == null) continue;
            final ISetSelectionTarget finalTarget = target;
            window.getShell().getDisplay().asyncExec(new Runnable((ISelection)selection){
                private final /* synthetic */ ISelection val$selection;
                {
                    this.val$selection = val$selection;
                }

                public void run() {
                    finalTarget.selectReveal(this.val$selection);
                }
            });
        }
    }

    public static File getPluginDirectory(String pluginId) {
        File pluginDir = null;
        try {
            URL pluginURL = new URL(Platform.getPlugin((String)pluginId).getDescriptor().getInstallURL(), "plugin.xml");
            File manifestFile = new File(Platform.asLocalURL((URL)pluginURL).getFile()).getAbsoluteFile();
            if (manifestFile.exists()) {
                pluginDir = manifestFile.getParentFile();
            }
        }
        catch (Exception e) {
            HyadesUIPlugin.logError(e);
        }
        return pluginDir;
    }

    public static String[] getPluginLibraries(String pluginId) {
        if (pluginId == null) {
            return new String[0];
        }
        Plugin plugin = Platform.getPlugin((String)pluginId);
        if (plugin == null) {
            return new String[0];
        }
        File pluginDir = ResourceUtil.getPluginDirectory(pluginId);
        ILibrary[] pluginLibraries = plugin.getDescriptor().getRuntimeLibraries();
        ArrayList<String> libraries = new ArrayList<String>(pluginLibraries.length);
        int maxi = pluginLibraries.length;
        for (int i = 0; i < maxi; ++i) {
            File lib = new File(pluginDir, pluginLibraries[i].getPath().toString());
            try {
                libraries.add(lib.getCanonicalPath().replace('\\', '/'));
                continue;
            }
            catch (IOException e) {
                libraries.add(lib.getAbsolutePath().replace('\\', '/'));
            }
        }
        return libraries.toArray(new String[libraries.size()]);
    }

    public static Map getFiles(IWorkspaceRoot workspaceRoot, String[] fileExtensions, IGetFilesVisitor visitor) {
        HashMap filesByFileExtension = new HashMap(fileExtensions.length, 1.1f);
        int maxi = fileExtensions.length;
        for (int i = 0; i < maxi; ++i) {
            filesByFileExtension.put(fileExtensions[i], new ArrayList());
        }
        if (visitor == null) {
            visitor = new IGetFilesVisitor(){

                public Object visit(IFile file) {
                    return file;
                }
            };
        }
        IProject[] projects = workspaceRoot.getProjects();
        for (int i = 0; i < projects.length; ++i) {
            ResourceUtil.getFiles((IResource)projects[i], filesByFileExtension, visitor);
        }
        return filesByFileExtension;
    }

    public static Map getFiles(IResource resource, String[] fileExtensions, IGetFilesVisitor visitor) {
        if (resource == null || !resource.exists()) {
            return Collections.EMPTY_MAP;
        }
        if (visitor == null) {
            visitor = new IGetFilesVisitor(){

                public Object visit(IFile file) {
                    return file;
                }
            };
        }
        HashMap filesByFileExtension = new HashMap(fileExtensions.length, 1.1f);
        int maxi = fileExtensions.length;
        for (int i = 0; i < maxi; ++i) {
            filesByFileExtension.put(fileExtensions[i], new ArrayList());
        }
        ResourceUtil.getFiles(resource, filesByFileExtension, visitor);
        return filesByFileExtension;
    }

    private static void getFiles(IResource resource, Map filesByFileExtension, IGetFilesVisitor visitor) {
        if (resource == null || !resource.exists()) {
            return;
        }
        switch (resource.getType()) {
            case 1: {
                Object object;
                List files;
                String fileExtension = resource.getFileExtension();
                if (fileExtension == null || (files = (List)filesByFileExtension.get(fileExtension)) == null || (object = visitor.visit((IFile)resource)) == null) break;
                files.add(object);
                break;
            }
            case 4: {
                IProject project = (IProject)resource;
                if (!project.isOpen()) {
                    return;
                }
            }
            case 2: {
                try {
                    IResource[] members = ((IContainer)resource).members();
                    for (int i = 0; i < members.length; ++i) {
                        ResourceUtil.getFiles(members[i], filesByFileExtension, visitor);
                    }
                    break;
                }
                catch (CoreException e) {
                    HyadesUIPlugin.logError(e);
                }
            }
        }
    }

    public static List getValidAdapters(List objects, Class adapterClass) {
        ArrayList<Object> adapters = new ArrayList<Object>(objects.size());
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            Object object = i.next();
            if (object == null) continue;
            if (object instanceof IAdaptable) {
                Object adapter = ((IAdaptable)object).getAdapter(adapterClass);
                if (adapter == null) continue;
                adapters.add(adapter);
                continue;
            }
            if (!adapterClass.isInstance(object)) continue;
            adapters.add(object);
        }
        return adapters;
    }

    public static String getFullPath(IPath path) {
        if (path == null) {
            return null;
        }
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path.makeAbsolute());
        if (res != null) {
            path = res.getLocation().makeAbsolute();
        }
        return path.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface IGetFilesVisitor {
        public Object visit(IFile var1);
    }
}

