/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.wizard.exampleproject;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.FileUtil;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizard;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizardPage;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.IProjectAdjuster;

public abstract class ZipAdjusterCreationWizard
extends CreationWizard
implements IProjectAdjuster {
    private String encoding = "UTF-8";
    private List pagesToDeleteFile = new ArrayList();
    private Set zipExtensionsToChange = new HashSet();
    private String[] oldPats;
    private String[] newPats;

    public ZipAdjusterCreationWizard() {
        this.setAdjuster(this);
        this.addZipExtensions();
    }

    protected abstract void addZipExtensions();

    public void dispose() {
        this.zipExtensionsToChange.clear();
        this.pagesToDeleteFile.clear();
        this.setAdjuster(null);
        super.dispose();
    }

    public boolean addZipExtension(String zipExtension) {
        return this.zipExtensionsToChange.add(zipExtension);
    }

    public boolean removeZipExtension(String zipExtension) {
        return this.zipExtensionsToChange.remove(zipExtension);
    }

    public void removeAllZipExtensions() {
        this.zipExtensionsToChange.clear();
    }

    public ZipFile adjust(CreationWizardPage[] pages, CreationWizardPage currentPage, ZipFile zipFile) {
        if (!this.needsReplace(pages)) {
            return null;
        }
        this.pagesToDeleteFile.add(currentPage);
        try {
            return this.copyZip(zipFile.getName(), FileUtil.getTempDir() + File.separator + this.getPluginId() + FileUtil.getLastSegment(zipFile.getName()), this.oldPats, this.newPats);
        }
        catch (Exception e) {
            this.pagesToDeleteFile.remove((Object)currentPage);
            HyadesUIPlugin.logError(e);
            return null;
        }
    }

    public void finished(CreationWizardPage page, ZipFile zipFile) {
        if (!this.pagesToDeleteFile.contains((Object)page)) {
            return;
        }
        File file = new File(zipFile.getName());
        file.delete();
    }

    public File adjust(CreationWizardPage[] pages, CreationWizardPage currentPage, File file) {
        if (!this.needsReplace(pages)) {
            return null;
        }
        if (file.isDirectory()) {
            File tempDir = new File(FileUtil.getTempDir(), this.getPluginId() + file.getName() + "LMAP");
            if (tempDir.exists()) {
                FileUtil.delete(tempDir);
            }
            if (this.copyDir(file, tempDir, this.oldPats, this.newPats)) {
                this.pagesToDeleteFile.add(currentPage);
                return tempDir;
            }
            FileUtil.delete(tempDir);
        }
        return null;
    }

    public void finished(CreationWizardPage page, File file) {
        if (!this.pagesToDeleteFile.contains((Object)page)) {
            return;
        }
        FileUtil.delete(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipFile copyZip(String sourceZip, String targetZip, String[] oldPats, String[] newPats) throws IOException, FileNotFoundException {
        if (oldPats == null) {
            oldPats = new String[]{};
        }
        if (newPats == null) {
            newPats = new String[]{};
        }
        if (oldPats.length != newPats.length) {
            throw new IllegalArgumentException("oldPats.length != newPas.length");
        }
        boolean succeed = false;
        File target = new File(targetZip);
        boolean exists = target.exists();
        if (!exists) {
            target.createNewFile();
        }
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(sourceZip));
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(target));
        try {
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    zipOutputStream.putNextEntry(entry);
                    FileUtil.streamCopy(zipInputStream, zipOutputStream);
                } else {
                    String content;
                    byte[] buffer = null;
                    String newContent = content = FileUtil.readFromInputStream(this.encoding, zipInputStream, true);
                    for (int i = 0; i < oldPats.length; ++i) {
                        newContent = StringUtil.replace(newContent, oldPats[i], newPats[i]);
                    }
                    buffer = StringUtil.encode(this.encoding, newContent);
                    if (buffer == null) {
                        buffer = newContent.getBytes();
                    }
                    ZipEntry newEntry = new ZipEntry(entry);
                    newEntry.setCompressedSize(-1L);
                    if (!content.equals(newContent)) {
                        newEntry.setSize(buffer.length);
                        CRC32 checksum = new CRC32();
                        checksum.update(buffer, 0, buffer.length);
                        newEntry.setCrc(checksum.getValue());
                    }
                    zipOutputStream.putNextEntry(newEntry);
                    zipOutputStream.write(buffer);
                }
                zipInputStream.closeEntry();
                zipOutputStream.closeEntry();
            }
            succeed = true;
        }
        finally {
            try {
                zipInputStream.close();
            }
            catch (Exception e) {}
            try {
                zipOutputStream.close();
            }
            catch (Exception e) {}
        }
        if (!succeed && !exists) {
            target.delete();
        }
        return new ZipFile(target);
    }

    private boolean needsReplace(CreationWizardPage[] pages) {
        int i;
        if (this.oldPats != null) {
            return true;
        }
        ArrayList<CreationWizardPage> pagesWithNewProjectNames = new ArrayList<CreationWizardPage>();
        for (i = 0; i < pages.length; ++i) {
            IConfigurationElement[] natures = pages[i].getConfigurationElement().getChildren("nature");
            if (natures != null && natures.length > 0) {
                pagesWithNewProjectNames.add(pages[i]);
                continue;
            }
            if (pages[i].getProjectName().equals(pages[i].getInitialProjectName())) continue;
            pagesWithNewProjectNames.add(pages[i]);
        }
        if (pagesWithNewProjectNames.isEmpty()) {
            return false;
        }
        this.oldPats = new String[pagesWithNewProjectNames.size() * 2];
        this.newPats = new String[pagesWithNewProjectNames.size() * 2];
        int max = pagesWithNewProjectNames.size();
        for (i = 0; i < max; ++i) {
            CreationWizardPage page = (CreationWizardPage)((Object)pagesWithNewProjectNames.get(i));
            this.oldPats[i] = page.getInitialProjectName() + "/";
            this.oldPats[i + 1] = page.getInitialProjectName() + "\\";
            this.newPats[i] = page.getProjectName() + "/";
            this.newPats[i + 1] = page.getProjectName() + "\\";
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyFiles(File source, File target) {
        try {
            FileOutputStream outputStream;
            block8: {
                if (!target.exists()) {
                    target.createNewFile();
                }
                FileInputStream inputStream = null;
                outputStream = null;
                try {
                    inputStream = new FileInputStream(source);
                    outputStream = new FileOutputStream(target);
                    FileUtil.streamCopy(inputStream, outputStream);
                    Object var6_6 = null;
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (Exception e) {
            HyadesUIPlugin.logError(e);
            return false;
        }
        return true;
    }

    private boolean copyDir(File source, File target, String[] oldPats, String[] newPats) {
        File[] files = source.listFiles();
        if (files == null) {
            return true;
        }
        if (!target.exists()) {
            target.mkdirs();
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                File newFile = new File(target, files[i].getName()).getAbsoluteFile();
                if (this.zipExtensionsToChange.contains(FileUtil.getFileExtension(files[i]))) {
                    try {
                        this.copyZip(files[i].getAbsolutePath(), newFile.getAbsolutePath(), oldPats, newPats);
                    }
                    catch (Exception e) {
                        HyadesUIPlugin.logError(e);
                    }
                    continue;
                }
                if (newFile.getName().equals(".classpath")) {
                    try {
                        String content = FileUtil.readFromFile(this.encoding, files[i], false);
                        if (content == null) continue;
                        content = this.replaceClasspathVariables(content);
                        FileUtil.writeToFile(this.encoding, newFile, false, content);
                    }
                    catch (IOException e) {
                        HyadesUIPlugin.logError(e);
                    }
                    continue;
                }
                if (this.copyFiles(files[i], newFile)) continue;
                return false;
            }
            if (!files[i].isDirectory() || "CVS".equals(files[i].getName()) || this.copyDir(files[i], new File(target, files[i].getName()), oldPats, newPats)) continue;
            return false;
        }
        return true;
    }

    public void beforeWorspaceRefresh(CreationWizardPage[] pages) {
    }

    public void afterWorspaceRefresh(CreationWizardPage[] pages) {
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

