/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.manual.runner.model.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.test.common.event.ExecutionEvent;
import org.eclipse.hyades.test.common.event.TypedEvent;
import org.eclipse.hyades.test.common.event.VerdictEvent;
import org.eclipse.hyades.test.manual.runner.model.Action;
import org.eclipse.hyades.test.manual.runner.model.IActionOwner;
import org.eclipse.hyades.test.manual.runner.model.NamedElement;
import org.eclipse.hyades.test.manual.runner.model.TestCase;
import org.eclipse.hyades.test.manual.runner.model.TestInvocation;
import org.eclipse.hyades.test.manual.runner.model.TestSuite;
import org.eclipse.hyades.test.manual.runner.model.util.Arbiter;
import org.eclipse.hyades.test.manual.runner.model.util.EventLogger;
import org.eclipse.hyades.test.manual.runner.model.util.ExecutionManager;
import org.eclipse.hyades.test.manual.runner.model.util.Verdict;

public class ModelUtil {
    public static final Arbiter DEFAULT_ARBITER = new Arbiter();
    public static final ExecutionManager DEFAULT_EXECUTION_MANAGER = new ExecutionManager();
    private static List verdicts;
    private static EventLogger eventLogger;

    public static void setEventLogger(EventLogger eventLogger) {
        ModelUtil.eventLogger = eventLogger;
    }

    public static EventLogger getEventLogger() {
        return eventLogger;
    }

    public static List getVerdicts() {
        if (verdicts == null) {
            return Collections.EMPTY_LIST;
        }
        return verdicts;
    }

    public static void setVerdicts(List list) {
        verdicts = list;
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                return object.toString().compareTo(object2.toString());
            }

            public boolean equals(Object object) {
                return this.hashCode() != object.hashCode();
            }
        };
        Collections.sort(verdicts, comparator);
    }

    public static Verdict getDefaultVerdict() {
        Iterator iterator = ModelUtil.getVerdicts().iterator();
        while (iterator.hasNext()) {
            Verdict verdict = (Verdict)iterator.next();
            if (!verdict.isDefault()) continue;
            return verdict;
        }
        return null;
    }

    public static Verdict getVerdict(int n) {
        Iterator iterator = ModelUtil.getVerdicts().iterator();
        while (iterator.hasNext()) {
            Verdict verdict = (Verdict)iterator.next();
            if (verdict.getValue() != n) continue;
            return verdict;
        }
        return null;
    }

    public static void clearVerdicts() {
        if (verdicts != null) {
            verdicts.clear();
        }
    }

    public static boolean isOwnerTestSuite(TestSuite testSuite, NamedElement namedElement) {
        if (testSuite == DEFAULT_EXECUTION_MANAGER.getRoot()) {
            return true;
        }
        if (testSuite != null && namedElement != null) {
            if (namedElement instanceof Action) {
                return ModelUtil.isOwnerTestSuite(testSuite, (NamedElement)((Object)((Action)namedElement).getOwner()));
            }
            if (namedElement instanceof TestCase) {
                return testSuite == ((TestCase)namedElement).getTestSuite();
            }
            if (namedElement instanceof TestSuite) {
                if (namedElement == testSuite) {
                    return true;
                }
                namedElement = ((TestSuite)namedElement).getTestInvocation();
                return ModelUtil.isOwnerTestSuite(testSuite, namedElement);
            }
        }
        return false;
    }

    public static String getHierarchyId(NamedElement namedElement) {
        StringBuffer stringBuffer = new StringBuffer();
        ModelUtil.getHierarchyId(namedElement, stringBuffer);
        if (stringBuffer.length() == 0) {
            return "";
        }
        return stringBuffer.deleteCharAt(0).toString();
    }

    private static void getHierarchyId(NamedElement namedElement, StringBuffer stringBuffer) {
        if (namedElement == null) {
            return;
        }
        if (namedElement instanceof Action) {
            Action action = (Action)namedElement;
            ModelUtil.getHierarchyId((NamedElement)((Object)action.getOwner()), stringBuffer);
        } else if (namedElement instanceof TestSuite) {
            ModelUtil.getHierarchyId(((TestSuite)namedElement).getTestInvocation(), stringBuffer);
        }
        ModelUtil.appendHierarchyId(namedElement, stringBuffer);
    }

    public static String appendHierarchyId(NamedElement namedElement, String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        ModelUtil.appendHierarchyId(namedElement, stringBuffer);
        return stringBuffer.toString();
    }

    private static void appendHierarchyId(NamedElement namedElement, StringBuffer stringBuffer) {
        if (namedElement == null) {
            return;
        }
        stringBuffer.append(".").append(namedElement.getId());
        if (namedElement.getIteration() > 0) {
            stringBuffer.append("(").append(namedElement.getIteration()).append(")");
        }
    }

    public static VerdictEvent createTestVerdictEvent(TestInvocation testInvocation) {
        if (testInvocation == null || testInvocation.getTest() == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(ModelUtil.getHierarchyId(testInvocation));
        ModelUtil.appendHierarchyId((NamedElement)testInvocation.getTest(), stringBuffer);
        VerdictEvent verdictEvent = new VerdictEvent();
        verdictEvent.setOwnerId(stringBuffer.toString());
        return verdictEvent;
    }

    public static TypedEvent createTestTypedEvent(TestInvocation testInvocation) {
        if (testInvocation == null || testInvocation.getTest() == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(ModelUtil.getHierarchyId(testInvocation));
        ModelUtil.appendHierarchyId((NamedElement)testInvocation.getTest(), stringBuffer);
        TypedEvent typedEvent = new TypedEvent();
        typedEvent.setOwnerId(stringBuffer.toString());
        return typedEvent;
    }

    public static void dispose(NamedElement namedElement) {
        if (namedElement != null) {
            if (namedElement instanceof IActionOwner) {
                ModelUtil.dispose(((IActionOwner)((Object)namedElement)).getActions());
            }
            namedElement.dispose();
        }
    }

    public static void dispose(Collection collection) {
        if (collection == null) {
            return;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof NamedElement)) continue;
            ModelUtil.dispose((NamedElement)e);
        }
        collection.clear();
    }

    public static void closeExecutedTests() {
        Iterator iterator = DEFAULT_EXECUTION_MANAGER.getExecutedTestInvocations().iterator();
        while (iterator.hasNext()) {
            TestInvocation testInvocation = (TestInvocation)iterator.next();
            if (testInvocation.getTest() instanceof TestSuite && testInvocation.getVerdictEvent() == null) {
                ModelUtil.getEventLogger().log((ExecutionEvent)DEFAULT_ARBITER.analyse(testInvocation));
            }
            TypedEvent typedEvent = ModelUtil.createTestTypedEvent(testInvocation);
            typedEvent.setType(1);
            ModelUtil.getEventLogger().log((ExecutionEvent)typedEvent);
        }
    }
}

