/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.statistical;

import java.util.Iterator;
import org.eclipse.hyades.loaders.statistical.SnapshotObservationBase;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.model.statistical.SDDiscreteObservation;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.StatisticalFactory;

public class XMLDiscreteObservationLoader
extends SnapshotObservationBase {
    protected Integer fValue;

    public void initialize(HierarchyContext context, String elementName) {
        super.initialize(context, elementName);
        this.fValue = null;
    }

    public void addAttribute(String name, String value) {
        if (name.equals("value")) {
            this.fValue = Integer.valueOf(value);
        } else {
            super.addAttribute(name, value);
        }
    }

    protected void updateAttributes(SDDiscreteObservation observation) {
        super.updateAttributes(observation);
        observation.getValue().add((Object)this.fValue);
    }

    public void addYourselfInContext() {
        super.addYourselfInContext();
        if (this.mMemberDescriptor == null) {
            return;
        }
        SDDiscreteObservation discreteObservation = this.findDiscreteObservation(this.mMemberDescriptor);
        if (discreteObservation == null) {
            discreteObservation = StatisticalFactory.eINSTANCE.createSDDiscreteObservation();
            this.mMemberDescriptor.getSnapshotObservation().add((Object)discreteObservation);
        }
        this.updateAttributes(discreteObservation);
    }

    private SDDiscreteObservation findDiscreteObservation(SDMemberDescriptor descriptor) {
        Iterator iter = descriptor.getSnapshotObservation().iterator();
        while (iter.hasNext()) {
            SDSnapshotObservation element = (SDSnapshotObservation)iter.next();
            if (!(element instanceof SDDiscreteObservation)) continue;
            return (SDDiscreteObservation)element;
        }
        return null;
    }
}

