/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENamedElementImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;

public abstract class EClassifierImpl
extends ENamedElementImpl
implements EClassifier {
    protected int metaObjectID = -1;
    protected static final String INSTANCE_CLASS_NAME_EDEFAULT = null;
    protected String instanceClassName = INSTANCE_CLASS_NAME_EDEFAULT;
    protected static final Class INSTANCE_CLASS_EDEFAULT = null;
    protected Class instanceClass = INSTANCE_CLASS_EDEFAULT;
    static /* synthetic */ Class class$org$eclipse$emf$ecore$EPackage;

    protected EClassifierImpl() {
    }

    protected EClass eStaticClass() {
        return EcorePackage.eINSTANCE.getEClassifier();
    }

    public int getClassifierID() {
        return this.metaObjectID;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicAdd(otherEnd, msgs);
                }
                case 5: {
                    if (this.eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return this.eBasicSetContainer(otherEnd, 5, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicRemove(otherEnd, msgs);
                }
                case 5: {
                    return this.eBasicSetContainer(null, 5, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public void setClassifierID(int id) {
        this.metaObjectID = id;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isInstance(Object object) {
        if (object == null) return false;
        Class instanceClass = this.getInstanceClass();
        if (instanceClass != null) {
            if (!instanceClass.isPrimitive()) return instanceClass.isInstance(object);
            if (instanceClass == Boolean.TYPE) {
                return object instanceof Boolean;
            }
            if (instanceClass == Integer.TYPE) {
                return object instanceof Integer;
            }
            if (instanceClass == Float.TYPE) {
                return object instanceof Float;
            }
            if (instanceClass == Byte.TYPE) {
                return object instanceof Byte;
            }
            if (instanceClass == Character.TYPE) {
                return object instanceof Character;
            }
            if (instanceClass == Double.TYPE) {
                return object instanceof Double;
            }
            if (instanceClass == Short.TYPE) {
                return object instanceof Short;
            }
            if (instanceClass != Long.TYPE) return false;
            return object instanceof Long;
        }
        if (!(object instanceof EObject)) return false;
        return this.dynamicIsInstance((EObject)object);
    }

    protected boolean dynamicIsInstance(EObject eObject) {
        return eObject.eClass() == this;
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getEAnnotations();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getInstanceClassName();
            }
            case 3: {
                return this.getInstanceClass();
            }
            case 4: {
                return this.getDefaultValue();
            }
            case 5: {
                return this.getEPackage();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.eAnnotations != null && !this.eAnnotations.isEmpty();
            }
            case 1: {
                return ENamedElementImpl.NAME_EDEFAULT == null ? this.name != null : !ENamedElementImpl.NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return INSTANCE_CLASS_NAME_EDEFAULT == null ? this.instanceClassName != null : !INSTANCE_CLASS_NAME_EDEFAULT.equals(this.instanceClassName);
            }
            case 3: {
                return this.getInstanceClass() != null;
            }
            case 4: {
                return this.getDefaultValue() != null;
            }
            case 5: {
                return this.getEPackage() != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                this.getEAnnotations().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setInstanceClassName((String)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                return;
            }
            case 1: {
                this.setName(ENamedElementImpl.NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setInstanceClassName(INSTANCE_CLASS_NAME_EDEFAULT);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public String getInstanceClassName() {
        return this.instanceClassName;
    }

    public void setInstanceClassName(String value) {
        this.setInstanceClassNameGen(value);
        if (this.instanceClass != null) {
            this.setInstanceClassGen(null);
        }
    }

    public void setInstanceClassNameGen(String newInstanceClassName) {
        String oldInstanceClassName = this.instanceClassName;
        this.instanceClassName = newInstanceClassName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldInstanceClassName, (Object)this.instanceClassName));
        }
    }

    public Class getInstanceClass() {
        if (this.instanceClass == null && this.instanceClassName != null) {
            try {
                this.setInstanceClassGen(Class.forName(this.getInstanceClassName()));
            }
            catch (ClassNotFoundException e) {
                Class primitiveClass = this.getPrimitiveOrArrayClass();
                if (primitiveClass != null) {
                    this.setInstanceClassGen(primitiveClass);
                }
                throw new WrappedException((Exception)e);
            }
        }
        return this.getInstanceClassGen();
    }

    protected Class getPrimitiveOrArrayClass() {
        String className = this.getInstanceClassName();
        int arrayIndex = className.indexOf(91);
        if (arrayIndex != -1) {
            String componentClassName = className.substring(0, arrayIndex);
            StringBuffer result = new StringBuffer();
            do {
                result.append('[');
                ++arrayIndex;
            } while ((arrayIndex = className.indexOf(91, arrayIndex)) != -1);
            if (componentClassName.equals("boolean")) {
                result.append('Z');
            } else if (componentClassName.equals("byte")) {
                result.append('B');
            } else if (componentClassName.equals("char")) {
                result.append('C');
            } else if (componentClassName.equals("double")) {
                result.append('D');
            } else if (componentClassName.equals("float")) {
                result.append('F');
            } else if (componentClassName.equals("int")) {
                result.append('I');
            } else if (componentClassName.equals("long")) {
                result.append('J');
            } else if (componentClassName.equals("short")) {
                result.append('S');
            } else {
                result.append('L');
                result.append(componentClassName);
                result.append(';');
            }
            try {
                return Class.forName(result.toString());
            }
            catch (ClassNotFoundException e) {
            }
        } else {
            if (className.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (className.equals("byte")) {
                return Byte.TYPE;
            }
            if (className.equals("char")) {
                return Character.TYPE;
            }
            if (className.equals("double")) {
                return Double.TYPE;
            }
            if (className.equals("float")) {
                return Float.TYPE;
            }
            if (className.equals("int")) {
                return Integer.TYPE;
            }
            if (className.equals("long")) {
                return Long.TYPE;
            }
            if (className.equals("short")) {
                return Short.TYPE;
            }
        }
        return null;
    }

    public Class getInstanceClassGen() {
        return this.instanceClass;
    }

    public void setInstanceClass(Class value) {
        block5: {
            if (value == null) {
                this.setInstanceClassNameGen(null);
            } else {
                if (value.isArray()) {
                    String indices = "[]";
                    Class<?> component = value.getComponentType();
                    while (true) {
                        if (!component.isArray()) {
                            this.setInstanceClassNameGen(component.getName() + indices);
                            break block5;
                        }
                        indices = indices + "[]";
                        component = component.getComponentType();
                    }
                }
                this.setInstanceClassNameGen(value.getName());
            }
        }
        this.setInstanceClassGen(value);
    }

    public void setInstanceClassGen(Class newInstanceClass) {
        Class oldInstanceClass = this.instanceClass;
        this.instanceClass = newInstanceClass;
    }

    public Object getDefaultValue() {
        return null;
    }

    public EPackage getEPackage() {
        return this.eContainerFeatureID == 5 ? (EPackage)((Object)this.eContainer) : null;
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (instanceClassName: ");
        result.append(this.instanceClassName);
        result.append(')');
        return result.toString();
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (this.eContainerFeatureID >= 0) {
            switch (this.eContainerFeatureID) {
                case 5: {
                    return this.eContainer.eInverseRemove(this, 5, class$org$eclipse$emf$ecore$EPackage == null ? (class$org$eclipse$emf$ecore$EPackage = EClassifierImpl.class$("org.eclipse.emf.ecore.EPackage")) : class$org$eclipse$emf$ecore$EPackage, msgs);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(msgs);
        }
        return this.eContainer.eInverseRemove(this, -1 - this.eContainerFeatureID, null, msgs);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

