/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.Enumeration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticPage;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.part.IPage;

public class ExecutionStatisticViewer
extends TraceViewer {
    protected Action _openSource;
    protected Action _percentMode;
    protected Action _showRawTime;
    protected Action _showCompensatedTime;
    protected static final String _title = TraceUIPlugin.getString("STR_EXECUTION_FLOW_TABLE");

    public TraceViewerPage createPage(EObject mofObject) {
        return new ExecutionStatisticPage(mofObject, this);
    }

    public void dispose() {
        Enumeration pages = this._pages.elements();
        while (pages.hasMoreElements()) {
            IPage page = (IPage)pages.nextElement();
            if (!(page instanceof ExecutionStatisticPage)) continue;
            ((ExecutionStatisticPage)page).dispose();
        }
        this._openSource = null;
        this._percentMode = null;
        this._showCompensatedTime = null;
        this._showRawTime = null;
        super.dispose();
    }

    public void makeActions() {
        if (this.isInitializedMenu()) {
            return;
        }
        this.initializedMenu(true);
        String compTime = TraceUIPlugin.getString("STR_COMPENSATED_TIME");
        this._showCompensatedTime = new Action(compTime){

            public void run() {
                TraceUIPlugin.getDefault().getPreferenceStore().setValue("time_display", 0);
                TraceUIPlugin.getDefault().notifyTimeChangedEventListener();
            }
        };
        this._showCompensatedTime.setText(compTime);
        this._showCompensatedTime.setDescription(compTime);
        this._showCompensatedTime.setToolTipText(compTime);
        int ref = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
        this._showCompensatedTime.setChecked(ref == 0);
        String rawTime = TraceUIPlugin.getString("STR_RAW_TIME");
        this._showRawTime = new Action(rawTime){

            public void run() {
                TraceUIPlugin.getDefault().getPreferenceStore().setValue("time_display", 1);
                TraceUIPlugin.getDefault().notifyTimeChangedEventListener();
            }
        };
        this._showRawTime.setText(rawTime);
        this._showRawTime.setDescription(rawTime);
        this._showRawTime.setToolTipText(rawTime);
        ref = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
        this._showRawTime.setChecked(ref == 1);
        String strShowPercent = TraceUIPlugin.getString("SHOW_PERCENT");
        this._percentMode = new Action(strShowPercent){

            public void run() {
                ExecutionStatisticPage page = (ExecutionStatisticPage)ExecutionStatisticViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                page.getView().getShowPercentAction().run();
            }

            public int getStyle() {
                return 2;
            }
        };
        this._percentMode.setText(strShowPercent);
        TracePluginImages.setImageDescriptors((IAction)this._percentMode, "lcl16", "percentage_show.gif");
        this._percentMode.setDescription(strShowPercent);
        this._percentMode.setToolTipText(strShowPercent);
        this._percentMode.setEnabled(true);
        String openSourceStr = TraceUIPlugin.getString("STR_SOURCE");
        this._openSource = new Action(openSourceStr){

            public void run() {
                ExecutionStatisticPage page = (ExecutionStatisticPage)ExecutionStatisticViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                OpenSource.openSource(UIPlugin.getDefault().getSelectionModel(page.getMOFObject()).getFirstElement());
            }
        };
        this._openSource.setText(openSourceStr);
        TracePluginImages.setImageDescriptors((IAction)this._openSource, "tool16", "opensource_co.gif");
        this._openSource.setDescription(openSourceStr);
        this._openSource.setToolTipText(openSourceStr);
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        IMenuManager menu = this.getViewSite().getActionBars().getMenuManager();
        MenuManager submenu = new MenuManager(TraceUIPlugin.getString("STR_SHOW_TIME"));
        menu.add((IContributionItem)submenu);
        submenu.add((IAction)this._showCompensatedTime);
        submenu.add((IAction)this._showRawTime);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this._openSource);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this._percentMode);
        tbm.add((IContributionItem)new Separator());
        this.getViewSite().getActionBars().updateActionBars();
    }

    public Action percentMode() {
        return this._percentMode;
    }

    public Action baseTime() {
        return this._showCompensatedTime;
    }

    public Action rawTime() {
        return this._showRawTime;
    }

    public Action openSource() {
        return this._openSource;
    }

    public void setFocus() {
        if (this.getCurrentPage() != null) {
            ((ExecutionStatisticPage)this.getCurrentPage()).setFocus();
        }
    }

    public EObject getObjectToView(EObject selObject) {
        if (selObject == null) {
            return selObject;
        }
        if (selObject instanceof TRCProcessProxy) {
            int nbOfAgents = 0;
            TRCAgentProxy a = null;
            EList agents = ((TRCProcessProxy)selObject).getAgentProxies();
            for (int idx = 0; idx < agents.size(); ++idx) {
                TRCAgentProxy agent = (TRCAgentProxy)agents.get(idx);
                if (agent == null || agent.eIsProxy() || !agent.getType().equals("Profiler")) continue;
                ++nbOfAgents;
                a = agent;
            }
            if (nbOfAgents == 1) {
                return a;
            }
        }
        return selObject;
    }

    public String getViewTitle() {
        return _title;
    }
}

