/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.views.adapter.internal.InvocationTablePage;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.ITimeChangedListener;
import org.eclipse.hyades.trace.views.util.internal.PerftraceUtil;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class MethodInvocationStatistic
extends StatisticView
implements ITimeChangedListener {
    protected String tmpString;
    private int _drawMode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");

    protected Composite createTable(Composite parent, int options) {
        return new TableTree(parent, options);
    }

    public MethodInvocationStatistic(Composite parent, TraceViewerPage page) {
        super(parent, page);
        this._viewerFilter = new StatisticView.StatisticFilter(this);
        TraceUIPlugin.getDefault().addTimeChangedEventListener(this);
        this._viewerFilter = new ExecutionStatisticFilter();
    }

    public String getColumnsPreferencesKey() {
        return "MInv51";
    }

    public String getDefaultColumnsTemplate() {
        String executionColumn = TraceUIPlugin.getString("STR_INVOCATION_COL") + ":0:" + String.valueOf(7) + ":left:200," + TraceUIPlugin.getString("STR_ST_INSTANCE_INDEX") + ":1:" + String.valueOf(1) + ":left:200," + TraceUIPlugin.getString("TITLE_START_TIME") + ":2:" + String.valueOf(1) + ":right:100," + TraceUIPlugin.getString("TITLE_TIME_ON_STACK") + ":3:" + String.valueOf(1) + ":right:100";
        return executionColumn;
    }

    protected IContentProvider getContentProvider() {
        return new MethodStatisticContentProvider();
    }

    public LabelProvider getTableLabelProvider() {
        return new MethodStatisticLabelProvider(this);
    }

    public Table getTable() {
        return ((TableTree)this.getTableViewer().getControl()).getTable();
    }

    protected StructuredViewer createTableViewer(Composite table) {
        ExecutionTreeViewer tv = new ExecutionTreeViewer((TableTree)table);
        return tv;
    }

    protected void handleSelectionEvent() {
        Table table = ((TableTree)this.getTableViewer().getControl()).getTable();
        if (table != null && !table.isDisposed() && !table.isFocusControl()) {
            this.update();
        }
    }

    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this.getUpdateAction());
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this.getChooseColumnsAction(this.getColumnDataList(), this.getColumnsPreferencesKey()));
    }

    public void updateButtons() {
        ((InvocationTablePage)this.getTraceViewerPage()).percentMode().setChecked(this.isShowPercent());
    }

    protected void updateDetailsPane() {
        int selIndex = this.getTable().getSelectionIndex();
        if (selIndex < 0) {
            return;
        }
        TableItem item = this.getTable().getItem(selIndex);
        Object itemData = item.getData();
        if (itemData == null) {
            return;
        }
        if (itemData != null && itemData instanceof TableTreeItem) {
            itemData = ((TableTreeItem)itemData).getData();
        }
    }

    public void updateModelSelection() {
        ISelection selection = this.getTableViewer().getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            this.notifyViewSelectionChanged(this, sel);
        }
    }

    public void dispose() {
        super.dispose();
        TraceUIPlugin.getDefault().removeTimeChangedEventListener(this);
    }

    public void handleTimeChangedEvent() {
        Action base = ((InvocationTablePage)this.getTraceViewerPage()).baseTime();
        Action raw = ((InvocationTablePage)this.getTraceViewerPage()).rawTime();
        this._drawMode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
        if (base != null) {
            base.setChecked(this._drawMode == 0);
        }
        if (raw != null) {
            raw.setChecked(this._drawMode == 1);
        }
        String oldName = TraceUIPlugin.getString("TITLE_RAW_TIME_ON_STACK");
        String newName = TraceUIPlugin.getString("TITLE_TIME_ON_STACK");
        if (this._drawMode == 1) {
            newName = TraceUIPlugin.getString("TITLE_RAW_TIME_ON_STACK");
            oldName = TraceUIPlugin.getString("TITLE_TIME_ON_STACK");
        }
        Table table = this.getTable();
        for (int idx = table.getColumnCount(); idx > 0; --idx) {
            TableColumn col = table.getColumn(table.getColumnCount() - 1);
            StatisticTableColumnInfo staticTblColInfo = (StatisticTableColumnInfo)col.getData();
            String columnName = staticTblColInfo.getColumnData().name();
            if (!columnName.equals(oldName)) continue;
            staticTblColInfo.getColumnData().name(newName);
            if (staticTblColInfo.isSortColumn()) {
                newName = col.getText().substring(0, 1) + newName;
            }
            col.setText(newName);
        }
        this.getTableViewer().refresh();
    }

    public void update() {
        if (this._firstTime) {
            this.getTableViewer().addFilter((ViewerFilter)this.getViewerFilter());
            this._firstTime = false;
            Table table = this.getTable();
            TableColumn firstColumn = table.getColumn(0);
            this._viewerSorter = new MethodStatisticSorter();
            this.getViewerSorter().setSortedColumn(firstColumn);
            this.getTableViewer().setSorter((ViewerSorter)this.getViewerSorter());
        }
        this.getTableViewer().setInput((Object)this._page.getMOFObject());
        this.getTable().setRedraw(false);
        this.getTableViewer().refresh();
        this.getTable().setRedraw(true);
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event) {
        Object source = event.getSource();
        if (source != this) {
            this.handleSelectionEvent();
        }
    }

    public boolean isEmpty() {
        int size = 0;
        ITraceSelection selModel = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (selModel.size() > 0) {
            Object obj = selModel.getFirstElement();
            if (obj instanceof TRCMethod) {
                size = ((TRCMethod)obj).getInvocations().toArray().length;
            }
            if (obj instanceof TRCMethodInvocation) {
                size = ((TRCMethodInvocation)obj).getMethod().getInvocations().toArray().length;
            }
        }
        return size <= 0;
    }

    class ExecutionTreeViewer
    extends TableTreeViewer {
        public ExecutionTreeViewer(Composite parent) {
            super(parent);
        }

        public ExecutionTreeViewer(TableTree table) {
            super(table);
        }

        public void expandItem(TableTreeItem item) {
            item.setExpanded(true);
            this.createChildren((Widget)item);
        }
    }

    public class MethodStatisticLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected StatisticView _viewer;

        public MethodStatisticLabelProvider(StatisticView viewer) {
            this._viewer = viewer;
        }

        public Image getColumnImage(Object obj, int col) {
            return null;
        }

        public String getColumnText(Object obj, int col) {
            int pos = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col)).getColumnData().getInitalPos();
            switch (pos) {
                case 0: {
                    return ((TRCMethodInvocation)obj).getMethod().getName();
                }
                case 1: {
                    TRCClass tmpClass = PerftraceUtil.getClass((TRCMethodInvocation)obj);
                    return tmpClass.getName() + "." + ((TRCMethodInvocation)obj).getOwningObject().getId();
                }
                case 2: {
                    if (obj instanceof TRCFullMethodInvocation) {
                        return PerftraceUtil.formatTimeValue(((TRCFullMethodInvocation)obj).getEntryTime());
                    }
                    return "";
                }
                case 3: {
                    if (!(obj instanceof TRCFullMethodInvocation)) break;
                    TRCFullMethodInvocation inv = (TRCFullMethodInvocation)obj;
                    double start = inv.getEntryTime();
                    double end = inv.getExitTime();
                    double overhead = inv.getOverhead();
                    if (end == 0.0) {
                        end = inv.getOwningObject().getProcess().getLastEventTime();
                    }
                    if (MethodInvocationStatistic.this._drawMode == 0) {
                        return PerftraceUtil.formatTimeValue(end - start - overhead);
                    }
                    return PerftraceUtil.formatTimeValue(end - start);
                }
            }
            return "";
        }
    }

    public class MethodStatisticContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public Object getParent(Object element) {
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            MethodInvocationStatistic.this.tmpList.clear();
            ITraceSelection selModel = UIPlugin.getDefault().getSelectionModel(MethodInvocationStatistic.this._page.getMOFObject());
            if (selModel.size() > 0) {
                Object obj = selModel.getFirstElement();
                if (obj instanceof TRCMethod) {
                    return ((TRCMethod)obj).getInvocations().toArray();
                }
                if (obj instanceof TRCMethodInvocation) {
                    return ((TRCMethodInvocation)obj).getMethod().getInvocations().toArray();
                }
            }
            return MethodInvocationStatistic.this.tmpList.toArray();
        }

        public Object[] getChildren(Object element) {
            MethodInvocationStatistic.this.tmpList.clear();
            Object[] segments = ((TRCMethodInvocation)element).getInvokes().toArray();
            for (int idx = 0; idx < segments.length; ++idx) {
                MethodInvocationStatistic.this.tmpList.add((TRCMethodInvocation)segments[idx]);
            }
            return MethodInvocationStatistic.this.tmpList.toArray();
        }

        public boolean hasChildren(Object element) {
            return ((TRCMethodInvocation)element).getInvokes().size() > 0;
        }
    }

    public class MethodStatisticSorter
    extends StatisticView.StatisticSorter {
        public MethodStatisticSorter() {
            super(MethodInvocationStatistic.this);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            double d = 0.0;
            switch (this._pos) {
                case 0: {
                    return this._sortSequence * ((TRCMethodInvocation)e1).getMethod().getName().compareToIgnoreCase(((TRCMethodInvocation)e2).getMethod().getName());
                }
                case 1: {
                    TRCClass tmpClass = PerftraceUtil.getClass((TRCMethodInvocation)e1);
                    TRCTraceObject tmpObject = ((TRCMethodInvocation)e1).getOwningObject();
                    MethodInvocationStatistic.this.tmpString = tmpClass.getName() + "." + tmpObject.getId();
                    tmpObject = ((TRCMethodInvocation)e2).getOwningObject();
                    tmpClass = PerftraceUtil.getClass((TRCMethodInvocation)e2);
                    return this._sortSequence * MethodInvocationStatistic.this.tmpString.compareToIgnoreCase(tmpClass.getName() + "." + tmpObject.getId());
                }
                case 2: {
                    if (e1 instanceof TRCFullMethodInvocation && e2 instanceof TRCFullMethodInvocation) {
                        d = ((TRCFullMethodInvocation)e1).getEntryTime() - ((TRCFullMethodInvocation)e2).getEntryTime();
                    }
                    if (d < 0.0) {
                        return -1 * this._sortSequence;
                    }
                    if (d > 0.0) {
                        return this._sortSequence;
                    }
                    return 0;
                }
                case 3: {
                    if (!(e1 instanceof TRCFullMethodInvocation) || !(e2 instanceof TRCFullMethodInvocation)) {
                        return 0;
                    }
                    TRCFullMethodInvocation tmpInv = (TRCFullMethodInvocation)e1;
                    double start = tmpInv.getEntryTime();
                    double end = tmpInv.getExitTime();
                    if (end == 0.0) {
                        end = tmpInv.getOwningObject().getProcess().getLastEventTime();
                    }
                    d = end - start;
                    tmpInv = (TRCFullMethodInvocation)e2;
                    start = tmpInv.getEntryTime();
                    end = tmpInv.getExitTime();
                    if (end == 0.0) {
                        end = tmpInv.getOwningObject().getProcess().getLastEventTime();
                    }
                    if ((d -= end - start) < 0.0) {
                        return -1 * this._sortSequence;
                    }
                    if (d > 0.0) {
                        return this._sortSequence;
                    }
                    return 0;
                }
            }
            return 0;
        }
    }

    public class ExecutionStatisticFilter
    extends StatisticView.StatisticFilter {
        public ExecutionStatisticFilter() {
            super(MethodInvocationStatistic.this);
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean flag = true;
            if (!(element instanceof TRCMethodInvocation)) {
                return true;
            }
            String compareText = "";
            compareText = ((TRCMethodInvocation)element).getMethod().getName();
            if (compareText.equals("")) {
                compareText = TraceUIPlugin.getString("DEFAULT_PACKAGE");
            }
            if (this._noPattern) {
                return true;
            }
            if (!this._caseSensitive) {
                compareText = compareText.toLowerCase();
            }
            if (this._exactMatch) {
                return compareText.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                flag = compareText.startsWith(this._prefix);
            }
            if (flag && this._suffix != "") {
                flag = compareText.endsWith(this._suffix);
            }
            if (flag) {
                for (int k = 0; k < this._textList.size(); ++k) {
                    String str1 = (String)this._textList.get(k);
                    int index = compareText.lastIndexOf(str1);
                    if (index == -1) {
                        flag = false;
                        break;
                    }
                    compareText = compareText.substring(index + str1.length());
                }
            }
            return flag;
        }
    }
}

