/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.models.trace.TRCAggregatedObjectReference;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.security.util.TString;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.views.adapter.internal.ReferenceTablePage;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.IRefChangedListener;
import org.eclipse.hyades.trace.views.util.internal.PerftraceUtil;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ReferenceTable
extends StatisticView
implements IRefChangedListener {
    protected int _drawmode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("obj_ref_display");

    protected Composite createTable(Composite parent, int options) {
        return new TableTree(parent, options);
    }

    public ReferenceTable(Composite parent, TraceViewerPage page) {
        super(parent, page);
        this._viewerFilter = new ClassStatisticFilter();
        TraceUIPlugin.getDefault().addRefChangedEventListener(this);
    }

    public String getColumnsPreferencesKey() {
        return "Ref63";
    }

    public String getDefaultColumnsTemplate() {
        this._drawmode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("obj_ref_display");
        String name = TraceUIPlugin.getString("STR_REFEREE");
        if (this.showReferTo()) {
            name = TraceUIPlugin.getString("STR_REFERANDS");
        }
        String executionColumn = name + ":0:" + String.valueOf(7) + ":left:200," + TraceUIPlugin.getString("STR_ST_PACKAGE") + ":1:" + String.valueOf(1) + ":left:150," + TraceUIPlugin.getString("STR_REF_SIZE") + ":2:" + String.valueOf(1) + ":right:100," + TraceUIPlugin.getString("STR_NB_REF") + ":3:" + String.valueOf(1) + ":left:170," + TraceUIPlugin.getString("STR_OBJ_REF_DETAIL") + ":4:" + String.valueOf(1) + ":left:350";
        return executionColumn;
    }

    protected IContentProvider getContentProvider() {
        return new ObjReferenceContentProvider();
    }

    public LabelProvider getTableLabelProvider() {
        return new ObjReferenceLabelProvider(this);
    }

    public Table getTable() {
        return ((TableTree)this.getTableViewer().getControl()).getTable();
    }

    protected StructuredViewer createTableViewer(Composite table) {
        ReferenceTreeViewer tv = new ReferenceTreeViewer((TableTree)table);
        return tv;
    }

    protected void handleSelectionEvent() {
        ((ReferenceTablePage)this.getTraceViewerPage()).openSource().setEnabled(false);
        ITraceSelection model = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (model.size() > 0) {
            Object sel = model.getFirstElement();
            if (!(sel instanceof TRCPackage)) {
                ((ReferenceTablePage)this.getTraceViewerPage()).openSource().setEnabled(true);
            }
            this.select(sel);
            if (sel instanceof TRCObject) {
                sel = ((TRCObject)sel).getIsA();
            } else if (sel instanceof TRCClass) {
                this.select((TRCClass)sel);
            }
        }
    }

    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this.getUpdateAction());
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this.getChooseColumnsAction(this.getColumnDataList(), this.getColumnsPreferencesKey()));
    }

    private void select(Object sel) {
        TRCClass cls = null;
        TRCObject obj = null;
        if (sel instanceof TRCClass) {
            cls = (TRCClass)sel;
        } else if (sel instanceof TRCObject) {
            obj = (TRCObject)sel;
            cls = obj.getIsA();
        }
        if (cls == null) {
            return;
        }
        TableTree table = (TableTree)this.getTableViewer().getControl();
        TableTreeItem[] items = table.getItems();
        for (int idx = 0; idx < items.length; ++idx) {
            TableTreeItem item = items[idx];
            if (!item.getData().equals(cls)) continue;
            ((ReferenceTreeViewer)this.getTableViewer()).expandItem(item);
            if (obj == null) {
                table.setSelection(new TableTreeItem[]{item});
                this.setNewSelection();
                return;
            }
            TableTreeItem[] childItems = item.getItems();
            for (int i = 0; i < childItems.length; ++i) {
                TableTreeItem childItem = childItems[i];
                if (!childItem.getData().equals(obj)) continue;
                table.setSelection(new TableTreeItem[]{childItem});
                this.setNewSelection();
                return;
            }
        }
    }

    public void updateButtons() {
    }

    protected void updateDetailsPane() {
        int selIndex = this.getTable().getSelectionIndex();
        if (selIndex < 0) {
            return;
        }
        TableItem item = this.getTable().getItem(selIndex);
        Object itemData = item.getData();
        if (itemData == null) {
            return;
        }
        if (itemData != null && itemData instanceof TableTreeItem) {
            itemData = ((TableTreeItem)itemData).getData();
        }
    }

    public void updateModelSelection() {
        ISelection selection = this.getTableViewer().getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object itemData = ((IStructuredSelection)selection).getFirstElement();
            if (itemData instanceof TRCObjectReference) {
                itemData = this.showReferTo() ? ((TRCObjectReference)itemData).getOwner() : ((TRCObjectReference)itemData).getTarget();
            }
            this.notifyViewSelectionChanged(this, itemData);
        }
    }

    public void update() {
        this._drawmode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("obj_ref_display");
        if (this._firstTime) {
            this.getTableViewer().addFilter((ViewerFilter)this.getViewerFilter());
            this._firstTime = false;
            Table table = this.getTable();
            table.setLinesVisible(false);
            TableColumn firstColumn = table.getColumn(0);
            this._viewerSorter = new ObjReferenceSorter();
            this.getViewerSorter().setSortedColumn(firstColumn);
            this.getTableViewer().setSorter((ViewerSorter)this.getViewerSorter());
        }
        this.getTableViewer().setInput((Object)this._page.getMOFObject());
        this.getTableViewer().refresh();
        this.handleSelectionEvent();
    }

    public void dispose() {
        TraceUIPlugin.getDefault().removeRefChangedEventListener(this);
        super.dispose();
    }

    public void handleRefChangedEvent() {
        this._drawmode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("obj_ref_display");
        Table table = this.getTable();
        TableColumn firstColumn = table.getColumn(0);
        String text = firstColumn.getText();
        String name = TraceUIPlugin.getString("STR_REFEREE");
        if (this.showReferTo()) {
            name = TraceUIPlugin.getString("STR_REFERANDS");
        }
        if (text.startsWith(">") || text.startsWith("<")) {
            firstColumn.setText(text.substring(0, 1) + name);
        } else {
            firstColumn.setText(name);
        }
        Action referands = ((ReferenceTablePage)this.getTraceViewerPage()).referands();
        Action referee = ((ReferenceTablePage)this.getTraceViewerPage()).referee();
        int ref = TraceUIPlugin.getDefault().getPreferenceStore().getInt("obj_ref_display");
        if (referands != null) {
            referands.setChecked(ref == 0);
        }
        if (referee != null) {
            referee.setChecked(ref == 1);
        }
        this.update();
    }

    private boolean showReferTo() {
        return this._drawmode == 0;
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event) {
        Object source = event.getSource();
        if (source != this) {
            this.handleSelectionEvent();
        }
    }

    public boolean isEmpty() {
        return PerftraceUtil.getAllClasses(this._page.getMOFObject()).length <= 0;
    }

    class ReferenceTreeViewer
    extends TableTreeViewer {
        public ReferenceTreeViewer(Composite parent) {
            super(parent);
        }

        public ReferenceTreeViewer(TableTree table) {
            super(table);
        }

        public void expandItem(TableTreeItem item) {
            item.setExpanded(true);
            this.createChildren((Widget)item);
        }
    }

    public class ObjReferenceLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected StatisticView _viewer;

        public ObjReferenceLabelProvider(StatisticView viewer) {
            this._viewer = viewer;
        }

        public Image getColumnImage(Object obj, int col) {
            return null;
        }

        public String getColumnText(Object obj, int col) {
            int pos = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col)).getColumnData().getInitalPos();
            if (obj instanceof TRCClass) {
                switch (pos) {
                    case 0: {
                        return ((TRCClass)obj).getName();
                    }
                    case 1: {
                        return PerftraceUtil.getPackageName(((TRCClass)obj).getPackage(), ReferenceTable.this._page.getMOFObject()).toString();
                    }
                    case 2: {
                        return String.valueOf(((TRCClass)obj).getTotalSize() - ((TRCClass)obj).getCollectedSize());
                    }
                    case 3: {
                        return "";
                    }
                }
            } else if (obj instanceof TRCHeapObject) {
                TRCHeapObject object = (TRCHeapObject)obj;
                switch (pos) {
                    case 0: {
                        TRCClass clas = PerftraceUtil.getClass((TRCObject)object);
                        if (clas == object.getIsA()) {
                            return clas.getName() + "." + object.getId();
                        }
                        return clas.getName();
                    }
                    case 1: {
                        return PerftraceUtil.getPackageName(PerftraceUtil.getClass((TRCObject)object).getPackage(), ReferenceTable.this._page.getMOFObject()).toString();
                    }
                    case 2: {
                        int size = object.getSize();
                        if (size != 0) {
                            return String.valueOf(size);
                        }
                        if (ReferenceTable.this.showReferTo()) {
                            if (object.getRefTarget().size() > 0 && object.getRefTarget().get(0) instanceof TRCAggregatedObjectReference) {
                                return String.valueOf(((TRCAggregatedObjectReference)object.getRefTarget().get(0)).getTargetSize());
                            }
                            TRCClass clas = PerftraceUtil.getClass((TRCObject)object);
                            int instSize = clas.getTotalInstances();
                            if (instSize == 0) {
                                instSize = 1;
                            }
                            return String.valueOf(clas.getTotalSize() / instSize);
                        }
                        if (object.getRefOwner().size() > 0 && object.getRefOwner().get(0) instanceof TRCAggregatedObjectReference) {
                            return String.valueOf(((TRCAggregatedObjectReference)object.getRefOwner().get(0)).getOwnerSize());
                        }
                        TRCClass clas = PerftraceUtil.getClass((TRCObject)object);
                        int instSize = clas.getTotalInstances();
                        if (instSize == 0) {
                            instSize = 1;
                        }
                        return String.valueOf(clas.getTotalSize() / instSize);
                    }
                    case 3: {
                        if (ReferenceTable.this.showReferTo()) {
                            int nb = 0;
                            int size = ((TRCHeapObject)obj).getRefTarget().size();
                            for (int idx = 0; idx < size; ++idx) {
                                if (object.getRefTarget().get(idx) instanceof TRCAggregatedObjectReference) {
                                    nb += ((TRCAggregatedObjectReference)object.getRefTarget().get(idx)).getCount();
                                    continue;
                                }
                                ++nb;
                            }
                            if (nb > 0) {
                                return TString.change((String)TraceUIPlugin.getString("REF_BY_DETAIL"), (String)"%1", (String)String.valueOf(nb));
                            }
                            return "";
                        }
                        int nb = 0;
                        int size = ((TRCHeapObject)obj).getRefOwner().size();
                        for (int idx = 0; idx < size; ++idx) {
                            if (object.getRefOwner().get(idx) instanceof TRCAggregatedObjectReference) {
                                nb += ((TRCAggregatedObjectReference)object.getRefOwner().get(idx)).getCount();
                                continue;
                            }
                            ++nb;
                        }
                        if (nb > 0) {
                            return TString.change((String)TraceUIPlugin.getString("REF_TO_DETAIL"), (String)"%1", (String)String.valueOf(nb));
                        }
                        return "";
                    }
                }
            } else {
                TRCObjectReference ref = (TRCObjectReference)obj;
                switch (pos) {
                    case 0: {
                        TRCHeapObject object = null;
                        object = ReferenceTable.this.showReferTo() ? ref.getOwner() : ref.getTarget();
                        TRCClass clas = PerftraceUtil.getClass((TRCObject)object);
                        if (clas == object.getIsA()) {
                            return clas.getName() + "." + object.getId();
                        }
                        return clas.getName();
                    }
                    case 1: {
                        TRCHeapObject object = null;
                        object = ReferenceTable.this.showReferTo() ? ref.getOwner() : ref.getTarget();
                        return PerftraceUtil.getPackageName(PerftraceUtil.getClass((TRCObject)object).getPackage(), ReferenceTable.this._page.getMOFObject()).toString();
                    }
                    case 2: {
                        int size = 0;
                        size = ref instanceof TRCAggregatedObjectReference ? (ReferenceTable.this.showReferTo() ? ((TRCAggregatedObjectReference)ref).getOwnerSize() : ((TRCAggregatedObjectReference)ref).getTargetSize()) : (ReferenceTable.this.showReferTo() ? ref.getOwner().getSize() : ref.getTarget().getSize());
                        return String.valueOf(size);
                    }
                    case 3: {
                        if (ReferenceTable.this.showReferTo()) {
                            int nb = 0;
                            Object[] list = ref.getOwner().getRefTarget().toArray();
                            int size = list.length;
                            for (int idx = 0; idx < size; ++idx) {
                                if (list[idx] instanceof TRCAggregatedObjectReference) {
                                    nb += ((TRCAggregatedObjectReference)list[idx]).getCount();
                                    continue;
                                }
                                ++nb;
                            }
                            if (nb > 0) {
                                return TString.change((String)TraceUIPlugin.getString("REF_BY_DETAIL"), (String)"%1", (String)String.valueOf(nb));
                            }
                            return "";
                        }
                        int nb = 0;
                        Object[] list = ref.getTarget().getRefOwner().toArray();
                        int size = list.length;
                        for (int idx = 0; idx < size; ++idx) {
                            if (list[idx] instanceof TRCAggregatedObjectReference) {
                                nb += ((TRCAggregatedObjectReference)list[idx]).getCount();
                                continue;
                            }
                            ++nb;
                        }
                        if (nb > 0) {
                            return TString.change((String)TraceUIPlugin.getString("REF_TO_DETAIL"), (String)"%1", (String)String.valueOf(nb));
                        }
                        return "";
                    }
                    case 4: {
                        int size;
                        if (ReferenceTable.this.showReferTo()) {
                            int size2;
                            if (ref instanceof TRCAggregatedObjectReference && (size2 = ((TRCAggregatedObjectReference)ref).getCount()) > 1) {
                                return TString.change((String)TString.change((String)TraceUIPlugin.getString("REF_BY_DET1"), (String)"%1", (String)String.valueOf(size2)), (String)"%2", (String)PerftraceUtil.getClass((TRCObject)ref.getTarget()).getName());
                            }
                            return "";
                        }
                        if (ref instanceof TRCAggregatedObjectReference && (size = ((TRCAggregatedObjectReference)ref).getCount()) > 1) {
                            return TString.change((String)TString.change((String)TraceUIPlugin.getString("REF_TO_DET1"), (String)"%1", (String)PerftraceUtil.getClass((TRCObject)((TRCAggregatedObjectReference)obj).getOwner()).getName()), (String)"%2", (String)String.valueOf(size));
                        }
                        return "";
                    }
                }
            }
            return "";
        }
    }

    public class ObjReferenceContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public Object getParent(Object element) {
            if (element instanceof TRCClass) {
                return null;
            }
            if (element instanceof TRCHeapObject) {
                return ((TRCHeapObject)element).getIsA();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return PerftraceUtil.getAllClasses(ReferenceTable.this._page.getMOFObject());
        }

        public Object[] getChildren(Object element) {
            ReferenceTable.this.tmpList.clear();
            if (ReferenceTable.this.showReferTo()) {
                if (element instanceof TRCClass) {
                    TRCHeapObject obj = null;
                    Object[] classObjects = ((TRCClass)element).getClassObjects().toArray();
                    for (int idx = 0; idx < classObjects.length; ++idx) {
                        TRCObject tmpObject = (TRCObject)classObjects[idx];
                        if (!(tmpObject instanceof TRCHeapObject)) continue;
                        obj = (TRCHeapObject)tmpObject;
                        break;
                    }
                    if (obj != null && obj.getRefTarget().size() > 0) {
                        ReferenceTable.this.tmpList.add(obj);
                    }
                    Object[] objects = ((TRCClass)element).getObjects().toArray();
                    for (int idx = 0; idx < objects.length; ++idx) {
                        TRCObject tmpObject = (TRCObject)objects[idx];
                        if (!(tmpObject instanceof TRCHeapObject) || ((TRCHeapObject)tmpObject).getRefTarget().size() <= 0) continue;
                        ReferenceTable.this.tmpList.add(tmpObject);
                    }
                } else if (element instanceof TRCHeapObject) {
                    ReferenceTable.this.tmpList.addAll(((TRCHeapObject)element).getRefTarget());
                } else {
                    ReferenceTable.this.tmpList.addAll(((TRCObjectReference)element).getOwner().getRefTarget());
                }
            } else if (element instanceof TRCClass) {
                TRCHeapObject obj = null;
                Object[] classObjects = ((TRCClass)element).getClassObjects().toArray();
                for (int idx = 0; idx < classObjects.length; ++idx) {
                    TRCObject tmpObject = (TRCObject)classObjects[idx];
                    if (!(tmpObject instanceof TRCHeapObject)) continue;
                    obj = (TRCHeapObject)tmpObject;
                    break;
                }
                if (obj != null && obj.getRefOwner().size() > 0) {
                    ReferenceTable.this.tmpList.add(obj);
                }
                Object[] objects = ((TRCClass)element).getObjects().toArray();
                for (int idx = 0; idx < objects.length; ++idx) {
                    TRCObject tmpObject = (TRCObject)objects[idx];
                    if (!(tmpObject instanceof TRCHeapObject) || tmpObject.getIsA() != element || ((TRCHeapObject)tmpObject).getRefOwner().size() <= 0) continue;
                    ReferenceTable.this.tmpList.add(objects[idx]);
                }
            } else if (element instanceof TRCHeapObject) {
                ReferenceTable.this.tmpList.addAll(((TRCHeapObject)element).getRefOwner());
            } else {
                ReferenceTable.this.tmpList.addAll(((TRCObjectReference)element).getTarget().getRefOwner());
            }
            return ReferenceTable.this.tmpList.toArray();
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }

    public class ObjReferenceSorter
    extends StatisticView.StatisticSorter {
        public ObjReferenceSorter() {
            super(ReferenceTable.this);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof TRCClass) {
                switch (this._pos) {
                    case 0: {
                        return this._sortSequence * ((TRCClass)e1).getName().compareToIgnoreCase(((TRCClass)e2).getName());
                    }
                    case 1: {
                        return this._sortSequence * ((TRCClass)e1).getPackage().getName().compareToIgnoreCase(((TRCClass)e2).getPackage().getName());
                    }
                    case 2: {
                        TRCClass c1 = (TRCClass)e1;
                        TRCClass c2 = (TRCClass)e2;
                        return this._sortSequence * (c1.getTotalSize() - c1.getCollectedSize() - (c2.getTotalSize() - c2.getCollectedSize()));
                    }
                    case 3: {
                        return 0;
                    }
                }
            } else if (e1 instanceof TRCHeapObject) {
                TRCHeapObject object1 = (TRCHeapObject)e1;
                TRCHeapObject object2 = (TRCHeapObject)e2;
                switch (this._pos) {
                    case 0: {
                        TRCClass clas = object1.getIsA();
                        String name1 = PerftraceUtil.getClass((TRCObject)object1).getName();
                        String name2 = PerftraceUtil.getClass((TRCObject)object2).getName();
                        return this._sortSequence * name1.compareToIgnoreCase(name2);
                    }
                    case 1: {
                        String name1 = PerftraceUtil.getClass((TRCObject)object1).getPackage().getName();
                        String name2 = PerftraceUtil.getClass((TRCObject)object2).getPackage().getName();
                        return this._sortSequence * name1.compareToIgnoreCase(name2);
                    }
                    case 2: {
                        int size1 = 0;
                        int size2 = 0;
                        if (ReferenceTable.this.showReferTo()) {
                            TRCObjectReference tmpRef;
                            int idx;
                            Object[] refs = object1.getRefTarget().toArray();
                            for (idx = 0; idx < refs.length; ++idx) {
                                tmpRef = (TRCObjectReference)refs[idx];
                                if (tmpRef instanceof TRCAggregatedObjectReference) {
                                    size1 += ((TRCAggregatedObjectReference)tmpRef).getTargetSize();
                                    continue;
                                }
                                size1 += tmpRef.getTarget().getSize();
                            }
                            refs = object2.getRefTarget().toArray();
                            for (idx = 0; idx < refs.length; ++idx) {
                                tmpRef = (TRCObjectReference)refs[idx];
                                if (tmpRef instanceof TRCAggregatedObjectReference) {
                                    size2 += ((TRCAggregatedObjectReference)tmpRef).getTargetSize();
                                    continue;
                                }
                                size2 += tmpRef.getTarget().getSize();
                            }
                        } else {
                            int idx;
                            Object[] refs = object1.getRefOwner().toArray();
                            for (idx = 0; idx < refs.length; ++idx) {
                                if (!(refs[idx] instanceof TRCAggregatedObjectReference)) continue;
                                size1 += ((TRCAggregatedObjectReference)refs[idx]).getOwnerSize();
                            }
                            refs = object2.getRefOwner().toArray();
                            for (idx = 0; idx < refs.length; ++idx) {
                                if (!(refs[idx] instanceof TRCAggregatedObjectReference)) continue;
                                size2 += ((TRCAggregatedObjectReference)refs[idx]).getOwnerSize();
                            }
                        }
                        return this._sortSequence * (size1 - size2);
                    }
                    case 3: {
                        int size;
                        int idx;
                        int size2;
                        int nb1 = 0;
                        if (ReferenceTable.this.showReferTo()) {
                            size2 = object1.getRefTarget().size();
                            for (idx = 0; idx < size2; ++idx) {
                                if (object1.getRefTarget().get(idx) instanceof TRCAggregatedObjectReference) {
                                    nb1 += ((TRCAggregatedObjectReference)object1.getRefTarget().get(idx)).getCount();
                                    continue;
                                }
                                ++nb1;
                            }
                        } else {
                            size2 = object1.getRefOwner().size();
                            for (idx = 0; idx < size2; ++idx) {
                                if (object1.getRefOwner().get(idx) instanceof TRCAggregatedObjectReference) {
                                    nb1 += ((TRCAggregatedObjectReference)object1.getRefOwner().get(idx)).getCount();
                                    continue;
                                }
                                ++nb1;
                            }
                        }
                        int nb2 = 0;
                        if (ReferenceTable.this.showReferTo()) {
                            size = object2.getRefTarget().size();
                            for (int idx2 = 0; idx2 < size; ++idx2) {
                                if (object2.getRefTarget().get(idx2) instanceof TRCAggregatedObjectReference) {
                                    nb2 += ((TRCAggregatedObjectReference)object2.getRefTarget().get(idx2)).getCount();
                                    continue;
                                }
                                ++nb2;
                            }
                        } else {
                            size = object2.getRefOwner().size();
                            for (int idx3 = 0; idx3 < size; ++idx3) {
                                if (object2.getRefOwner().get(idx3) instanceof TRCAggregatedObjectReference) {
                                    nb2 += ((TRCAggregatedObjectReference)object2.getRefOwner().get(idx3)).getCount();
                                    continue;
                                }
                                ++nb2;
                            }
                        }
                        return this._sortSequence * (nb1 - nb2);
                    }
                }
            } else {
                TRCObjectReference ref1 = (TRCObjectReference)e1;
                TRCObjectReference ref2 = (TRCObjectReference)e2;
                switch (this._pos) {
                    case 0: {
                        TRCHeapObject object = ref1.getTarget();
                        object = ReferenceTable.this.showReferTo() ? ref1.getOwner() : ref1.getTarget();
                        TRCClass clas = PerftraceUtil.getClass((TRCObject)object);
                        String name1 = clas.getName();
                        name1 = clas == object.getProcess().getClassClass() ? clas.getName() : clas.getName() + "." + object.getId();
                        object = ref2.getTarget();
                        object = ReferenceTable.this.showReferTo() ? ref2.getOwner() : ref2.getTarget();
                        clas = PerftraceUtil.getClass((TRCObject)object);
                        String name2 = clas.getName();
                        name2 = clas == object.getProcess().getClassClass() ? clas.getName() : clas.getName() + "." + object.getId();
                        return this._sortSequence * name1.compareToIgnoreCase(name2);
                    }
                    case 1: {
                        TRCHeapObject object = ref1.getTarget();
                        object = ReferenceTable.this.showReferTo() ? ref1.getOwner() : ref1.getTarget();
                        String name1 = PerftraceUtil.getClass((TRCObject)object).getPackage().getName();
                        object = ref2.getTarget();
                        object = ReferenceTable.this.showReferTo() ? ref2.getOwner() : ref2.getTarget();
                        String name2 = PerftraceUtil.getClass((TRCObject)object).getPackage().getName();
                        return this._sortSequence * name1.compareToIgnoreCase(name2);
                    }
                    case 2: {
                        int size1 = 0;
                        int size2 = 0;
                        if (ReferenceTable.this.showReferTo()) {
                            TRCObjectReference tmpRef;
                            int idx;
                            Object[] refs = ref1.getOwner().getRefTarget().toArray();
                            for (idx = 0; idx < refs.length; ++idx) {
                                tmpRef = (TRCObjectReference)refs[idx];
                                if (tmpRef instanceof TRCAggregatedObjectReference) {
                                    size1 += ((TRCAggregatedObjectReference)tmpRef).getTargetSize();
                                    continue;
                                }
                                size1 += tmpRef.getTarget().getSize();
                            }
                            refs = ref2.getOwner().getRefTarget().toArray();
                            for (idx = 0; idx < refs.length; ++idx) {
                                tmpRef = (TRCObjectReference)refs[idx];
                                if (tmpRef instanceof TRCAggregatedObjectReference) {
                                    size2 += ((TRCAggregatedObjectReference)tmpRef).getTargetSize();
                                    continue;
                                }
                                size2 += tmpRef.getTarget().getSize();
                            }
                        } else {
                            TRCObjectReference tmpRef;
                            int idx;
                            Object[] refs = ref1.getTarget().getRefOwner().toArray();
                            for (idx = 0; idx < refs.length; ++idx) {
                                tmpRef = (TRCObjectReference)refs[idx];
                                if (tmpRef instanceof TRCAggregatedObjectReference) {
                                    size1 += ((TRCAggregatedObjectReference)tmpRef).getOwnerSize();
                                    continue;
                                }
                                size1 += tmpRef.getOwner().getSize();
                            }
                            refs = ref2.getTarget().getRefOwner().toArray();
                            for (idx = 0; idx < refs.length; ++idx) {
                                tmpRef = (TRCObjectReference)refs[idx];
                                if (tmpRef instanceof TRCAggregatedObjectReference) {
                                    size2 += ((TRCAggregatedObjectReference)tmpRef).getOwnerSize();
                                    continue;
                                }
                                size2 += tmpRef.getOwner().getSize();
                            }
                        }
                        return this._sortSequence * (size1 - size2);
                    }
                    case 3: {
                        int size;
                        int idx;
                        int size3;
                        int nb1 = 0;
                        if (ReferenceTable.this.showReferTo()) {
                            size3 = ref1.getOwner().getRefTarget().size();
                            for (idx = 0; idx < size3; ++idx) {
                                if (ref1.getOwner().getRefTarget().get(idx) instanceof TRCAggregatedObjectReference) {
                                    nb1 += ((TRCAggregatedObjectReference)ref1.getOwner().getRefTarget().get(idx)).getCount();
                                    continue;
                                }
                                ++nb1;
                            }
                        } else {
                            size3 = ref1.getTarget().getRefOwner().size();
                            for (idx = 0; idx < size3; ++idx) {
                                if (ref1.getTarget().getRefOwner().get(idx) instanceof TRCAggregatedObjectReference) {
                                    nb1 += ((TRCAggregatedObjectReference)ref1.getTarget().getRefOwner().get(idx)).getCount();
                                    continue;
                                }
                                ++nb1;
                            }
                        }
                        int nb2 = 0;
                        if (ReferenceTable.this.showReferTo()) {
                            size = ref2.getOwner().getRefTarget().size();
                            for (int idx4 = 0; idx4 < size; ++idx4) {
                                if (ref2.getOwner().getRefTarget().get(idx4) instanceof TRCAggregatedObjectReference) {
                                    nb2 += ((TRCAggregatedObjectReference)ref2.getOwner().getRefTarget().get(idx4)).getCount();
                                    continue;
                                }
                                ++nb2;
                            }
                        } else {
                            size = ref2.getTarget().getRefOwner().size();
                            for (int idx5 = 0; idx5 < size; ++idx5) {
                                if (ref2.getTarget().getRefOwner().get(idx5) instanceof TRCAggregatedObjectReference) {
                                    nb2 += ((TRCAggregatedObjectReference)ref2.getTarget().getRefOwner().get(idx5)).getCount();
                                    continue;
                                }
                                ++nb2;
                            }
                        }
                        return this._sortSequence * (nb1 - nb2);
                    }
                    case 4: {
                        if (!(ref1 instanceof TRCAggregatedObjectReference) || !(ref2 instanceof TRCAggregatedObjectReference)) break;
                        return this._sortSequence * (((TRCAggregatedObjectReference)ref1).getCount() - ((TRCAggregatedObjectReference)ref2).getCount());
                    }
                }
            }
            return 0;
        }
    }

    public class ClassStatisticFilter
    extends StatisticView.StatisticFilter {
        public ClassStatisticFilter() {
            super(ReferenceTable.this);
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean flag = true;
            if (!(element instanceof TRCClass)) {
                return true;
            }
            String compareText = "";
            if (this._noPattern) {
                return true;
            }
            if (element instanceof TRCClass) {
                compareText = ((TRCClass)element).getName();
            }
            if (!this._caseSensitive) {
                compareText = compareText.toLowerCase();
            }
            if (this._exactMatch) {
                return compareText.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                flag = compareText.startsWith(this._prefix);
            }
            if (flag && this._suffix != "") {
                flag = compareText.endsWith(this._suffix);
            }
            if (flag) {
                for (int k = 0; k < this._textList.size(); ++k) {
                    String str1 = (String)this._textList.get(k);
                    int index = compareText.lastIndexOf(str1);
                    if (index == -1) {
                        flag = false;
                        break;
                    }
                    compareText = compareText.substring(index + str1.length());
                }
            }
            return flag;
        }
    }
}

